/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.cpa.dca.DCAState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class InterpolationAutomaton {
    private static final boolean TARGET = true;
    private final String automatonName;
    private final FormulaManagerView fMgrView;
    private final ItpAutomatonState initState;
    private final ItpAutomatonState finalState;
    private final List<ItpAutomatonState> itpStates;
    private final ImmutableMap<BooleanFormula, ItpAutomatonState> bfToStateMap;

    InterpolationAutomaton(FormulaManagerView pMgrView, String pAutomatonName, ImmutableList<BooleanFormula> pDistinctInterpolants) {
        this.fMgrView = (FormulaManagerView)Preconditions.checkNotNull((Object)pMgrView);
        this.automatonName = (String)Preconditions.checkNotNull((Object)pAutomatonName);
        this.initState = new InitState(this);
        this.finalState = new FinalState(this);
        this.itpStates = new ArrayList<ItpAutomatonState>();
        if (pDistinctInterpolants.size() > 1) {
            throw new UnsupportedOperationException("Interpolation automata with more than one interpolants are not yet supported");
        }
        for (BooleanFormula interpolant : pDistinctInterpolants) {
            this.itpStates.add(new ItpAutomatonState(this, "itp_state: " + interpolant, interpolant, true));
        }
        this.bfToStateMap = ImmutableMap.builderWithExpectedSize((int)(this.itpStates.size() + 2)).put((Object)this.initState.getInterpolant(), (Object)this.initState).put((Object)this.finalState.getInterpolant(), (Object)this.finalState).putAll((Map)this.itpStates.stream().collect(ImmutableMap.toImmutableMap(rec$ -> ((ItpAutomatonState)rec$).getInterpolant(), (Function)Functions.identity()))).buildOrThrow();
    }

    public Automaton createAutomaton() throws InvalidAutomatonException {
        ImmutableList internalStates = ImmutableList.builderWithExpectedSize((int)(this.itpStates.size() + 3)).add((Object)this.initState.buildInternalState()).addAll((Iterable)Collections3.transformedImmutableListCopy(this.itpStates, rec$ -> ((ItpAutomatonState)rec$).buildInternalState())).add((Object)this.finalState.buildInternalState()).build();
        return new Automaton(this.automatonName, (Map<String, AutomatonVariable>)ImmutableMap.of(), (List<AutomatonInternalState>)internalStates, this.initState.getStateName());
    }

    String getAutomatonName() {
        return this.automatonName;
    }

    ImmutableList<BooleanFormula> getDistinctInterpolants() {
        return Collections3.transformedImmutableListCopy(this.itpStates, rec$ -> ((ItpAutomatonState)rec$).getInterpolant());
    }

    void addTransition(ARGState pCurrentState, BooleanFormula pCurInterpolant, ARGState pChildState, BooleanFormula pChildInterpolant) {
        Preconditions.checkArgument((boolean)this.bfToStateMap.containsKey((Object)pCurInterpolant));
        Preconditions.checkArgument((boolean)this.bfToStateMap.containsKey((Object)pChildInterpolant));
        ItpAutomatonState srcState = (ItpAutomatonState)this.bfToStateMap.get((Object)pCurInterpolant);
        ItpAutomatonState destState = (ItpAutomatonState)this.bfToStateMap.get((Object)pChildInterpolant);
        srcState.createTransitionToState(pCurrentState, pChildState, destState.getStateName());
    }

    void addTransitionToInitState(ARGState pCurrentState, BooleanFormula pCurrentInterpolant, ARGState pChildState) {
        ItpAutomatonState srcState = (ItpAutomatonState)this.bfToStateMap.get((Object)pCurrentInterpolant);
        srcState.createTransitionToState(pCurrentState, pChildState, this.initState.getStateName());
    }

    void addTransitionToFinalState(ARGState pCurrentState, BooleanFormula pCurrentInterpolant, ARGState pChildState) {
        ItpAutomatonState srcState = (ItpAutomatonState)this.bfToStateMap.get((Object)pCurrentInterpolant);
        srcState.createTransitionToState(pCurrentState, pChildState, this.finalState.getStateName());
    }

    boolean isStateCovered(ARGState pState, ARGState pChildState, BooleanFormula pInterpolant) {
        Preconditions.checkArgument((boolean)this.bfToStateMap.containsKey((Object)pInterpolant));
        return ((ItpAutomatonState)this.bfToStateMap.get((Object)pInterpolant)).isStateCovered(pState, pChildState);
    }

    void addQueryToCache(ARGState pState, ARGState pChildState, BooleanFormula pInterpolant) {
        Preconditions.checkArgument((boolean)this.bfToStateMap.containsKey((Object)pInterpolant));
        ((ItpAutomatonState)this.bfToStateMap.get((Object)pInterpolant)).addExpressionToCache(pState, pChildState);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("INTERPOLATION AUTOMATON ").append(this.automatonName).append("\n\n");
        str.append("INITIAL STATE ").append(this.initState.getStateName()).append(";\n\n");
        for (ItpAutomatonState s : this.bfToStateMap.values()) {
            str.append("STATE ").append("USEALL ").append(s.getStateName()).append(":\n");
            for (AutomatonTransition t : s.transitions) {
                str.append("    ").append(t).append("GOTO ").append(t.getFollowStateName()).append(";\n");
            }
            str.append("\n");
        }
        str.append("END AUTOMATON\n");
        return str.toString();
    }

    private class FinalState
    extends ItpAutomatonState {
        private FinalState(InterpolationAutomaton pItpAutomaton) {
            super(pItpAutomaton, "final_state", InterpolationAutomaton.this.fMgrView.getBooleanFormulaManager().makeFalse(), false);
        }

        @Override
        List<AutomatonTransition> buildInternalTransitions() {
            this.transitions.add(new AutomatonTransition.Builder(AutomatonBoolExpr.TRUE, AutomatonInternalState.BOTTOM).build());
            return ImmutableList.copyOf((Collection)this.transitions);
        }
    }

    private class InitState
    extends ItpAutomatonState {
        private InitState(InterpolationAutomaton pItpAutomaton) {
            super(pItpAutomaton, "init_state", InterpolationAutomaton.this.fMgrView.getBooleanFormulaManager().makeTrue(), true);
        }
    }

    private static class ItpAutomatonState {
        private final InterpolationAutomaton itpAutomaton;
        Set<AutomatonTransition> transitions;
        private final String stateName;
        private final BooleanFormula interpolant;
        private final boolean isTarget;
        private final @Nullable AutomatonExpression.StringExpression targetInformation;
        private Set<AutomatonBoolExpr> boolExpressions;
        private Set<AutomatonBoolExpr> coveredExpressionsCache;

        private ItpAutomatonState(InterpolationAutomaton pItpAutomaton, String pStateName, BooleanFormula pInterpolant, boolean pIsTarget) {
            this.itpAutomaton = (InterpolationAutomaton)Preconditions.checkNotNull((Object)pItpAutomaton);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pStateName) ? 1 : 0) != 0);
            this.stateName = pStateName;
            this.interpolant = (BooleanFormula)Preconditions.checkNotNull((Object)pInterpolant);
            this.isTarget = pIsTarget;
            this.targetInformation = this.isTarget ? new AutomatonExpression.StringExpression(this.itpAutomaton.getAutomatonName()) : null;
            this.boolExpressions = new HashSet<AutomatonBoolExpr>();
            this.coveredExpressionsCache = new HashSet<AutomatonBoolExpr>();
            this.transitions = new LinkedHashSet<AutomatonTransition>();
        }

        private String getStateName() {
            return this.stateName;
        }

        private AutomatonInternalState buildInternalState() {
            return new AutomatonInternalState(this.stateName, this.buildInternalTransitions(), this.isTarget, true);
        }

        private BooleanFormula getInterpolant() {
            return this.interpolant;
        }

        boolean isStateCovered(ARGState pState, ARGState pChildState) {
            Optional<AutomatonBoolExpr> boolExprOpt = this.buildAutomatonBoolExpr(pState, pChildState);
            if (boolExprOpt.isEmpty()) {
                return false;
            }
            AutomatonBoolExpr boolExpr = boolExprOpt.orElseThrow();
            return this.boolExpressions.contains(boolExpr) || this.coveredExpressionsCache.contains(boolExpr);
        }

        void addExpressionToCache(ARGState pState, ARGState pChildState) {
            Optional<AutomatonBoolExpr> boolExprOpt = this.buildAutomatonBoolExpr(pState, pChildState);
            if (boolExprOpt.isPresent()) {
                AutomatonBoolExpr boolExpr = boolExprOpt.orElseThrow();
                Preconditions.checkArgument((!this.boolExpressions.contains(boolExpr) ? 1 : 0) != 0);
                this.coveredExpressionsCache.add(boolExpr);
            }
        }

        public String toString() {
            Object join = "";
            if (!this.transitions.isEmpty()) {
                join = ":\n" + Joiner.on((String)"\n").join(this.transitions);
            }
            return this.stateName + (String)join;
        }

        private List<CFAEdge> createTransitionToState(ARGState pCurrentState, ARGState pChildState, String pNextItpState) {
            Optional<CFAEdge> singleEdgeOpt = this.handleSingleEdge(pCurrentState, pChildState, pNextItpState);
            if (singleEdgeOpt.isPresent()) {
                return ImmutableList.of((Object)singleEdgeOpt.orElseThrow());
            }
            throw new UnsupportedOperationException("AggregateBasicBlocks are currently not supported.");
        }

        private Optional<CFAEdge> handleSingleEdge(ARGState pCurrentState, ARGState pChildState, String pNextItpState) {
            CFAEdge cfaEdge = pCurrentState.getEdgeToChild(pChildState);
            if (cfaEdge == null) {
                return Optional.empty();
            }
            AutomatonBoolExpr boolExpr = this.buildAutomatonBoolExpr(cfaEdge, pChildState);
            this.addExpressionToState(boolExpr);
            this.addEdgeToTransition(boolExpr, pNextItpState);
            return Optional.of(cfaEdge);
        }

        private void addExpressionToState(AutomatonBoolExpr pBoolExpr) {
            this.coveredExpressionsCache.remove(pBoolExpr);
            this.boolExpressions.add(pBoolExpr);
        }

        private void addEdgeToTransition(AutomatonBoolExpr pBoolExpr, String pNextItpState) {
            AutomatonTransition.Builder builder = new AutomatonTransition.Builder(pBoolExpr, pNextItpState);
            if (this.targetInformation != null) {
                builder.withTargetInformation(this.targetInformation);
            }
            AutomatonTransition transition = builder.build();
            this.transitions.add(transition);
        }

        private Optional<AutomatonBoolExpr> buildAutomatonBoolExpr(ARGState pCurrentState, ARGState pChildState) {
            CFAEdge cfaEdge = pCurrentState.getEdgeToChild(pChildState);
            if (cfaEdge == null) {
                return Optional.empty();
            }
            return Optional.of(this.buildAutomatonBoolExpr(cfaEdge, pChildState));
        }

        private AutomatonBoolExpr buildAutomatonBoolExpr(CFAEdge pCfaEdge, ARGState pChildState) {
            AutomatonBoolExpr.MatchCFAEdgeNodes cfaEdgeBoolExpr = new AutomatonBoolExpr.MatchCFAEdgeNodes(pCfaEdge);
            DCAState dcaState = AbstractStates.extractStateByType(pChildState, DCAState.class);
            String buechiExpression = Joiner.on((String)"; ").join((Iterable)Collections2.transform(dcaState.getAssumptions(), AAstNode::toASTString));
            AutomatonBoolExpr.CPAQuery dcaStateQuery = new AutomatonBoolExpr.CPAQuery("DCAState", buechiExpression);
            return new AutomatonBoolExpr.And(cfaEdgeBoolExpr, dcaStateQuery);
        }

        List<AutomatonTransition> buildInternalTransitions() {
            Stream<AutomatonBoolExpr> stream = this.boolExpressions.stream().map(x -> new AutomatonBoolExpr.Negation((AutomatonBoolExpr)x));
            Optional<AutomatonBoolExpr> boolExprOpt = stream.reduce((x, y) -> new AutomatonBoolExpr.And((AutomatonBoolExpr)x, (AutomatonBoolExpr)y));
            Verify.verify((boolean)boolExprOpt.isPresent());
            AutomatonTransition transition = new AutomatonTransition.Builder(boolExprOpt.orElseThrow(), this.stateName).build();
            this.transitions.add(transition);
            return ImmutableList.copyOf(this.transitions);
        }
    }
}

