/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.automaton.InterpolationAutomaton;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.AbstractionFormula;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

public class InterpolationAutomatonBuilder {
    private static final String ITP_AUTOMATON_NAME = "ItpAut";
    private final FormulaManagerView predFormulaManagerView;
    private final PredicateAbstractionManager predicateAbstractionManager;
    private final LogManager logger;
    private final FormulaManagerView fMgrView;
    private final BooleanFormulaManagerView bFMgrView;
    private final boolean showTransitionsInFinalState;

    public InterpolationAutomatonBuilder(FormulaManagerView pFormulaManagerView, LogManager pLogger, FormulaManagerView pPredFormulaManagerView, PredicateAbstractionManager pPredicateAbstractionManager, boolean pShowTransitionsInFinalState) {
        this.fMgrView = (FormulaManagerView)Preconditions.checkNotNull((Object)pFormulaManagerView);
        this.bFMgrView = this.fMgrView.getBooleanFormulaManager();
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.predicateAbstractionManager = (PredicateAbstractionManager)Preconditions.checkNotNull((Object)pPredicateAbstractionManager);
        this.predFormulaManagerView = (FormulaManagerView)Preconditions.checkNotNull((Object)pPredFormulaManagerView);
        this.showTransitionsInFinalState = pShowTransitionsInFinalState;
    }

    public InterpolationAutomaton buildAutomatonFromPath(ARGPath pPath, List<BooleanFormula> pInterpolants, int pAutomatonIndex) {
        Preconditions.checkArgument((pPath.asStatesList().size() == pInterpolants.size() + 1 ? 1 : 0) != 0);
        ImmutableList interpolants = (ImmutableList)ImmutableList.builderWithExpectedSize((int)(pInterpolants.size() + 1)).addAll(pInterpolants).add((Object)this.bFMgrView.makeFalse()).build().stream().map(this.fMgrView::uninstantiate).collect(ImmutableList.toImmutableList());
        ImmutableList distinctInterpolants = (ImmutableList)interpolants.stream().filter(x -> !this.bFMgrView.isTrue((BooleanFormula)x)).filter(x -> !this.bFMgrView.isFalse((BooleanFormula)x)).distinct().collect(ImmutableList.toImmutableList());
        this.logger.logf(Level.INFO, "Refining the arg with automaton using the interpolants: %s", new Object[]{distinctInterpolants});
        String automatonName = ITP_AUTOMATON_NAME + pAutomatonIndex;
        UnmodifiableIterator stateIterator = pPath.asStatesList().iterator();
        UnmodifiableIterator itpIterator = interpolants.iterator();
        ARGState curState = (ARGState)stateIterator.next();
        BooleanFormula curInterpolant = (BooleanFormula)itpIterator.next();
        InterpolationAutomaton itpAutomaton = new InterpolationAutomaton(this.fMgrView, automatonName, (ImmutableList<BooleanFormula>)distinctInterpolants);
        while (stateIterator.hasNext() && itpIterator.hasNext()) {
            ARGState childState = (ARGState)stateIterator.next();
            BooleanFormula childInterpolant = (BooleanFormula)itpIterator.next();
            if (!curInterpolant.equals(childInterpolant) || this.showTransitionsInFinalState && this.bFMgrView.isFalse(curInterpolant)) {
                itpAutomaton.addTransition(curState, curInterpolant, childState, childInterpolant);
            } else {
                itpAutomaton.addQueryToCache(curState, childState, curInterpolant);
            }
            curState = childState;
            curInterpolant = childInterpolant;
        }
        Verify.verify((!stateIterator.hasNext() && !itpIterator.hasNext() ? 1 : 0) != 0);
        return itpAutomaton;
    }

    public void addAdditionalTransitions(InterpolationAutomaton pItpAutomaton, ARGPath pPath, List<BooleanFormula> pInterpolants) throws InterruptedException, CPAException {
        ImmutableList<BooleanFormula> distinctInterpolants = pItpAutomaton.getDistinctInterpolants();
        if (distinctInterpolants.size() > 1) {
            throw new UnsupportedOperationException("Automata with more than one interpolation state are not yet supported.");
        }
        BooleanFormula interpolant = (BooleanFormula)Iterables.getOnlyElement(distinctInterpolants);
        ImmutableList predicates = ImmutableList.of((Object)this.predicateAbstractionManager.getPredicateFor(interpolant));
        try {
            Verify.verify((pPath.asStatesList().size() == pInterpolants.size() + 1 ? 1 : 0) != 0);
            PathIterator pathIterator = pPath.fullPathIterator();
            Iterator<BooleanFormula> itpIterator = pInterpolants.iterator();
            while (pathIterator.hasNext() && itpIterator.hasNext()) {
                BooleanFormula curItp = this.fMgrView.uninstantiate(itpIterator.next());
                Set<String> predVariables = this.fMgrView.extractVariableNames((Formula)curItp);
                ARGState currentState = pathIterator.getAbstractState();
                if (currentState.getChildren().size() > 1) {
                    this.exploreChildren(pItpAutomaton, currentState, (ImmutableList<AbstractionPredicate>)predicates, curItp, predVariables);
                }
                pathIterator.advance();
            }
        }
        catch (SolverException e) {
            throw new CPAException(e.getMessage(), e);
        }
    }

    private void exploreChildren(InterpolationAutomaton pItpAutomaton, ARGState pRootState, ImmutableList<AbstractionPredicate> pPredicates, BooleanFormula pCurrentInterpolant, Set<String> pPredVariables) throws SolverException, InterruptedException {
        ARGState currentState = pRootState;
        Collection<ARGState> children = currentState.getChildren();
        for (ARGState childState : children) {
            Optional<BooleanFormula> result;
            if (pItpAutomaton.isStateCovered(currentState, childState, pCurrentInterpolant) || !(result = this.handleChild(pItpAutomaton, currentState, childState, pPredicates, pCurrentInterpolant, pPredVariables)).isPresent()) continue;
            this.exploreChildren(pItpAutomaton, childState, pPredicates, result.orElseThrow(), pPredVariables);
        }
    }

    private Optional<BooleanFormula> handleChild(InterpolationAutomaton pItpAutomaton, ARGState pCurrentState, ARGState pChildState, ImmutableList<AbstractionPredicate> pPredicates, BooleanFormula pCurrentInterpolant, Set<String> pPredVariables) throws SolverException, InterruptedException {
        CFANode locationNode = AbstractStates.extractLocation(pChildState);
        this.logger.logf(Level.FINE, "Checking Node: %s", new Object[]{MoreStrings.lazyString(() -> pChildState.getStateId() + ":" + locationNode)});
        PredicateAbstractState predChildState = PredicateAbstractState.getPredicateState(pChildState);
        PathFormula pathFormula = predChildState.getAbstractionFormula().getBlockFormula();
        BooleanFormula translatedFormula = this.fMgrView.translateFrom(pathFormula.getFormula(), this.predFormulaManagerView);
        pathFormula = pathFormula.withFormula(translatedFormula);
        AbstractionFormula abstractionResult = this.predicateAbstractionManager.buildAbstraction(locationNode, Optional.empty(), pathFormula.getFormula(), pathFormula, (Collection<AbstractionPredicate>)pPredicates);
        this.logger.logf(Level.FINE, "Current Itp: %s", new Object[]{pCurrentInterpolant});
        this.printHoareTriple(pPredicates, abstractionResult);
        if (abstractionResult.isTrue()) {
            pItpAutomaton.addQueryToCache(pCurrentState, pChildState, pCurrentInterpolant);
            return Optional.of(pCurrentInterpolant);
        }
        PredicateAbstractState predicateParentState = PredicateAbstractState.getPredicateState(pCurrentState);
        SSAMap ssaParent = predicateParentState.getPathFormula().getSsa();
        SSAMap ssaChild = predChildState.getPathFormula().getSsa();
        this.logger.logf(Level.FINE, "SSA-Maps: Parent-node %s, Child-node: %s     ", new Object[]{ssaParent, ssaChild});
        if (this.anyVariableModified(ssaParent, ssaChild, pPredVariables)) {
            if (this.bFMgrView.isFalse(pCurrentInterpolant)) {
                pItpAutomaton.addTransitionToFinalState(pCurrentState, pCurrentInterpolant, pChildState);
                return Optional.empty();
            }
            if (!this.bFMgrView.isTrue(pCurrentInterpolant)) {
                pItpAutomaton.addTransitionToInitState(pCurrentState, pCurrentInterpolant, pChildState);
            } else {
                pItpAutomaton.addQueryToCache(pCurrentState, pChildState, pCurrentInterpolant);
            }
            return Optional.of(this.bFMgrView.makeTrue());
        }
        AbstractionPredicate preCondition = (AbstractionPredicate)Iterables.getOnlyElement(pPredicates);
        BooleanFormula postCondition = this.fMgrView.uninstantiate(abstractionResult.asInstantiatedFormula());
        if (preCondition.getSymbolicAtom().equals(postCondition)) {
            Verify.verify((boolean)pItpAutomaton.getDistinctInterpolants().contains((Object)postCondition));
            pItpAutomaton.addTransition(pCurrentState, pCurrentInterpolant, pChildState, postCondition);
            return Optional.of(postCondition);
        }
        if (preCondition.getSymbolicAtom().equals(this.bFMgrView.not(postCondition))) {
            if (this.bFMgrView.isTrue(pCurrentInterpolant)) {
                pItpAutomaton.addQueryToCache(pCurrentState, pChildState, pCurrentInterpolant);
                return Optional.of(pCurrentInterpolant);
            }
            pItpAutomaton.addTransitionToFinalState(pCurrentState, pCurrentInterpolant, pChildState);
            return Optional.empty();
        }
        if (this.bFMgrView.isTrue(pCurrentInterpolant)) {
            pItpAutomaton.addQueryToCache(pCurrentState, pChildState, pCurrentInterpolant);
            return Optional.of(pCurrentInterpolant);
        }
        pItpAutomaton.addTransitionToInitState(pCurrentState, pCurrentInterpolant, pChildState);
        this.logger.log(Level.INFO, new Object[]{"InterpolationAutomatonBuilder: Abstraction formula has an ambiguous postcondition."});
        return Optional.of(this.bFMgrView.makeTrue());
    }

    private boolean anyVariableModified(SSAMap ssaParent, SSAMap ssaChild, Set<String> predVariables) {
        for (String variable : predVariables) {
            if (!ssaChild.containsVariable(variable) || !ssaParent.containsVariable(variable) || ssaChild.getIndex(variable) != ssaParent.getIndex(variable) + 1) continue;
            return true;
        }
        return false;
    }

    private void printHoareTriple(ImmutableList<AbstractionPredicate> pPredicates, AbstractionFormula resultFormula) {
        Object prettyPrintPredicateList = MoreStrings.lazyString(() -> FluentIterable.from((Iterable)pPredicates).transform(x -> x.getSymbolicAtom()).join(Joiner.on((String)", ")));
        this.logger.logf(Level.FINE, "[%s] --- %s --- %s", new Object[]{prettyPrintPredicateList, resultFormula.getBlockFormula(), resultFormula.asInstantiatedFormula()});
    }
}

