/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeLocationInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.SingleLocationFormulaInvariant;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.WitnessInvariantsExtractor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;

public enum InvariantsSpecificationAutomatonBuilder {
    NO_ISA{

        @Override
        public Automaton build(Automaton pAutomaton, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) {
            return pAutomaton;
        }
    }
    ,
    WITNESSBASED_ISA{
        private static final String WITNESS_AUTOMATON_NAME = "WitnessBasedISA";

        @Override
        public Automaton build(Automaton pAutomaton, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) {
            try {
                return new Automaton(WITNESS_AUTOMATON_NAME, (Map<String, AutomatonVariable>)pAutomaton.getInitialVariables(), pAutomaton.getStates(), pAutomaton.getInitialState().getName());
            }
            catch (InvalidAutomatonException e) {
                throw new RuntimeException("Changing the name of the automaton produces an incosistent automaton", e);
            }
        }
    }
    ,
    TWOSTATES_ISA{
        private static final String WITNESS_AUTOMATON_NAME = "TwoStatesISA";
        private static final String INITIAL_STATE_NAME = "Init";

        @Override
        public Automaton build(Automaton pAutomaton, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InterruptedException {
            try {
                WitnessInvariantsExtractor extractor = new WitnessInvariantsExtractor(pConfig, pAutomaton, pLogger, pCfa, pShutdownNotifier);
                Set<ExpressionTreeLocationInvariant> invariants = extractor.extractInvariantsFromReachedSet();
                return this.buildInvariantsAutomaton(pCfa, pLogger, invariants);
            }
            catch (InvalidConfigurationException | CPAException e) {
                throw new RuntimeException("Changing the name of the automaton produces an incosistent automaton", e);
            }
        }

        private Automaton buildInvariantsAutomaton(CFA pCfa, LogManager pLogger, Set<ExpressionTreeLocationInvariant> pInvariants) {
            try {
                String automatonName = WITNESS_AUTOMATON_NAME;
                String initialStateName = INITIAL_STATE_NAME;
                ImmutableList.Builder states = ImmutableList.builder();
                ImmutableList.Builder initTransitions = ImmutableList.builder();
                for (ExpressionTreeLocationInvariant invariant : pInvariants) {
                    ExpressionTree<Object> inv = invariant.asExpressionTree();
                    CExpression cExpr = inv.accept(new ToCExpressionVisitor(pCfa.getMachineModel(), pLogger));
                    if (inv instanceof LeafExpression && !((LeafExpression)inv).assumeTruth()) {
                        cExpr = new CBinaryExpressionBuilder(pCfa.getMachineModel(), pLogger).negateExpressionAndSimplify(cExpr);
                    }
                    CBinaryExpression negCExpr = new CBinaryExpressionBuilder(pCfa.getMachineModel(), pLogger).negateExpressionAndSimplify(cExpr);
                    initTransitions.add((Object)this.createTransitionWithCheckLocationAndAssumptionToError(invariant.getLocation(), (List<AExpression>)ImmutableList.of((Object)negCExpr)));
                    initTransitions.add((Object)this.createTransitionWithCheckLocationAndAssumptionToInit(invariant.getLocation(), (List<AExpression>)ImmutableList.of((Object)cExpr)));
                }
                AutomatonInternalState initState = new AutomatonInternalState(initialStateName, (List<AutomatonTransition>)initTransitions.build(), false, true, false);
                states.add((Object)initState);
                ImmutableMap vars = ImmutableMap.of();
                return new Automaton(automatonName, (Map<String, AutomatonVariable>)vars, (List<AutomatonInternalState>)states.build(), initialStateName);
            }
            catch (InvalidAutomatonException | UnrecognizedCodeException e) {
                throw new RuntimeException("The passed invariants produce an inconsistent automaton", e);
            }
        }

        private AutomatonTransition createTransitionWithCheckLocationAndAssumptionToError(CFANode pLocation, List<AExpression> pAssumptions) {
            return new AutomatonTransition.Builder(this.createQueryLocationString(pLocation), AutomatonInternalState.ERROR).withAssumptions(pAssumptions).withTargetInformation(new AutomatonExpression.StringExpression("Invariant not valid")).build();
        }

        private AutomatonTransition createTransitionWithCheckLocationAndAssumptionToInit(CFANode pLocation, List<AExpression> pAssumptions) {
            return new AutomatonTransition.Builder(this.createQueryLocationString(pLocation), INITIAL_STATE_NAME).withAssumptions(pAssumptions).build();
        }

        private AutomatonBoolExpr createQueryLocationString(CFANode pNode) {
            return new AutomatonBoolExpr.CPAQuery("location", "nodenumber==" + pNode.getNodeNumber());
        }
    }
    ,
    CFABASED_ISA{
        private static final String WITNESS_AUTOMATON_NAME = "CFABasedISA";

        @Override
        public Automaton build(Automaton pAutomaton, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InterruptedException {
            try {
                WitnessInvariantsExtractor extractor = new WitnessInvariantsExtractor(pConfig, pAutomaton, pLogger, pCfa, pShutdownNotifier);
                Set<ExpressionTreeLocationInvariant> invariants = extractor.extractInvariantsFromReachedSet();
                return this.buildInvariantsAutomaton(pCfa, pLogger, invariants);
            }
            catch (InvalidConfigurationException | CPAException e) {
                throw new RuntimeException("Changing the name of the automaton produces an incosistent automaton", e);
            }
        }

        private Automaton buildInvariantsAutomaton(CFA pCfa, LogManager pLogger, Set<ExpressionTreeLocationInvariant> pInvariants) {
            try {
                String automatonName = WITNESS_AUTOMATON_NAME;
                String initialStateName = this.createStateName(pCfa.getMainFunction());
                ImmutableList.Builder states = ImmutableList.builder();
                Set<CFANode> invariantCFANodes = this.extractCFANodes(pInvariants);
                for (CFANode node : pCfa.getAllNodes()) {
                    if (node.getNumLeavingEdges() <= 0) continue;
                    ImmutableList.Builder transitions = ImmutableList.builder();
                    for (CFAEdge leavingEdge : CFAUtils.leavingEdges(node)) {
                        CFANode successor = leavingEdge.getSuccessor();
                        boolean successorIsBottom = false;
                        if (successor.getNumLeavingEdges() == 0) {
                            successorIsBottom = true;
                        }
                        if (invariantCFANodes.contains(successor)) {
                            ExpressionTreeLocationInvariant invariant = this.getInvariantByLocation(pInvariants, successor);
                            ExpressionTree<Object> inv = invariant.asExpressionTree();
                            this.createLocationInvariantsTransitions(pCfa, pLogger, (ImmutableList.Builder<AutomatonTransition>)transitions, successor, inv, successorIsBottom);
                            continue;
                        }
                        transitions.add((Object)this.createAutomatonTransition(successor, (List<AExpression>)ImmutableList.of(), successorIsBottom));
                    }
                    AutomatonInternalState state = new AutomatonInternalState(this.createStateName(node), (List<AutomatonTransition>)transitions.build(), false, true, false);
                    states.add((Object)state);
                }
                return new Automaton(automatonName, (Map<String, AutomatonVariable>)ImmutableMap.of(), (List<AutomatonInternalState>)states.build(), initialStateName);
            }
            catch (InvalidAutomatonException | UnrecognizedCodeException e) {
                throw new RuntimeException("The passed invariants produce an inconsistent automaton", e);
            }
        }

        private void createLocationInvariantsTransitions(CFA pCfa, LogManager pLogger, ImmutableList.Builder<AutomatonTransition> pTransitions, CFANode pSuccessor, ExpressionTree<AExpression> pInvariant, boolean pSuccessorIsBottom) throws UnrecognizedCodeException {
            CExpression cExpr = pInvariant.accept(new ToCExpressionVisitor(pCfa.getMachineModel(), pLogger));
            if (pInvariant instanceof LeafExpression && !((LeafExpression)pInvariant).assumeTruth()) {
                cExpr = new CBinaryExpressionBuilder(pCfa.getMachineModel(), pLogger).negateExpressionAndSimplify(cExpr);
            }
            CBinaryExpression negCExpr = new CBinaryExpressionBuilder(pCfa.getMachineModel(), pLogger).negateExpressionAndSimplify(cExpr);
            pTransitions.add((Object)this.createAutomatonInvariantErrorTransition(pSuccessor, (List<AExpression>)ImmutableList.of((Object)negCExpr)));
            pTransitions.add((Object)this.createAutomatonTransition(pSuccessor, (List<AExpression>)ImmutableList.of((Object)cExpr), pSuccessorIsBottom));
        }

        private AutomatonTransition createAutomatonTransition(CFANode pSuccessor, List<AExpression> pAssumptions, boolean pSuccessorIsBottom) {
            if (pSuccessorIsBottom) {
                return new AutomatonTransition.Builder(this.createQueryLocationString(pSuccessor), AutomatonInternalState.BOTTOM).withAssumptions(pAssumptions).build();
            }
            return new AutomatonTransition.Builder(this.createQueryLocationString(pSuccessor), this.createStateName(pSuccessor)).withAssumptions(pAssumptions).build();
        }

        private AutomatonTransition createAutomatonInvariantErrorTransition(CFANode pSuccessor, List<AExpression> pAssumptions) {
            return new AutomatonTransition.Builder(this.createQueryLocationString(pSuccessor), this.createStateName(pSuccessor)).withAssumptions(pAssumptions).withTargetInformation(new AutomatonExpression.StringExpression("Invariant not valid")).build();
        }

        private AutomatonBoolExpr createQueryLocationString(CFANode pNode) {
            return new AutomatonBoolExpr.CPAQuery("location", "nodenumber==" + pNode.getNodeNumber());
        }

        private String createStateName(CFANode pNode) {
            return "S" + pNode.getNodeNumber();
        }

        private Set<CFANode> extractCFANodes(Set<ExpressionTreeLocationInvariant> pInvariants) {
            return Collections3.transformedImmutableSetCopy(pInvariants, SingleLocationFormulaInvariant::getLocation);
        }

        private ExpressionTreeLocationInvariant getInvariantByLocation(Set<ExpressionTreeLocationInvariant> pInvariants, CFANode pLocation) {
            return pInvariants.stream().filter(inv -> inv.getLocation().equals(pLocation)).findFirst().orElseThrow();
        }
    };


    public abstract Automaton build(Automaton var1, Configuration var2, LogManager var3, ShutdownNotifier var4, CFA var5) throws InterruptedException;
}

