/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;

class SourceLocationMatcher {
    SourceLocationMatcher() {
    }

    static class OffsetMatcher
    extends BaseFileNameMatcher {
        private final int startOffset;
        private final int endOffset;

        OffsetMatcher(Optional<String> pOriginFileName, int pStartOffset, int pEndOffset) {
            super(pOriginFileName);
            Preconditions.checkArgument((pStartOffset <= pEndOffset ? 1 : 0) != 0);
            this.startOffset = pStartOffset;
            this.endOffset = pEndOffset;
        }

        public int hashCode() {
            return Objects.hash(this.getOriginFileName(), this.startOffset, this.endOffset);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof OffsetMatcher)) {
                return false;
            }
            OffsetMatcher other = (OffsetMatcher)pObj;
            return Objects.equals(this.getOriginFileName(), other.getOriginFileName()) && this.startOffset == other.startOffset && this.endOffset == other.endOffset;
        }

        @Override
        public boolean apply(FileLocation pFileLocation) {
            int locationEndOffset = pFileLocation.getNodeOffset() + pFileLocation.getNodeLength() - 1;
            return super.apply(pFileLocation) && pFileLocation.getNodeOffset() <= this.endOffset && this.startOffset <= locationEndOffset;
        }

        @Override
        public String toString() {
            if (this.startOffset == this.endOffset) {
                return "OFFSET " + this.startOffset;
            }
            return "OFFSET " + this.startOffset + "-" + this.endOffset;
        }
    }

    static class LineMatcher
    extends BaseFileNameMatcher {
        private final int startLineNumber;
        private final int endLineNumber;
        private final boolean origin;

        public LineMatcher(Optional<String> pFileName, int pStartLineNumber, int pEndLineNumber, boolean pOrigin) {
            super(pFileName);
            Preconditions.checkArgument((pStartLineNumber <= pEndLineNumber ? 1 : 0) != 0);
            this.startLineNumber = pStartLineNumber;
            this.endLineNumber = pEndLineNumber;
            this.origin = pOrigin;
        }

        public LineMatcher(Optional<String> pFileName, int pStartLineNumber, int pEndLineNumber) {
            this(pFileName, pStartLineNumber, pEndLineNumber, true);
        }

        public int hashCode() {
            return Objects.hash(this.getOriginFileName(), this.startLineNumber, this.endLineNumber, this.origin);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof LineMatcher)) {
                return false;
            }
            LineMatcher other = (LineMatcher)pObj;
            return this.origin == other.origin && this.startLineNumber == other.startLineNumber && this.endLineNumber == other.endLineNumber && Objects.equals(this.getOriginFileName(), other.getOriginFileName());
        }

        @Override
        public boolean apply(FileLocation pFileLocation) {
            int compStartingLine = this.origin ? pFileLocation.getStartingLineInOrigin() : pFileLocation.getStartingLineNumber();
            int compEndingLine = this.origin ? pFileLocation.getEndingLineInOrigin() : pFileLocation.getEndingLineNumber();
            return super.apply(pFileLocation) && this.startLineNumber <= compEndingLine && compStartingLine <= this.endLineNumber;
        }

        @Override
        public String toString() {
            Object prefix = "LINE ";
            if (this.origin) {
                prefix = "ORIGIN " + (String)prefix;
            }
            if (this.startLineNumber == this.endLineNumber) {
                return (String)prefix + this.startLineNumber;
            }
            return (String)prefix + this.startLineNumber + "-" + this.endLineNumber;
        }
    }

    private static abstract class BaseFileNameMatcher
    implements Predicate<FileLocation> {
        private final Optional<String> originFileName;

        private BaseFileNameMatcher(Optional<String> originFileName) {
            this.originFileName = (Optional)Preconditions.checkNotNull(originFileName);
        }

        public boolean apply(FileLocation pFileLocation) {
            if (!this.originFileName.isPresent()) {
                return true;
            }
            String fileName = this.originFileName.orElseThrow();
            String fileLocationFileName = pFileLocation.getFileName().toString();
            fileName = this.getBaseName(fileName);
            fileLocationFileName = this.getBaseName(fileLocationFileName);
            return fileName.equals(fileLocationFileName);
        }

        private String getBaseName(String pOf) {
            int index = pOf.lastIndexOf(47);
            if (index == -1) {
                index = pOf.lastIndexOf(92);
            }
            if (index == -1) {
                return pOf;
            }
            return pOf.substring(index + 1);
        }

        public String toString() {
            return this.originFileName.isPresent() ? "FILE " + this.originFileName : "TRUE";
        }

        protected Optional<String> getOriginFileName() {
            return this.originFileName;
        }
    }
}

