/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.automaton.ARGToAutomatonConverter;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.util.test.AbstractTranslationTest;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

@RunWith(value=Parameterized.class)
public class ARGToAutomatonConverterTest
extends AbstractTranslationTest {
    public static final String AUTOMATA_FILE_TEMPLATE = "ARG.%06d.spc";
    private final String program;
    private final Configuration config;
    private final boolean verdict;
    private final boolean forOverflow;
    private final Path automatonPath;
    private final ARGToAutomatonConverter converter;

    public ARGToAutomatonConverterTest(String pTestLabel, String pProgram, boolean pVerdict, boolean pForOverflow) throws IOException, InvalidConfigurationException {
        this.filePrefix = "automaton";
        this.program = pProgram;
        this.verdict = pVerdict;
        this.forOverflow = pForOverflow;
        this.automatonPath = this.newTempFile();
        String propfile = this.forOverflow ? "split--overflow.properties" : "split-callstack.properties";
        ConfigurationBuilder configBuilder = TestDataTools.configurationForTest().loadFromResource(ARGToAutomatonConverterTest.class, propfile).setOption("cpa.arg.export.code.handleTargetStates", "VERIFIERERROR").setOption("cpa.arg.export.code.header", "false");
        this.config = configBuilder.build();
        this.converter = new ARGToAutomatonConverter(this.config, MachineModel.LINUX32, this.logger);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ImmutableList.Builder b = ImmutableList.builder();
        b.add((Object)ARGToAutomatonConverterTest.simpleTask("main.c", true));
        b.add((Object)ARGToAutomatonConverterTest.simpleTask("main2.c", false));
        b.add((Object)ARGToAutomatonConverterTest.simpleTask("functionreturn.c", false));
        b.add((Object)ARGToAutomatonConverterTest.simpleTaskForOverflow("overflow.c", false));
        b.add((Object)ARGToAutomatonConverterTest.simpleTaskForOverflow("no_overflow.c", true));
        return b.build();
    }

    private static Object[] simpleTask(String program, boolean verdict) {
        String label = String.format("SimpleTest(%s is %s)", program, verdict);
        return new Object[]{label, program, verdict, false};
    }

    private static Object[] simpleTaskForOverflow(String program, boolean verdict) {
        String label = String.format("SimpleTestForOverflow(%s is %s)", program, verdict);
        return new Object[]{label, program, verdict, true};
    }

    @Test
    public void test() throws Exception {
        Path fullPath = Path.of("test/programs/programtranslation/", this.program);
        this.resetCFANodeCounter();
        ARGState root = ARGToAutomatonConverterTest.run(this.config, fullPath);
        Automaton aut = this.converter.getAutomaton(root, true);
        Files.write(this.automatonPath, aut.toString().getBytes("utf-8"), new OpenOption[0]);
        for (String analysis : ImmutableList.of((Object)"predicateAnalysis.properties", (Object)"valueAnalysis.properties")) {
            if (this.forOverflow) break;
            Configuration reConfig = TestDataTools.configurationForTest().loadFromResource(ARGToAutomatonConverterTest.class, analysis).setOption("specification", this.automatonPath.toString()).build();
            TestResults results = null;
            try {
                this.resetCFANodeCounter();
                results = CPATestRunner.run(reConfig, fullPath.toString());
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                throw new AssertionError((Object)e);
            }
            Truth.assertThat((Object)results).isNotNull();
            if (this.verdict) {
                results.assertIsSafe();
            } else {
                results.assertIsUnsafe();
            }
            Iterable<Automaton> res = this.converter.getAutomata(root);
            boolean fullVerdict = true;
            for (Automaton a : res) {
                this.resetCFANodeCounter();
                Path newAutomatonPath = this.newTempFile();
                Files.write(newAutomatonPath, a.toString().getBytes("utf-8"), new OpenOption[0]);
                reConfig = TestDataTools.configurationForTest().loadFromResource(ARGToAutomatonConverterTest.class, analysis).setOption("specification", newAutomatonPath.toString()).build();
                CPAcheckerResult.Result partialVerdict = CPATestRunner.run(reConfig, fullPath.toString()).getCheckerResult().getResult();
                Truth.assertThat((Comparable)((Object)partialVerdict)).isAnyOf((Object)CPAcheckerResult.Result.TRUE, (Object)CPAcheckerResult.Result.FALSE, new Object[0]);
                fullVerdict = fullVerdict && partialVerdict.equals((Object)CPAcheckerResult.Result.TRUE);
            }
            Truth.assertThat((Boolean)fullVerdict).isEqualTo((Object)this.verdict);
        }
        if (this.forOverflow) {
            Configuration overflowConfig = TestDataTools.configurationForTest().loadFromResource(ARGToAutomatonConverterTest.class, "split--overflow.properties").build();
            TestResults results = null;
            try {
                this.resetCFANodeCounter();
                results = CPATestRunner.run(overflowConfig, fullPath.toString());
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                throw new AssertionError((Object)e);
            }
            Truth.assertThat((Object)results).isNotNull();
            if (this.verdict) {
                results.assertIsSafe();
            } else {
                results.assertIsUnsafe();
            }
        }
    }

    @Deprecated
    @SuppressForbidden(value="reflection only in test")
    private void resetCFANodeCounter() throws NoSuchFieldException, IllegalAccessException {
        Field idGenerator = CFANode.class.getDeclaredField("idGenerator");
        idGenerator.setAccessible(true);
        UniqueIdGenerator uid = (UniqueIdGenerator)idGenerator.get(null);
        Field nextId = uid.getClass().getDeclaredField("nextId");
        nextId.setAccessible(true);
        AtomicInteger i = (AtomicInteger)nextId.get(uid);
        i.set(0);
        nextId.setAccessible(false);
        idGenerator.setAccessible(false);
    }
}

