/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.ARGSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class ARGCopyOnWriteSubtreeRemover
extends ARGSubtreeRemover {
    private final boolean doPrecisionRefinementForMostInnerBlock;

    public ARGCopyOnWriteSubtreeRemover(AbstractBAMCPA bamCpa, ThreadSafeTimerContainer.TimerWrapper pRemoveCachedSubtreeTimer) {
        super(bamCpa, pRemoveCachedSubtreeTimer);
        this.doPrecisionRefinementForMostInnerBlock = bamCpa.doPrecisionRefinementForMostInnerBlock();
    }

    @Override
    void removeSubtree(ARGReachedSet pMainReachedSet, ARGPath pPath, ARGState pState, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pNewPrecisionTypes) throws InterruptedException {
        BAMSubgraphComputer.BackwardARGState cutState = (BAMSubgraphComputer.BackwardARGState)pState;
        ARGState cutPointAsArgState = this.getReachedState(cutState);
        Preconditions.checkArgument((pNewPrecisions.size() == pNewPrecisionTypes.size() ? 1 : 0) != 0);
        assert (pPath.getFirstState().getSubgraph().contains((Object)cutState));
        Map<BAMSubgraphComputer.BackwardARGState, ARGState> blockInitAndExitStates = this.getBlockInitAndExitStates(pPath.asStatesList());
        List<BAMSubgraphComputer.BackwardARGState> relevantCallStates = this.getRelevantCallStates((List<ARGState>)pPath.asStatesList(), cutState);
        if (pMainReachedSet.asReachedSet().contains(cutPointAsArgState)) {
            assert (relevantCallStates.isEmpty());
            pMainReachedSet.removeSubtree(cutPointAsArgState, pNewPrecisions, pNewPrecisionTypes);
        } else {
            assert (!relevantCallStates.isEmpty());
            BAMSubgraphComputer.BackwardARGState lastRelevantNode = (BAMSubgraphComputer.BackwardARGState)Iterables.getLast(relevantCallStates);
            ImmutableList newPrecisionsLst = Pair.zipList(pNewPrecisions, pNewPrecisionTypes);
            BAMSubgraphComputer.BackwardARGState currentCutState = cutState;
            for (BAMSubgraphComputer.BackwardARGState callState : Lists.reverse(relevantCallStates)) {
                this.logger.logf(Level.FINEST, "removing %s from reachedset with root %s", new Object[]{currentCutState, callState});
                this.removeCachedSubtreeTimer.start();
                this.handleSubtree(callState.getARGState(), (ARGState)Preconditions.checkNotNull((Object)blockInitAndExitStates.get(callState)), this.getReachedState(currentCutState), (List<Pair<Precision, Predicate<? super Precision>>>)(this.mustUpdatePrecision(lastRelevantNode, cutState, currentCutState) ? newPrecisionsLst : ImmutableList.of()));
                currentCutState = callState;
                this.removeCachedSubtreeTimer.stop();
            }
            UnmodifiableReachedSet mainReachedSet = pMainReachedSet.asReachedSet();
            if (mainReachedSet.getFirstState() == relevantCallStates.get(0).getARGState() && ((ARGState)mainReachedSet.getLastState()).getParents().contains(mainReachedSet.getFirstState())) {
                pMainReachedSet.removeSubtree((ARGState)mainReachedSet.getLastState());
            } else if (this.mustUpdatePrecision(lastRelevantNode, cutState, currentCutState)) {
                pMainReachedSet.removeSubtree(relevantCallStates.get(0).getARGState(), pNewPrecisions, pNewPrecisionTypes);
            } else {
                pMainReachedSet.removeSubtree(relevantCallStates.get(0).getARGState());
            }
        }
    }

    private boolean mustUpdatePrecision(BAMSubgraphComputer.BackwardARGState lastRelevantNode, BAMSubgraphComputer.BackwardARGState cutState, BAMSubgraphComputer.BackwardARGState currentCutState) {
        if (this.doPrecisionRefinementForAllStates) {
            return true;
        }
        if (this.doPrecisionRefinementForMostInnerBlock && Objects.equals(currentCutState, lastRelevantNode)) {
            return true;
        }
        return Objects.equals(currentCutState, cutState);
    }

    private void handleSubtree(ARGState rootState, ARGState exitState, ARGState cutState, List<Pair<Precision, Predicate<? super Precision>>> pPrecisionsLst) {
        ReachedSet reached = this.data.getReachedSetForInitialState(rootState, exitState);
        assert (reached.contains(cutState)) : String.format("cutState %s is not in reached-set with root %s.", cutState, reached.getFirstState());
        assert (reached.contains(exitState)) : String.format("exitState %s is not in reached-set with root %s.", exitState, reached.getFirstState());
        ReachedSet clone = this.cloneReachedSetPartially(reached, cutState, pPrecisionsLst);
        Block block = this.partitioning.getBlockForCallNode(AbstractStates.extractLocation(rootState));
        this.data.getCache().put(clone.getFirstState(), clone.getPrecision(clone.getFirstState()), block, clone);
    }

    private ReachedSet cloneReachedSetPartially(ReachedSet pReached, ARGState cutState, List<Pair<Precision, Predicate<? super Precision>>> pPrecisionsLst) {
        assert (pReached.contains(cutState));
        ImmutableSortedSet reachedStates = ((ARGState)pReached.getFirstState()).getSubgraph().toSortedSet(Comparator.naturalOrder());
        Set<ARGState> toRemove = ARGCopyOnWriteSubtreeRemover.getStatesToRemove(cutState);
        Predicate keepStates = s -> !toRemove.contains(s);
        assert (reachedStates.size() > toRemove.size()) : "removing all states is not possible";
        assert (reachedStates.containsAll(pReached.asCollection())) : "reachedset should be subset of all states";
        assert (reachedStates.containsAll(toRemove)) : "states to be removed should be subset of all states";
        Map<ARGState, ARGState> cloneMapping = ARGCopyOnWriteSubtreeRemover.cloneARG((Set<ARGState>)reachedStates, (Predicate<AbstractState>)keepStates);
        this.updateBAMData(cloneMapping);
        ReachedSet clonedReached = this.buildClonedReachedSet(pReached, pPrecisionsLst, (Predicate<AbstractState>)keepStates, cloneMapping);
        this.logger.log(Level.ALL, new Object[]{Collections2.transform(cloneMapping.entrySet(), e -> ((ARGState)e.getKey()).getStateId() + "-" + ((ARGState)e.getValue()).getStateId())});
        assert (clonedReached.size() < pReached.size());
        return clonedReached;
    }

    private static Set<ARGState> getStatesToRemove(ARGState cutState) {
        ImmutableList toRemove = cutState.getSubgraph().toList();
        return FluentIterable.from((Iterable)toRemove).transformAndConcat(ARGState::getCoveredByThis).append((Iterable)toRemove).toSet();
    }

    private static Map<ARGState, ARGState> cloneARG(Set<ARGState> reachedStates, Predicate<AbstractState> keepStates) {
        LinkedHashMap<ARGState, ARGState> cloneMapping = new LinkedHashMap<ARGState, ARGState>();
        for (AbstractState abstractState : Iterables.filter(reachedStates, keepStates)) {
            ARGState state = (ARGState)abstractState;
            ARGState clonedState = new ARGState(state.getWrappedState(), null);
            cloneMapping.put(state, clonedState);
        }
        for (Map.Entry entry : cloneMapping.entrySet()) {
            for (ARGState parent : Iterables.filter(((ARGState)entry.getKey()).getParents(), keepStates)) {
                ((ARGState)entry.getValue()).addParent((ARGState)cloneMapping.get(parent));
            }
        }
        for (Map.Entry entry : cloneMapping.entrySet()) {
            for (ARGState covered : Iterables.filter(((ARGState)entry.getKey()).getCoveredByThis(), keepStates)) {
                ((ARGState)cloneMapping.get(covered)).setCovered((ARGState)cloneMapping.get(entry.getKey()));
            }
        }
        return cloneMapping;
    }

    private void updateBAMData(Map<ARGState, ARGState> cloneMapping) {
        for (Map.Entry<ARGState, ARGState> e : cloneMapping.entrySet()) {
            ARGState state = e.getKey();
            ARGState clonedState = e.getValue();
            if (this.data.hasInitialState(state)) {
                for (ARGState child : state.getChildren()) {
                    assert (this.data.hasExpandedState(child));
                    ARGState reducedExitState = (ARGState)this.data.getReducedStateForExpandedState(child);
                    ReachedSet reached = this.data.getReachedSetForInitialState(state, reducedExitState);
                    this.data.registerInitialState(clonedState, reducedExitState, reached);
                }
            }
            if (!this.data.hasExpandedState(state)) continue;
            this.data.registerExpandedState(clonedState, this.data.getExpandedPrecisionForState(state), this.data.getReducedStateForExpandedState(state), this.data.getInnerBlockForExpandedState(state));
        }
    }

    private ReachedSet buildClonedReachedSet(ReachedSet pReached, List<Pair<Precision, Predicate<? super Precision>>> pPrecisionsLst, Predicate<AbstractState> keepStates, Map<ARGState, ARGState> cloneMapping) {
        Verify.verify((pReached.getCPA() == this.bamCpa ? 1 : 0) != 0, (String)"all reached-sets should be created with the same CPA.", (Object[])new Object[0]);
        ReachedSet clonedReached = this.data.getReachedSetFactory().create(this.bamCpa);
        for (AbstractState abstractState : Iterables.filter((Iterable)pReached, keepStates)) {
            ARGState state = (ARGState)abstractState;
            ARGState clonedState = cloneMapping.get(state);
            clonedReached.add(clonedState, pReached.getPrecision(state));
            boolean isStateFinished = !pReached.getWaitlist().contains(state);
            isStateFinished &= Iterables.all(state.getParents(), keepStates);
            if (isStateFinished &= Iterables.all(state.getChildren(), keepStates)) {
                clonedReached.removeOnlyFromWaitlist(clonedState);
                clonedState.markExpanded();
                continue;
            }
            clonedReached.updatePrecision(clonedState, ARGCopyOnWriteSubtreeRemover.updatePrecision(pReached.getPrecision(state), pPrecisionsLst));
        }
        return clonedReached;
    }

    private static Precision updatePrecision(Precision statePrec, List<Pair<Precision, Predicate<? super Precision>>> pPrecisionsLst) {
        Preconditions.checkNotNull((Object)statePrec);
        for (Pair<Precision, Predicate<? super Precision>> p : pPrecisionsLst) {
            Precision adaptedPrec = Precisions.replaceByType(statePrec, p.getFirst(), p.getSecond());
            if (adaptedPrec != null) {
                statePrec = adaptedPrec;
            }
            Preconditions.checkNotNull((Object)statePrec);
        }
        return statePrec;
    }
}

