/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.ARGSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCacheAggressiveImpl;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class ARGInPlaceSubtreeRemover
extends ARGSubtreeRemover {
    public ARGInPlaceSubtreeRemover(AbstractBAMCPA bamCpa, ThreadSafeTimerContainer.TimerWrapper pRemoveCachedSubtreeTimer) {
        super(bamCpa, pRemoveCachedSubtreeTimer);
    }

    @Override
    void removeSubtree(ARGReachedSet mainReachedSet, ARGPath pPath, ARGState element, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pNewPrecisionTypes) throws InterruptedException {
        BAMSubgraphComputer.BackwardARGState cutPoint = (BAMSubgraphComputer.BackwardARGState)element;
        ARGState cutPointAsArgState = this.getReachedState(cutPoint);
        ARGState firstState = (ARGState)mainReachedSet.asReachedSet().getFirstState();
        ARGState lastState = (ARGState)mainReachedSet.asReachedSet().getLastState();
        assert (((ARGState)pPath.asStatesList().get(0)).getWrappedState() == firstState) : "path should start with root state";
        assert (((ARGState)Iterables.getLast(pPath.asStatesList())).getWrappedState() == lastState) : "path should end with target state";
        assert (lastState.isTarget());
        Map<BAMSubgraphComputer.BackwardARGState, ARGState> blockInitAndExitStates = this.getBlockInitAndExitStates(pPath.asStatesList());
        List<BAMSubgraphComputer.BackwardARGState> relevantCallStates = this.getRelevantCallStates((List<ARGState>)pPath.asStatesList(), cutPoint);
        LinkedHashMultimap neededRemoveCachedSubtreeCalls = LinkedHashMultimap.create();
        for (int i = 0; i < relevantCallStates.size() - 1; ++i) {
            BAMSubgraphComputer.BackwardARGState pathElement = relevantCallStates.get(i);
            BAMSubgraphComputer.BackwardARGState nextElement = relevantCallStates.get(i + 1);
            neededRemoveCachedSubtreeCalls.put((Object)pathElement, (Object)this.getReachedState(nextElement));
        }
        if (this.bamCache instanceof BAMCacheAggressiveImpl) {
            this.ensureExactCacheHitsOnPath(pPath, cutPoint, pNewPrecisions, (Multimap<BAMSubgraphComputer.BackwardARGState, ARGState>)neededRemoveCachedSubtreeCalls, mainReachedSet.asReachedSet(), blockInitAndExitStates);
        }
        for (Map.Entry removeCachedSubtreeArguments : neededRemoveCachedSubtreeCalls.entries()) {
            BAMSubgraphComputer.BackwardARGState bamState = (BAMSubgraphComputer.BackwardARGState)removeCachedSubtreeArguments.getKey();
            assert (this.data.hasInitialState(bamState.getARGState()));
            assert (this.data.getReachedSetForInitialState(bamState.getARGState(), blockInitAndExitStates.get(bamState)).contains((AbstractState)removeCachedSubtreeArguments.getValue()));
        }
        if (mainReachedSet.asReachedSet().contains(cutPointAsArgState)) {
            assert (relevantCallStates.isEmpty());
            mainReachedSet.removeSubtree(cutPointAsArgState, pNewPrecisions, pNewPrecisionTypes);
        } else {
            assert (!relevantCallStates.isEmpty());
            BAMSubgraphComputer.BackwardARGState lastRelevantState = (BAMSubgraphComputer.BackwardARGState)Iterables.getLast(relevantCallStates);
            this.removeCachedSubtree(this.getReachedState(lastRelevantState), blockInitAndExitStates.get(lastRelevantState), this.getReachedState(cutPoint), pNewPrecisions, pNewPrecisionTypes);
            ARGState lastRelevantNode = this.getReachedState((ARGState)Iterables.getLast(relevantCallStates));
            Function<ARGState, Pair> precUpdate = stateToRemove -> {
                assert (!(stateToRemove instanceof BAMSubgraphComputer.BackwardARGState));
                if (this.mustUpdatePrecision(lastRelevantNode, this.getReachedState(element), (ARGState)stateToRemove)) {
                    return Pair.of(pNewPrecisions, pNewPrecisionTypes);
                }
                return Pair.of(ImmutableList.of(), ImmutableList.of());
            };
            for (Map.Entry removeCachedSubtreeArguments : neededRemoveCachedSubtreeCalls.entries()) {
                ARGState stateToRemove2 = (ARGState)removeCachedSubtreeArguments.getValue();
                BAMSubgraphComputer.BackwardARGState rootState = (BAMSubgraphComputer.BackwardARGState)removeCachedSubtreeArguments.getKey();
                Pair p = precUpdate.apply(stateToRemove2);
                this.removeCachedSubtreeIfPossible(this.getReachedState(rootState), blockInitAndExitStates.get(rootState), stateToRemove2, (List)p.getFirst(), (List)p.getSecond());
            }
            if (Objects.equals(firstState, relevantCallStates.get(0).getARGState()) && AbstractStates.isTargetState(lastState)) {
                assert (firstState.getChildren().contains(lastState));
                mainReachedSet.removeSubtree(lastState);
            } else {
                BAMSubgraphComputer.BackwardARGState stateToRemove3 = relevantCallStates.get(0);
                Pair p = precUpdate.apply(stateToRemove3.getARGState());
                mainReachedSet.removeSubtree(stateToRemove3.getARGState(), (List)p.getFirst(), (List)p.getSecond());
            }
        }
    }

    private boolean mustUpdatePrecision(ARGState lastRelevantNode, ARGState target, ARGState stateToRemove) {
        return this.doPrecisionRefinementForAllStates || Objects.equals(stateToRemove, lastRelevantNode) || this.data.hasInitialState(stateToRemove) && !target.getParents().isEmpty() && Iterables.all(target.getParents(), p -> p.getParents().isEmpty());
    }

    static void removeSubtree(ARGReachedSet reachedSet, ARGState argElement) throws InterruptedException {
        if (AbstractBAMTransferRelation.isHeadOfMainFunction(AbstractStates.extractLocation(argElement))) {
            assert (((ARGState)reachedSet.asReachedSet().getFirstState()).getChildren().contains(reachedSet.asReachedSet().getLastState()));
            reachedSet.removeSubtree((ARGState)reachedSet.asReachedSet().getLastState());
        } else {
            reachedSet.removeSubtree(argElement);
        }
    }

    private void removeCachedSubtreeIfPossible(ARGState rootState, ARGState exitState, ARGState removeElement, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) throws InterruptedException {
        if (removeElement.isDestroyed()) {
            this.logger.log(Level.FINER, new Object[]{"state was destroyed before"});
        } else {
            this.removeCachedSubtree(rootState, exitState, removeElement, pNewPrecisions, pPrecisionTypes);
        }
    }

    private void removeCachedSubtree(ARGState rootState, ARGState exitState, ARGState removeElement, List<Precision> pNewPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) throws InterruptedException {
        Precision reducedRootPrecision;
        assert (pNewPrecisions.size() == pPrecisionTypes.size());
        this.removeCachedSubtreeTimer.start();
        this.logger.log(Level.FINER, new Object[]{"Remove cached subtree for", removeElement, " issued with precision", pNewPrecisions});
        CFANode rootNode = AbstractStates.extractLocation(rootState);
        Block rootSubtree = this.partitioning.getBlockForCallNode(rootNode);
        ReachedSet reachedSet = this.data.getReachedSetForInitialState(rootState, exitState);
        assert (reachedSet.contains(removeElement)) : "removing state from wrong reachedSet: " + removeElement;
        assert (!removeElement.getParents().isEmpty());
        AbstractState reducedRootState = this.wrappedReducer.getVariableReducedState(rootState, rootSubtree, rootNode);
        BAMCache.BAMCacheEntry entry = this.bamCache.get(reducedRootState, reducedRootPrecision = reachedSet.getPrecision(reachedSet.getFirstState()), rootSubtree);
        if (entry != null) {
            entry.deleteInfo();
        }
        ARGReachedSet argReachedSet = new ARGReachedSet(reachedSet);
        if (pNewPrecisions.isEmpty()) {
            ARGInPlaceSubtreeRemover.removeSubtree(argReachedSet, removeElement);
        } else {
            Pair<Precision, Predicate<? super Precision>> newPrecision = this.getUpdatedPrecision(reachedSet.getPrecision(removeElement), pNewPrecisions, pPrecisionTypes);
            if (removeElement.getParents().contains(reachedSet.getFirstState())) {
                this.logger.log(Level.FINER, new Object[]{"creating reached-set with new precision"});
                Precision reducedPrecision = this.wrappedReducer.getVariableReducedPrecision(newPrecision.getFirst(), rootSubtree);
                this.data.createAndRegisterNewReachedSet(reducedRootState, reducedPrecision, rootSubtree);
            } else {
                argReachedSet.removeSubtree(removeElement, newPrecision.getFirst(), newPrecision.getSecond());
            }
        }
        this.removeCachedSubtreeTimer.stop();
    }

    private Pair<Precision, Predicate<? super Precision>> getUpdatedPrecision(Precision removePrecision, List<Precision> precisions, List<Predicate<? super Precision>> precisionTypes) {
        assert (precisions.size() == precisionTypes.size() && !precisions.isEmpty());
        for (int i = 0; i < precisions.size(); ++i) {
            removePrecision = Precisions.replaceByType(removePrecision, precisions.get(i), precisionTypes.get(i));
        }
        return Pair.of(removePrecision, Predicates.instanceOf(removePrecision.getClass()));
    }

    private void ensureExactCacheHitsOnPath(ARGPath pPath, BAMSubgraphComputer.BackwardARGState pElement, List<Precision> pNewPrecisions, Multimap<BAMSubgraphComputer.BackwardARGState, ARGState> neededRemoveCachedSubtreeCalls, UnmodifiableReachedSet pMainReachedSet, Map<BAMSubgraphComputer.BackwardARGState, ARGState> blockInitAndExitStates) throws InterruptedException {
        boolean cutStateFound = false;
        ArrayDeque<Boolean> needsNewPrecisionEntries = new ArrayDeque<Boolean>();
        ArrayDeque<Boolean> foundInnerUnpreciseEntries = new ArrayDeque<Boolean>();
        ArrayDeque<BAMSubgraphComputer.BackwardARGState> rootStates = new ArrayDeque<BAMSubgraphComputer.BackwardARGState>();
        needsNewPrecisionEntries.add(false);
        foundInnerUnpreciseEntries.add(false);
        rootStates.add((BAMSubgraphComputer.BackwardARGState)pPath.getFirstState());
        for (ARGState pathState : pPath.asStatesList()) {
            UnmodifiableReachedSet openReachedSet;
            BAMSubgraphComputer.BackwardARGState bamState = (BAMSubgraphComputer.BackwardARGState)pathState;
            assert (needsNewPrecisionEntries.size() == foundInnerUnpreciseEntries.size());
            assert (needsNewPrecisionEntries.size() == rootStates.size());
            if (bamState.equals(pElement)) {
                cutStateFound = true;
            }
            for (AbstractState tmp : this.data.getExpandedStatesList(bamState.getARGState())) {
                AbstractState reducedExitState = this.data.getReducedStateForExpandedState(tmp);
                boolean isNewPrecisionEntry = (Boolean)needsNewPrecisionEntries.removeLast();
                boolean isNewPrecisionEntryForOuterBlock = (Boolean)needsNewPrecisionEntries.getLast();
                boolean removedUnpreciseInnerBlock = (Boolean)foundInnerUnpreciseEntries.removeLast();
                boolean foundInnerUnpreciseEntry = (Boolean)foundInnerUnpreciseEntries.getLast();
                BAMSubgraphComputer.BackwardARGState rootState = (BAMSubgraphComputer.BackwardARGState)rootStates.removeLast();
                if (!removedUnpreciseInnerBlock && !isNewPrecisionEntry || isNewPrecisionEntryForOuterBlock || foundInnerUnpreciseEntry) continue;
                if (cutStateFound) {
                    neededRemoveCachedSubtreeCalls.put((Object)rootState, (Object)((ARGState)reducedExitState));
                }
                assert (this.data.getReachedSetForInitialState(rootState.getARGState(), blockInitAndExitStates.get(rootState)).contains(reducedExitState)) : "reachedset for initial state " + rootState.getARGState() + " does not contain state " + reducedExitState;
                foundInnerUnpreciseEntries.removeLast();
                foundInnerUnpreciseEntries.addLast(true);
            }
            if (!this.data.hasInitialState(bamState.getARGState())) continue;
            if (((BAMSubgraphComputer.BackwardARGState)rootStates.getLast()).getWrappedState() == pMainReachedSet.getFirstState()) {
                openReachedSet = pMainReachedSet;
            } else {
                ARGState initialState = ((BAMSubgraphComputer.BackwardARGState)rootStates.getLast()).getARGState();
                openReachedSet = this.data.getReachedSetForInitialState(initialState, blockInitAndExitStates.get(rootStates.getLast()));
            }
            boolean preciseEntry = !cutStateFound || this.createNewPreciseEntry(bamState, pNewPrecisions, openReachedSet, blockInitAndExitStates);
            needsNewPrecisionEntries.addLast(preciseEntry);
            foundInnerUnpreciseEntries.addLast(false);
            rootStates.addLast(bamState);
        }
        assert (!((Boolean)Iterables.getOnlyElement(needsNewPrecisionEntries)).booleanValue());
        assert (Objects.equals(rootStates.getLast(), pPath.getFirstState()));
    }

    private boolean createNewPreciseEntry(BAMSubgraphComputer.BackwardARGState rootState, List<Precision> pNewPrecisions, UnmodifiableReachedSet outerReachedSet, Map<BAMSubgraphComputer.BackwardARGState, ARGState> blockInitAndExitStates) throws InterruptedException {
        ReachedSet innerReachedSet;
        Precision usedPrecision;
        Precision reducedNewPrecision;
        ARGState initialState = rootState.getARGState();
        Precision rootPrecision = outerReachedSet.getPrecision(initialState);
        for (Precision pNewPrecision : pNewPrecisions) {
            Precision tmp = Precisions.replaceByType(rootPrecision, pNewPrecision, (Predicate<? super Precision>)Predicates.instanceOf(pNewPrecision.getClass()));
            if (tmp == null) continue;
            rootPrecision = tmp;
        }
        assert (rootPrecision != null);
        CFANode node = AbstractStates.extractLocation(rootState);
        Block context = this.partitioning.getBlockForCallNode(node);
        AbstractState reducedRootState = this.wrappedReducer.getVariableReducedState(this.getReachedState(rootState), context, node);
        if (!this.bamCache.containsPreciseKey(reducedRootState, reducedNewPrecision = this.wrappedReducer.getVariableReducedPrecision(rootPrecision, context), context)) {
            this.data.createAndRegisterNewReachedSet(reducedRootState, reducedNewPrecision, context);
        }
        boolean isNewPrecisionEntry = !(usedPrecision = (innerReachedSet = this.data.getReachedSetForInitialState(initialState, blockInitAndExitStates.get(rootState))).getPrecision(innerReachedSet.getFirstState())).equals(reducedNewPrecision);
        return isNewPrecisionEntry;
    }
}

