/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public abstract class ARGSubtreeRemover {
    protected final BlockPartitioning partitioning;
    protected final AbstractBAMCPA bamCpa;
    protected final BAMDataManager data;
    protected final Reducer wrappedReducer;
    protected final BAMCache bamCache;
    protected final LogManager logger;
    protected final ThreadSafeTimerContainer.TimerWrapper removeCachedSubtreeTimer;
    protected final boolean doPrecisionRefinementForAllStates;

    protected ARGSubtreeRemover(AbstractBAMCPA bamCpa, ThreadSafeTimerContainer.TimerWrapper pRemoveCachedSubtreeTimer) {
        this.partitioning = bamCpa.getBlockPartitioning();
        this.bamCpa = bamCpa;
        this.data = bamCpa.getData();
        this.wrappedReducer = bamCpa.getReducer();
        this.bamCache = bamCpa.getData().getCache();
        this.logger = bamCpa.getLogger();
        this.removeCachedSubtreeTimer = pRemoveCachedSubtreeTimer;
        this.doPrecisionRefinementForAllStates = bamCpa.doPrecisionRefinementForAllStates();
    }

    abstract void removeSubtree(ARGReachedSet var1, ARGPath var2, ARGState var3, List<Precision> var4, List<Predicate<? super Precision>> var5) throws InterruptedException;

    protected ARGState getReachedState(ARGState state) {
        return (ARGState)this.data.getInnermostState(((BAMSubgraphComputer.BackwardARGState)state).getARGState());
    }

    protected Map<BAMSubgraphComputer.BackwardARGState, ARGState> getBlockInitAndExitStates(ImmutableList<ARGState> path) {
        LinkedHashMap<BAMSubgraphComputer.BackwardARGState, ARGState> blockInitAndExitStates = new LinkedHashMap<BAMSubgraphComputer.BackwardARGState, ARGState>();
        ArrayDeque<BAMSubgraphComputer.BackwardARGState> openCallStates = new ArrayDeque<BAMSubgraphComputer.BackwardARGState>();
        for (ARGState bamState : path) {
            ARGState state = ((BAMSubgraphComputer.BackwardARGState)bamState).getARGState();
            for (AbstractState exitState : this.data.getExpandedStatesList(state)) {
                BAMSubgraphComputer.BackwardARGState initialState = (BAMSubgraphComputer.BackwardARGState)openCallStates.pop();
                AbstractState reducedExitState = this.data.getReducedStateForExpandedState(exitState);
                assert (null != this.data.getReachedSetForInitialState(initialState.getWrappedState(), reducedExitState));
                blockInitAndExitStates.put(initialState, (ARGState)reducedExitState);
            }
            if (!this.data.hasInitialState(state)) continue;
            assert (this.partitioning.isCallNode(AbstractStates.extractLocation(state))) : "the mapping of initial state to reached-set should only exist for block-start-locations";
            openCallStates.push((BAMSubgraphComputer.BackwardARGState)bamState);
        }
        assert (openCallStates.isEmpty()) : "empty callstack expected after traversing the path: " + openCallStates;
        return blockInitAndExitStates;
    }

    protected List<BAMSubgraphComputer.BackwardARGState> getRelevantCallStates(List<ARGState> path, ARGState bamCutState) {
        ArrayDeque<BAMSubgraphComputer.BackwardARGState> openCallStates = new ArrayDeque<BAMSubgraphComputer.BackwardARGState>();
        for (ARGState pathState : path) {
            ARGState state;
            BAMSubgraphComputer.BackwardARGState bamState = (BAMSubgraphComputer.BackwardARGState)pathState;
            ARGState tmp = state = bamState.getARGState();
            while (this.data.hasExpandedState(tmp) && !bamCutState.equals(bamState)) {
                assert (this.partitioning.isReturnNode(AbstractStates.extractLocation(tmp))) : "the mapping of expanded to reduced state should only exist for block-return-locations";
                tmp = (ARGState)this.data.getReducedStateForExpandedState(tmp);
                openCallStates.removeLast();
            }
            if (bamCutState.equals(bamState)) break;
            if (!this.data.hasInitialState(state)) continue;
            assert (this.partitioning.isCallNode(AbstractStates.extractLocation(state))) : "the mapping of initial state to reached-set should only exist for block-start-locations";
            openCallStates.addLast(bamState);
        }
        return new ArrayList<BAMSubgraphComputer.BackwardARGState>(openCallStates);
    }
}

