/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.BlockToDotWriter;
import org.sosy_lab.cpachecker.cfa.blocks.builder.BlockPartitioningBuilder;
import org.sosy_lab.cpachecker.cfa.blocks.builder.FunctionAndLoopPartitioning;
import org.sosy_lab.cpachecker.cfa.blocks.builder.PartitioningHeuristic;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGStatistics;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGStatistics;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAStatistics;
import org.sosy_lab.cpachecker.cpa.bam.BAMMergeOperator;
import org.sosy_lab.cpachecker.cpa.bam.BAMReachedSetExporter;
import org.sosy_lab.cpachecker.cpa.bam.TimedReducer;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.bam")
public abstract class AbstractBAMCPA
extends AbstractSingleWrapperCPA {
    @Option(secure=true, description="Type of partitioning (FunctionAndLoopPartitioning or DelayedFunctionAndLoopPartitioning)\nor any class that implements a PartitioningHeuristic")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker.cfa.blocks.builder"})
    private PartitioningHeuristic.Factory blockHeuristic = FunctionAndLoopPartitioning::new;
    @Option(secure=true, description="export blocks")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportBlocksPath = Path.of("block_cfa.dot", new String[0]);
    @Option(secure=true, description="This flag determines which precisions should be updated during refinement. We can choose between the minimum number of states and all states that are necessary to re-explore the program along the error-path.")
    private boolean doPrecisionRefinementForAllStates = false;
    @Option(secure=true, description="Heuristic: This flag determines which precisions should be updated during refinement. This flag also updates the precision of the most inner block.")
    private boolean doPrecisionRefinementForMostInnerBlock = true;
    @Option(secure=true, description="In some cases BAM cache can not be easily applied. If the option is enabled CPAs can inform BAM that the result states should not be used even if there will a cache hit.")
    private boolean useDynamicAdjustment = false;
    @Option(secure=true, description="This flag determines which refinement procedure we should use. We can choose between an in-place refinement and a copy-on-write refinement.")
    private boolean useCopyOnWriteRefinement = false;
    @Option(secure=true, description="By default, the CPA algorithm terminates when finding the first target state, which makes it easy to identify this last state. For special analyses, we need to search for more target states in the reached-set, when reaching a block-exit. This flag is needed if the option 'cpa.automaton.breakOnTargetState' is unequal to 1.")
    private boolean searchTargetStatesOnExit = false;
    final Timer blockPartitioningTimer = new Timer();
    final TimedReducer.ReducerStatistics reducerStatistics;
    protected final LogManager logger;
    protected final ShutdownNotifier shutdownNotifier;
    protected final BlockPartitioning blockPartitioning;
    private final BAMCPAStatistics stats;
    private final BAMARGStatistics argStats;
    private final BAMReachedSetExporter exporter;

    protected AbstractBAMCPA(ConfigurableProgramAnalysis pCpa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException, CPAException {
        super(pCpa);
        pConfig.inject((Object)this, AbstractBAMCPA.class);
        if (!(pCpa instanceof ConfigurableProgramAnalysisWithBAM)) {
            throw new InvalidConfigurationException("BAM needs CPAs that are capable for BAM");
        }
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.blockPartitioningTimer.start();
        this.blockPartitioning = this.buildBlockPartitioning(pCfa, pConfig);
        this.blockPartitioningTimer.stop();
        this.argStats = new BAMARGStatistics(pConfig, pLogger, this, pCpa, pSpecification, pCfa);
        this.exporter = new BAMReachedSetExporter(pConfig, pLogger, this);
        this.stats = new BAMCPAStatistics(pConfig, pLogger, this);
        this.reducerStatistics = new TimedReducer.ReducerStatistics();
        this.getWrappedCpa().getReducer();
    }

    private BlockPartitioning buildBlockPartitioning(CFA pCfa, Configuration pConfig) throws InvalidConfigurationException, CPAException {
        BlockPartitioningBuilder blockBuilder = new BlockPartitioningBuilder();
        PartitioningHeuristic heuristic = this.blockHeuristic.create(this.logger, pCfa, pConfig);
        BlockPartitioning partitioning = heuristic.buildPartitioning(blockBuilder);
        if (this.exportBlocksPath != null) {
            BlockToDotWriter writer = new BlockToDotWriter(partitioning);
            writer.dump(this.exportBlocksPath, this.logger);
        }
        this.getWrappedCpa().setPartitioning(partitioning);
        return partitioning;
    }

    @Override
    protected ConfigurableProgramAnalysisWithBAM getWrappedCpa() {
        return (ConfigurableProgramAnalysisWithBAM)super.getWrappedCpa();
    }

    public BlockPartitioning getBlockPartitioning() {
        return (BlockPartitioning)Preconditions.checkNotNull((Object)this.blockPartitioning);
    }

    LogManager getLogger() {
        return this.logger;
    }

    TimedReducer getReducer() {
        try {
            return new TimedReducer(this.reducerStatistics, this.getWrappedCpa().getReducer());
        }
        catch (InvalidConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public BAMMergeOperator getMergeOperator() {
        return new BAMMergeOperator(this.getWrappedCpa().getMergeOperator());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        assert (!Iterables.any(pStatsCollection, (Predicate)Predicates.instanceOf(ARGStatistics.class))) : "exporting ARGs should only be done at this place, when using BAM.";
        pStatsCollection.add(this.stats);
        pStatsCollection.add(this.argStats);
        pStatsCollection.add(this.exporter);
        pStatsCollection.add(this.getData().getCache());
        super.collectStatistics(pStatsCollection);
    }

    BAMCPAStatistics getStatistics() {
        return this.stats;
    }

    public abstract BAMDataManager getData();

    boolean doPrecisionRefinementForAllStates() {
        return this.doPrecisionRefinementForAllStates;
    }

    boolean doPrecisionRefinementForMostInnerBlock() {
        return this.doPrecisionRefinementForMostInnerBlock;
    }

    boolean useCopyOnWriteRefinement() {
        return this.useCopyOnWriteRefinement;
    }

    boolean useDynamicAdjustment() {
        return this.useDynamicAdjustment;
    }

    public boolean searchTargetStatesOnExit() {
        return this.searchTargetStatesOnExit;
    }
}

