/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.RecursiveAnalysisFailedException;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public abstract class AbstractBAMTransferRelation<EX extends CPAException>
extends AbstractSingleWrapperTransferRelation
implements TransferRelation {
    final BAMDataManager data;
    protected final BlockPartitioning partitioning;
    protected final LogManager logger;
    protected final Reducer wrappedReducer;
    protected final ShutdownNotifier shutdownNotifier;
    private final boolean useDynamicAdjustment;

    protected AbstractBAMTransferRelation(AbstractBAMCPA pBamCPA, ShutdownNotifier pShutdownNotifier) {
        super(pBamCPA.getWrappedCpa().getTransferRelation());
        this.logger = pBamCPA.getLogger();
        this.wrappedReducer = pBamCPA.getReducer();
        this.data = pBamCPA.getData();
        this.partitioning = pBamCPA.getBlockPartitioning();
        this.shutdownNotifier = pShutdownNotifier;
        this.useDynamicAdjustment = pBamCPA.useDynamicAdjustment();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        try {
            Collection<AbstractState> successors = this.getAbstractSuccessorsWithoutWrapping(pState, pPrecision);
            return successors;
        }
        catch (CPAException e) {
            throw new RecursiveAnalysisFailedException(e);
        }
    }

    protected Collection<? extends AbstractState> getAbstractSuccessorsWithoutWrapping(AbstractState pState, Precision pPrecision) throws EX, InterruptedException, CPATransferException {
        this.shutdownNotifier.shutdownIfNecessary();
        CFANode node = AbstractStates.extractLocation(pState);
        ARGState argState = (ARGState)pState;
        if (this.exitBlockAnalysis(argState, node)) {
            return ImmutableSet.of();
        }
        if (this.startNewBlockAnalysis(argState, node)) {
            return this.doRecursiveAnalysis(argState, pPrecision, node);
        }
        return this.getWrappedTransferSuccessor(argState, pPrecision, node);
    }

    protected abstract Collection<? extends AbstractState> doRecursiveAnalysis(AbstractState var1, Precision var2, CFANode var3) throws EX, InterruptedException;

    protected Collection<? extends AbstractState> getWrappedTransferSuccessor(ARGState pState, Precision pPrecision, CFANode pNode) throws EX, InterruptedException, CPATransferException {
        return this.transferRelation.getAbstractSuccessors(pState, pPrecision);
    }

    protected boolean startNewBlockAnalysis(ARGState pState, CFANode node) {
        boolean result;
        boolean bl = result = this.partitioning.isCallNode(node) && !pState.getParents().isEmpty() && !this.partitioning.getBlockForCallNode(node).equals(this.getBlockForState(pState));
        if (result && this.useDynamicAdjustment && this.data.isUncachedBlockEntry(node)) {
            return false;
        }
        return result;
    }

    protected boolean exitBlockAnalysis(ARGState argState, CFANode node) {
        return this.partitioning.isReturnNode(node) && this.partitioning.getBlocksForReturnNode(node).contains((Object)this.getBlockForState(argState));
    }

    protected Block getBlockForState(ARGState state) {
        HashSet<ARGState> finished = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(state);
        while (!waitlist.isEmpty()) {
            state = (ARGState)waitlist.pop();
            while (state.getParents().size() == 1) {
                state = state.getParents().iterator().next();
            }
            if (state.getParents().isEmpty()) break;
            if (!finished.add(state)) continue;
            waitlist.addAll(state.getParents());
        }
        CFANode location = AbstractStates.extractLocation(state);
        assert (this.partitioning.isCallNode(location)) : "root of reached-set must be located at block entry.";
        return this.partitioning.getBlockForCallNode(location);
    }

    static boolean isHeadOfMainFunction(CFANode currentNode) {
        return currentNode instanceof FunctionEntryNode && currentNode.getNumEnteringEdges() == 0;
    }

    static boolean isFunctionBlock(Block block) {
        return block.getCallNodes().size() == 1 && block.getCallNode() instanceof FunctionEntryNode;
    }

    protected List<AbstractState> expandResultStates(Collection<AbstractState> reducedResult, ReachedSet reached, Block innerSubtree, @Nullable Block outerSubtree, AbstractState state, Precision precision) throws InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Expanding states with initial state", state});
        this.logger.log(Level.FINEST, new Object[]{"Expanding states", reducedResult});
        ArrayList<AbstractState> expandedResult = new ArrayList<AbstractState>(reducedResult.size());
        for (AbstractState reducedState : reducedResult) {
            Precision reducedPrecision = reached.getPrecision(reducedState);
            AbstractState expandedState = this.wrappedReducer.getVariableExpandedState(state, innerSubtree, reducedState);
            if (expandedState == null) continue;
            Precision expandedPrecision = outerSubtree == null ? reducedPrecision : this.wrappedReducer.getVariableExpandedPrecision(precision, outerSubtree, reducedPrecision);
            ((ARGState)expandedState).addParent((ARGState)state);
            expandedResult.add(expandedState);
            this.data.registerExpandedState(expandedState, expandedPrecision, reducedState, innerSubtree);
            if (!this.useDynamicAdjustment || !this.wrappedReducer.canBeUsedInCache(expandedState)) continue;
            if (expandedState instanceof Targetable && ((Targetable)((Object)expandedState)).isTarget()) {
                if (!this.wrappedReducer.canBeUsedInCache(state)) continue;
                this.data.addUncachedBlockEntry(innerSubtree.getCallNode());
                continue;
            }
            this.data.addUncachedBlockEntry(innerSubtree.getCallNode());
        }
        this.logger.log(Level.FINEST, new Object[]{"Expanded results:", expandedResult});
        return expandedResult;
    }

    protected void registerInitalAndExitStates(AbstractState initialState, Collection<AbstractState> exitStates, ReachedSet reached) {
        assert (reached != null);
        for (AbstractState exitState : exitStates) {
            this.data.registerInitialState(initialState, exitState, reached);
        }
    }

    protected boolean isCacheHit(ReachedSet cachedReached, Collection<AbstractState> cachedReturnStates) {
        if (cachedReturnStates != null) {
            if (!cachedReached.hasWaitingState()) {
                return true;
            }
            if (cachedReturnStates.size() == 1 && cachedReached.getLastState() != null && AbstractStates.isTargetState(cachedReached.getLastState())) {
                assert (Iterables.getOnlyElement(cachedReturnStates) == cachedReached.getLastState()) : "cache hit only allowed for finished reached-sets or target-states";
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, Iterable<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        return this.transferRelation.strengthen(pState, pOtherStates, pCfaEdge, pPrecision);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) {
        throw new UnsupportedOperationException("BAMCPA needs to be used as the outermost CPA, thus it does not support returning successors for a single edge.");
    }
}

