/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGStatistics;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class BAMARGStatistics
extends ARGStatistics {
    private static final String ERROR_PREFIX = "some output or statistics might be missing, could not compute full reached set graph";
    private final AbstractBAMCPA bamCpa;

    public BAMARGStatistics(Configuration pConfig, LogManager pLogger, AbstractBAMCPA pBamCpa, ConfigurableProgramAnalysis pCpa, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pCpa, pSpecification, pCfa);
        this.bamCpa = pBamCpa;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (!this.isValidContext(pReached)) {
            return;
        }
        FluentIterable<ARGState> frontierStates = this.getFrontierStates(pReached);
        if (frontierStates.isEmpty()) {
            if (pResult.equals((Object)CPAcheckerResult.Result.FALSE)) {
                this.logger.log(Level.INFO, new Object[]{ERROR_PREFIX, "(no frontier states)"});
            } else if (pResult.equals((Object)CPAcheckerResult.Result.TRUE)) {
                super.printStatistics(pOut, pResult, pReached);
            }
            return;
        }
        UnmodifiableReachedSet bamReachedSetView = this.createReachedSetViewWithoutExceptions(pReached, frontierStates, pResult);
        if (bamReachedSetView != null) {
            super.printStatistics(pOut, pResult, bamReachedSetView);
        }
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (!this.isValidContext(pReached)) {
            return;
        }
        FluentIterable<ARGState> frontierStates = this.getFrontierStates(pReached);
        if (frontierStates.isEmpty()) {
            if (pResult.equals((Object)CPAcheckerResult.Result.FALSE)) {
                this.logger.log(Level.INFO, new Object[]{ERROR_PREFIX, "(no frontier states)"});
            } else if (pResult.equals((Object)CPAcheckerResult.Result.TRUE)) {
                super.writeOutputFiles(pResult, pReached);
            }
            return;
        }
        UnmodifiableReachedSet bamReachedSetView = this.createReachedSetViewWithoutExceptions(pReached, frontierStates, pResult);
        if (bamReachedSetView != null) {
            super.writeOutputFiles(pResult, bamReachedSetView);
        }
    }

    private @Nullable UnmodifiableReachedSet createReachedSetViewWithoutExceptions(UnmodifiableReachedSet pReached, FluentIterable<ARGState> frontierStates, CPAcheckerResult.Result pResult) {
        try {
            return this.createReachedSetViewWithFallback(pReached, frontierStates, pResult);
        }
        catch (BAMSubgraphComputer.MissingBlockException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, ERROR_PREFIX);
            return null;
        }
        catch (InterruptedException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "could not compute full reached set graph");
            return null;
        }
    }

    private @Nullable UnmodifiableReachedSet createReachedSetViewWithFallback(UnmodifiableReachedSet pReached, FluentIterable<ARGState> frontierStates, CPAcheckerResult.Result pResult) throws BAMSubgraphComputer.MissingBlockException, InterruptedException {
        try {
            return this.createReachedSetView(pReached, (Iterable<ARGState>)frontierStates);
        }
        catch (BAMSubgraphComputer.MissingBlockException e) {
            ImmutableList targetStates = frontierStates.filter(AbstractStates::isTargetState).toList();
            if (pResult.equals((Object)CPAcheckerResult.Result.FALSE) && !targetStates.isEmpty()) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "some output or statistics might be missing, could not compute full reached set graph, falling back to counterexample traces");
                return this.createReachedSetView(pReached, (Iterable<ARGState>)targetStates);
            }
            throw e;
        }
    }

    private @Nullable UnmodifiableReachedSet createReachedSetView(UnmodifiableReachedSet pReached, Iterable<ARGState> pFrontierStates) throws BAMSubgraphComputer.MissingBlockException, InterruptedException {
        ARGReachedSet pMainReachedSet = new ARGReachedSet((ReachedSet)pReached, this.cpa, 0);
        ImmutableList frontierStates = FluentIterable.from(pFrontierStates).filter(s -> pMainReachedSet.asReachedSet().contains((AbstractState)s)).toList();
        BAMSubgraphComputer cexSubgraphComputer = new BAMSubgraphComputer(this.bamCpa, false);
        Pair<BAMSubgraphComputer.BackwardARGState, Collection<BAMSubgraphComputer.BackwardARGState>> rootAndTargetsOfSubgraph = cexSubgraphComputer.computeCounterexampleSubgraph((Collection<ARGState>)frontierStates, pMainReachedSet);
        ARGPath path = ARGUtils.getRandomPath(rootAndTargetsOfSubgraph.getFirst());
        ThreadSafeTimerContainer.TimerWrapper dummyTimer = new ThreadSafeTimerContainer("dummy").getNewTimer();
        BAMReachedSet bamReachedSet = new BAMReachedSet(this.bamCpa, pMainReachedSet, path, dummyTimer);
        UnmodifiableReachedSet bamReachedSetView = bamReachedSet.asReachedSet();
        this.readdCounterexampleInfo(pReached, rootAndTargetsOfSubgraph.getSecond());
        return bamReachedSetView;
    }

    private FluentIterable<ARGState> getFrontierStates(UnmodifiableReachedSet pReached) {
        return ((ARGState)pReached.getFirstState()).getSubgraph().filter(s -> s.getChildren().isEmpty() && !s.isCovered());
    }

    private boolean isValidContext(UnmodifiableReachedSet pReached) {
        if (!(this.cpa instanceof ARGCPA)) {
            this.logger.log(Level.WARNING, new Object[]{"statistic export needs ARG-CPA"});
            return false;
        }
        if (pReached.size() <= 1) {
            this.logger.log(Level.WARNING, new Object[]{"could not compute full reached set graph, there is no exit state"});
            return false;
        }
        return true;
    }

    private void readdCounterexampleInfo(UnmodifiableReachedSet pReached, Collection<BAMSubgraphComputer.BackwardARGState> targets) {
        ARGState argState = (ARGState)pReached.getLastState();
        if (argState != null && argState.isTarget()) {
            Optional<CounterexampleInfo> cex = argState.getCounterexampleInformation();
            Optional<BAMSubgraphComputer.BackwardARGState> matchingState = targets.stream().filter(t -> Objects.equals(t.getARGState(), argState)).findFirst();
            if (cex.isPresent() && matchingState.isPresent()) {
                matchingState.orElseThrow().addCounterexampleInformation(cex.orElseThrow());
            }
        }
    }
}

