/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGBlockStartState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;

class BAMARGUtils {
    private BAMARGUtils() {
    }

    @Deprecated
    public static Multimap<Block, UnmodifiableReachedSet> gatherReachedSets(BAMCPA cpa, UnmodifiableReachedSet finalReachedSet) {
        HashMultimap result = HashMultimap.create();
        BAMARGUtils.gatherReachedSets(cpa, cpa.getBlockPartitioning().getMainBlock(), finalReachedSet, (Multimap<Block, UnmodifiableReachedSet>)result);
        return result;
    }

    private static void gatherReachedSets(BAMCPA cpa, Block block, UnmodifiableReachedSet reachedSet, Multimap<Block, UnmodifiableReachedSet> blockToReachedSet) {
        if (blockToReachedSet.containsEntry((Object)block, (Object)reachedSet)) {
            return;
        }
        blockToReachedSet.put((Object)block, (Object)reachedSet);
        ARGState firstElement = (ARGState)reachedSet.getFirstState();
        ArrayDeque<ARGState> worklist = new ArrayDeque<ARGState>();
        HashSet<ARGState> processed = new HashSet<ARGState>();
        worklist.add(firstElement);
        while (!worklist.isEmpty()) {
            ARGState currentElement = (ARGState)worklist.removeLast();
            assert (reachedSet.contains(currentElement));
            if (processed.contains(currentElement)) continue;
            processed.add(currentElement);
            for (ARGState child : currentElement.getChildren()) {
                List<CFAEdge> edges = currentElement.getEdgesToChild(child);
                if (edges.isEmpty()) {
                    Pair<Block, ReachedSet> pair = BAMARGUtils.getCachedReachedSet(cpa, currentElement, child);
                    BAMARGUtils.gatherReachedSets(cpa, pair.getFirst(), pair.getSecond(), blockToReachedSet);
                }
                if (worklist.contains(child) || !reachedSet.contains(child)) continue;
                worklist.add(child);
            }
        }
    }

    private static Pair<Block, ReachedSet> getCachedReachedSet(BAMCPA cpa, ARGState root, ARGState exitState) {
        CFANode rootNode = AbstractStates.extractLocation(root);
        Block rootSubtree = cpa.getBlockPartitioning().getBlockForCallNode(rootNode);
        ReachedSet reachSet = cpa.getData().getReachedSetForInitialState(root, exitState);
        assert (reachSet != null);
        return Pair.of(rootSubtree, reachSet);
    }

    public static ARGState copyARG(ARGState pRoot) {
        HashMap<ARGState, ARGState> stateToCopyElem = new HashMap<ARGState, ARGState>();
        HashSet<ARGState> visited = new HashSet<ARGState>();
        ArrayDeque<ARGState> toVisit = new ArrayDeque<ARGState>();
        visited.add(pRoot);
        toVisit.add(pRoot);
        while (!toVisit.isEmpty()) {
            ARGState copyStateInner;
            ARGState copyState;
            ARGState current = (ARGState)toVisit.pop();
            if (stateToCopyElem.get(current) == null) {
                copyState = BAMARGUtils.copyNode(current);
                stateToCopyElem.put(current, copyState);
            } else {
                copyState = (ARGState)stateToCopyElem.get(current);
            }
            for (ARGState c : current.getChildren()) {
                if (stateToCopyElem.get(c) == null) {
                    copyStateInner = BAMARGUtils.copyNode(c);
                    stateToCopyElem.put(c, copyStateInner);
                } else {
                    copyStateInner = (ARGState)stateToCopyElem.get(c);
                }
                copyStateInner.addParent(copyState);
                if (!visited.add(c)) continue;
                toVisit.add(c);
            }
            if (!current.isCovered()) continue;
            if (stateToCopyElem.get(current.getCoveringState()) == null) {
                copyStateInner = BAMARGUtils.copyNode(current.getCoveringState());
                stateToCopyElem.put(current.getCoveringState(), copyStateInner);
            } else {
                copyStateInner = (ARGState)stateToCopyElem.get(current.getCoveringState());
            }
            if (visited.add(current.getCoveringState())) {
                toVisit.add(current.getCoveringState());
            }
            copyState.setCovered(copyStateInner);
        }
        return (ARGState)stateToCopyElem.get(pRoot);
    }

    private static ARGState copyNode(ARGState toCopy) {
        ARGState copyState;
        if (toCopy instanceof BAMARGBlockStartState) {
            copyState = new BAMARGBlockStartState(toCopy.getWrappedState(), null);
            ((BAMARGBlockStartState)copyState).setAnalyzedBlock(((BAMARGBlockStartState)toCopy).getAnalyzedBlock());
        } else {
            copyState = new ARGState(toCopy.getWrappedState(), null);
        }
        return copyState;
    }
}

