/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAStatistics;
import org.sosy_lab.cpachecker.cpa.bam.BAMReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMReachedSetValidator;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public final class BAMBasedRefiner
extends AbstractARGBasedRefiner {
    private final AbstractBAMCPA bamCpa;
    private final BAMCPAStatistics stats;

    private BAMBasedRefiner(ARGBasedRefiner pRefiner, ARGCPA pArgCpa, AbstractBAMCPA pBamCpa, LogManager pLogger) {
        super(pRefiner, pArgCpa, pLogger);
        this.bamCpa = pBamCpa;
        this.stats = this.bamCpa.getStatistics();
    }

    public static Refiner forARGBasedRefiner(ARGBasedRefiner pRefiner, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        Preconditions.checkArgument((!(pRefiner instanceof Refiner) ? 1 : 0) != 0, (Object)"ARGBasedRefiners may not implement Refiner, choose between these two!");
        if (!(pCpa instanceof AbstractBAMCPA)) {
            throw new InvalidConfigurationException("BAM CPA needed for BAM-based refinement");
        }
        AbstractBAMCPA bamCpa = (AbstractBAMCPA)pCpa;
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, Refiner.class);
        return new BAMBasedRefiner(pRefiner, argCpa, bamCpa, bamCpa.getLogger());
    }

    @Override
    protected CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath pPath) throws CPAException, InterruptedException {
        Preconditions.checkArgument((!(pReached instanceof BAMReachedSet) ? 1 : 0) != 0, (Object)"Wrapping of BAM-based refiners inside BAM-based refiners is not allowed.");
        assert (pPath == null || pPath.size() > 0);
        if (pPath == null) {
            this.stats.refinementWithMissingBlocks.inc();
            return CounterexampleInfo.spurious();
        }
        this.stats.startedRefinements.inc();
        pReached = new BAMReachedSet(this.bamCpa, pReached, pPath, this.stats.removeCachedSubtreeTimer.getNewTimer());
        CounterexampleInfo cexInfo = super.performRefinementForPath(pReached, pPath);
        if (cexInfo.isSpurious()) {
            this.stats.spuriousCex.inc();
        } else if (cexInfo.isPreciseCounterExample()) {
            this.stats.preciseCex.inc();
        }
        return cexInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ARGPath computePath(ARGState pLastElement, ARGReachedSet pMainReachedSet) throws InterruptedException, CPATransferException {
        assert (pMainReachedSet.asReachedSet().contains(pLastElement)) : "targetState must be in mainReachedSet.";
        assert (BAMReachedSetValidator.validateData(this.bamCpa.getData(), this.bamCpa.getBlockPartitioning(), pMainReachedSet));
        ThreadSafeTimerContainer.TimerWrapper computePathTimer = this.stats.computePathTimer.getNewTimer();
        ThreadSafeTimerContainer.TimerWrapper computeSubtreeTimer = this.stats.computeSubtreeTimer.getNewTimer();
        ThreadSafeTimerContainer.TimerWrapper computeCounterexampleTimer = this.stats.computeCounterexampleTimer.getNewTimer();
        computePathTimer.start();
        try {
            Pair rootAndTargetOfSubgraph;
            computeSubtreeTimer.start();
            try {
                try {
                    BAMSubgraphComputer cexSubgraphComputer = new BAMSubgraphComputer(this.bamCpa, true);
                    rootAndTargetOfSubgraph = (Pair)Preconditions.checkNotNull(cexSubgraphComputer.computeCounterexampleSubgraph(pLastElement, pMainReachedSet));
                }
                catch (BAMSubgraphComputer.MissingBlockException e) {
                    ARGPath aRGPath = null;
                    computeSubtreeTimer.stop();
                    computePathTimer.stop();
                    return aRGPath;
                }
            }
            finally {
                computeSubtreeTimer.stop();
            }
            computeCounterexampleTimer.start();
            try {
                ARGPath aRGPath = ARGUtils.getOnePathTo((ARGState)rootAndTargetOfSubgraph.getSecond());
                computeCounterexampleTimer.stop();
                return aRGPath;
            }
            catch (Throwable throwable) {
                computeCounterexampleTimer.stop();
                throw throwable;
            }
        }
        finally {
            computePathTimer.stop();
        }
    }
}

