/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CEGARAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMMergeOperator;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.BAMPCCManager;
import org.sosy_lab.cpachecker.cpa.bam.BAMPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.bam.BAMStopOperatorForRecursion;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelationWithFixPointForRecursion;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCacheAggressiveImpl;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCacheImpl;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManagerImpl;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.bam")
public class BAMCPA
extends AbstractBAMCPA
implements StatisticsProvider,
ProofChecker {
    private final BAMTransferRelation transfer;
    private final ProofChecker wrappedProofChecker;
    private final BAMDataManager data;
    private final BAMPCCManager bamPccManager;
    @Option(name="handleRecursiveProcedures", secure=true, description="BAM allows to analyse recursive procedures. This strongly depends on the underlying CPA. The current support includes only ValueAnalysis and PredicateAnalysis (with tree interpolation enabled).")
    private boolean handleRecursiveProcedures = false;
    @Option(secure=true, description="If enabled, cache queries also consider blocks with non-matching precision for reuse.")
    private boolean aggressiveCaching = true;
    @Option(secure=true, description="Should the nested CPA-algorithm be wrapped with CEGAR within BAM?")
    private boolean useCEGAR = false;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(BAMCPA.class);
    }

    private BAMCPA(ConfigurableProgramAnalysis pCpa, Configuration config, LogManager pLogger, ReachedSetFactory pReachedSetFactory, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException, CPAException {
        super(pCpa, config, pLogger, pShutdownNotifier, pSpecification, pCfa);
        config.inject((Object)this);
        this.wrappedProofChecker = pCpa instanceof ProofChecker ? (ProofChecker)((Object)pCpa) : null;
        BAMCacheImpl cache = this.aggressiveCaching ? new BAMCacheAggressiveImpl(config, this.getReducer(), this.logger) : new BAMCacheImpl(config, this.getReducer(), this.logger);
        this.data = new BAMDataManagerImpl(this, cache, pReachedSetFactory, pLogger);
        this.bamPccManager = new BAMPCCManager(this.wrappedProofChecker, config, this.blockPartitioning, this.getReducer(), this, this.data);
        Algorithm.AlgorithmFactory factory = new CPAAlgorithm.CPAAlgorithmFactory(this, this.logger, config, pShutdownNotifier);
        if (this.useCEGAR) {
            factory = new CEGARAlgorithm.CEGARAlgorithmFactory(factory, (ConfigurableProgramAnalysis)this, this.logger, config, pShutdownNotifier);
        }
        this.transfer = this.handleRecursiveProcedures ? new BAMTransferRelationWithFixPointForRecursion(config, this, pShutdownNotifier, factory, this.bamPccManager, this.searchTargetStatesOnExit()) : new BAMTransferRelation(this, pShutdownNotifier, factory, this.bamPccManager, this.searchTargetStatesOnExit());
    }

    @Override
    public BAMMergeOperator getMergeOperator() {
        return super.getMergeOperator().withBAMPCCManager(this.bamPccManager);
    }

    @Override
    public StopOperator getStopOperator() {
        return this.handleRecursiveProcedures ? new BAMStopOperatorForRecursion(this.getWrappedCpa().getStopOperator()) : this.getWrappedCpa().getStopOperator();
    }

    @Override
    public BAMPrecisionAdjustment getPrecisionAdjustment() {
        return new BAMPrecisionAdjustment(this.getWrappedCpa().getPrecisionAdjustment(), this.data, this.bamPccManager, this.logger, this.blockPartitioning);
    }

    @Override
    public BAMTransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public BAMDataManager getData() {
        Preconditions.checkNotNull((Object)this.data);
        return this.data;
    }

    public BAMPCCManager getBamPccManager() {
        return this.bamPccManager;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.bamPccManager.areAbstractSuccessors(pState, pCfaEdge, pSuccessors);
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        Preconditions.checkNotNull((Object)this.wrappedProofChecker, (Object)"Wrapped CPA has to implement ProofChecker interface");
        return this.wrappedProofChecker.isCoveredBy(pState, pOtherState);
    }

    public BAMMultipleCEXSubgraphComputer createBAMMultipleSubgraphComputer(Function<ARGState, Integer> pIdExtractor) {
        return new BAMMultipleCEXSubgraphComputer(this, pIdExtractor);
    }
}

