/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatHist;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

@Options(prefix="cpa.bam")
class BAMCPAStatistics
implements Statistics {
    final ThreadSafeTimerContainer computePathTimer = new ThreadSafeTimerContainer("Compute path for refinement");
    final ThreadSafeTimerContainer computeSubtreeTimer = new ThreadSafeTimerContainer("Constructing flat ARG");
    final ThreadSafeTimerContainer computeCounterexampleTimer = new ThreadSafeTimerContainer("Searching path to error location");
    final ThreadSafeTimerContainer removeCachedSubtreeTimer = new ThreadSafeTimerContainer("Removing cached subtrees");
    final StatCounter refinementWithMissingBlocks = new StatCounter("Number of refinements with a missing block");
    final StatCounter startedRefinements = new StatCounter("Number of started refinements");
    final StatCounter spuriousCex = new StatCounter("Number of spurious counterexamples");
    final StatCounter preciseCex = new StatCounter("Number of precise counterexamples");
    final StatCounter algorithmInstances = new StatCounter("Number of created nested algortihms");
    final StatHist depthsOfTargetStates = new StatHist("Nesting level of target states with caching"){

        @Override
        public String toString() {
            return String.format("%.2f (#=%d, min=%d, max=%d, hist=%s)", this.getAvg(), this.getUpdateCount(), this.getMin(), this.getMax(), this.hist);
        }
    };
    final StatHist depthsOfFoundTargetStates = new StatHist("Nesting level of target states without caching"){

        @Override
        public String toString() {
            return String.format("%.2f (#=%d, min=%d, max=%d, hist=%s)", this.getAvg(), this.getUpdateCount(), this.getMin(), this.getMax(), this.hist);
        }
    };
    @Option(secure=true, description="file for exporting detailed statistics about blocks")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path blockStatisticsFile = Path.of("block_statistics.txt", new String[0]);
    private final LogManager logger;
    private final AbstractBAMCPA cpa;
    private int maxRecursiveDepth = 0;
    private final Map<Block, Timer> timeForBlock = new LinkedHashMap<Block, Timer>();

    public BAMCPAStatistics(Configuration pConfig, LogManager pLogger, AbstractBAMCPA pCpa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.cpa = pCpa;
    }

    @Override
    public String getName() {
        return "BAMCPA";
    }

    void updateBlockNestingLevel(int newLevel) {
        this.maxRecursiveDepth = Math.max(newLevel, this.maxRecursiveDepth);
    }

    void switchBlock(Block oldBlock, Block newBlock) {
        this.timeForBlock.computeIfAbsent(oldBlock, b -> new Timer()).stopIfRunning();
        this.timeForBlock.computeIfAbsent(newBlock, b -> new Timer()).start();
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        this.put(out, "Number of blocks", this.cpa.getBlockPartitioning().getBlocks().size());
        this.put(out, "Max reached nesting level", this.maxRecursiveDepth);
        this.put(out, "Time for building block partitioning", this.cpa.blockPartitioningTimer);
        this.put(out, 0, this.cpa.reducerStatistics.reduceTime);
        this.put(out, 0, this.cpa.reducerStatistics.expandTime);
        this.put(out, 0, this.cpa.reducerStatistics.reducePrecisionTime);
        this.put(out, 0, this.cpa.reducerStatistics.expandPrecisionTime);
        this.put(out, 0, this.algorithmInstances);
        if (this.depthsOfTargetStates.getUpdateCount() > 0) {
            this.put(out, 0, this.depthsOfTargetStates);
            this.put(out, 0, this.depthsOfFoundTargetStates);
        }
        out.println("\nBAM-based Refinement:");
        this.put(out, 1, this.computePathTimer);
        this.put(out, 1, this.computeSubtreeTimer);
        this.put(out, 1, this.computeCounterexampleTimer);
        this.put(out, 1, this.removeCachedSubtreeTimer);
        this.put(out, 1, this.refinementWithMissingBlocks);
        this.put(out, 1, this.startedRefinements);
        this.put(out, 1, this.spuriousCex);
        this.put(out, 1, this.preciseCex);
        this.writeBlockStatistics(out);
    }

    private void writeBlockStatistics(PrintStream out) {
        if (this.timeForBlock.isEmpty()) {
            return;
        }
        out.println("\nBlock statistics:");
        StatHist allTimers = new StatHist("time for block");
        for (Timer timer : this.timeForBlock.values()) {
            timer.stopIfRunning();
            allTimers.insertValue(timer.getSumTime().asMillis());
        }
        this.put(out, 1, "Analyzed blocks", this.timeForBlock.size());
        this.put(out, 1, "Avg. time for block analysis", this.ofMillis((long)allTimers.getAvg()));
        this.put(out, 1, "Mean time for block analysis", this.ofMillis(allTimers.getMean()));
        this.put(out, 1, "Min time for block analysis", this.ofMillis(allTimers.getMin()));
        this.put(out, 1, "Max time for block analysis", this.ofMillis(allTimers.getMax()));
        this.put(out, 1, "StdDev time for block analysis", this.ofMillis((long)allTimers.getStdDeviation()));
        this.put(out, 1, "Total time for block analysis", this.ofMillis((long)allTimers.getSum()));
        if (this.timeForBlock.containsKey(this.cpa.getBlockPartitioning().getMainBlock())) {
            this.put(out, 1, "Time for main block", String.format("%s (%s)", this.timeForBlock.get(this.cpa.getBlockPartitioning().getMainBlock()), this.cpa.getBlockPartitioning().getMainBlock().getCallNodes()));
        }
    }

    private String ofMillis(long millis) {
        return TimeSpan.ofMillis((long)millis).formatAs(TimeUnit.SECONDS);
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (this.blockStatisticsFile != null) {
            try (Writer w = IO.openOutputFile((Path)this.blockStatisticsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                w.write("start; end; #locations; #variables; sumtime; maxtime; avgtime; #intervals; variables;");
                w.write("\n");
                for (Map.Entry<Block, Timer> entry : this.timeForBlock.entrySet()) {
                    Block block = entry.getKey();
                    Timer timer = entry.getValue();
                    w.write(String.format("%s; %s; %s; %s; %s; %s; %s; %s; %s;", block.getCallNodes(), block.getReturnNodes(), block.getNodes().size(), block.getVariables().size(), timer.getSumTime(), timer.getMaxTime(), timer.getAvgTime(), timer.getNumberOfIntervals(), block.getVariables()));
                    w.write("\n");
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not export block statistics");
            }
        }
    }
}

