/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.bam.BAMPrecisionAdjustmentWithBreakOnMissingBlock;
import org.sosy_lab.cpachecker.cpa.bam.BAMStopOperatorWithBreakOnMissingBlock;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelationWithBreakOnMissingBlock;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCacheSynchronized;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManagerSynchronized;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.bam")
public class BAMCPAWithBreakOnMissingBlock
extends AbstractBAMCPA {
    @Option(secure=true, description="abort current analysis when finding a missing block abstraction")
    private boolean breakForMissingBlock = true;
    private final BAMCache cache;
    private final BAMDataManager data;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(BAMCPAWithBreakOnMissingBlock.class);
    }

    private BAMCPAWithBreakOnMissingBlock(ConfigurableProgramAnalysis pCpa, Configuration pConfig, LogManager pLogger, ReachedSetFactory reachedsetFactory, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException, CPAException {
        super(pCpa, pConfig, pLogger, pShutdownNotifier, pSpecification, pCfa);
        pConfig.inject((Object)this);
        this.cache = new BAMCacheSynchronized(pConfig, this.getReducer(), pLogger);
        this.data = new BAMDataManagerSynchronized(this, this.cache, reachedsetFactory, pLogger);
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new BAMTransferRelationWithBreakOnMissingBlock(this, this.shutdownNotifier);
    }

    @Override
    public BAMPrecisionAdjustment getPrecisionAdjustment() {
        return new BAMPrecisionAdjustmentWithBreakOnMissingBlock(this.getWrappedCpa().getPrecisionAdjustment(), this.data, this.logger, this.blockPartitioning, this.breakForMissingBlock);
    }

    @Override
    public StopOperator getStopOperator() {
        return new BAMStopOperatorWithBreakOnMissingBlock(this.getWrappedCpa().getStopOperator());
    }

    public BAMCache getCache() {
        return this.cache;
    }

    @Override
    public BAMDataManager getData() {
        return this.data;
    }

    public boolean doesBreakForMissingBlock() {
        return this.breakForMissingBlock;
    }
}

