/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.counterexamplecheck.CounterexampleChecker;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;

public class BAMCounterexampleCheckAlgorithm
extends CounterexampleCheckAlgorithm {
    private final BAMCPA cpa;

    public BAMCounterexampleCheckAlgorithm(Algorithm algorithm, ConfigurableProgramAnalysis pCpa, Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA cfa) throws InvalidConfigurationException {
        super(algorithm, pCpa, config, pSpecification, logger, pShutdownNotifier, cfa);
        if (!(pCpa instanceof BAMCPA)) {
            throw new InvalidConfigurationException("BAM CPA needed for BAM counterexample check");
        }
        this.cpa = (BAMCPA)pCpa;
    }

    @Override
    protected boolean checkErrorPaths(CounterexampleChecker checker, ARGState errorState, ReachedSet reached) throws CPAException, InterruptedException {
        ARGReachedSet mainReachedSet = new ARGReachedSet(reached, this.cpa.getWrappedCpa(), 0);
        assert (mainReachedSet.asReachedSet().contains(errorState));
        assert (errorState == reached.getLastState());
        BAMSubgraphComputer graphComputer = new BAMSubgraphComputer(this.cpa, false);
        Pair<BAMSubgraphComputer.BackwardARGState, BAMSubgraphComputer.BackwardARGState> rootAndTargetOfSubgraph = graphComputer.computeCounterexampleSubgraph(errorState, mainReachedSet);
        ARGState rootState = rootAndTargetOfSubgraph.getFirst();
        ARGState target = rootAndTargetOfSubgraph.getSecond();
        ImmutableSet statesOnErrorPath = rootState.getSubgraph().toSet();
        assert (Objects.equals(((BAMSubgraphComputer.BackwardARGState)target).getARGState(), errorState));
        return checker.checkCounterexample(rootState, target, (Set<ARGState>)statesOnErrorPath);
    }
}

