/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMPCCManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class BAMMergeOperator
implements MergeOperator {
    private final MergeOperator wrappedMergeOp;
    private @Nullable BAMPCCManager bamPccManager;

    BAMMergeOperator(MergeOperator pWrappedMerge) {
        this.wrappedMergeOp = pWrappedMerge;
    }

    @CanIgnoreReturnValue
    BAMMergeOperator withBAMPCCManager(BAMPCCManager pBAMPCCManager) {
        Preconditions.checkState((this.bamPccManager == null ? 1 : 0) != 0);
        this.bamPccManager = (BAMPCCManager)Preconditions.checkNotNull((Object)pBAMPCCManager);
        return this;
    }

    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) throws CPAException, InterruptedException {
        if (((ARGState)pState2).getParents().isEmpty()) {
            return pState2;
        }
        AbstractState out = this.wrappedMergeOp.merge(pState1, pState2, pPrecision);
        if (this.bamPccManager != null && this.bamPccManager.isPCCEnabled()) {
            return this.bamPccManager.attachAdditionalInfoToCallNode(out);
        }
        return out;
    }
}

