/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphIterator;

public class BAMMultipleCEXSubgraphComputer
extends BAMSubgraphComputer {
    private Set<ArrayDeque<Integer>> remainingStates = new HashSet<ArrayDeque<Integer>>();
    private final Function<ARGState, Integer> getStateId;
    public static final BAMSubgraphComputer.BackwardARGState DUMMY_STATE_FOR_REPEATED_STATE = new BAMSubgraphComputer.BackwardARGState(new ARGState(null, null));

    BAMMultipleCEXSubgraphComputer(BAMCPA bamCPA, @NonNull Function<ARGState, Integer> idExtractor) {
        super(bamCPA, true);
        this.getStateId = idExtractor;
    }

    private ARGState findPath(BAMSubgraphComputer.BackwardARGState newTreeTarget, Set<List<Integer>> pProcessedStates) throws InterruptedException, BAMSubgraphComputer.MissingBlockException {
        HashMap<ARGState, BAMSubgraphComputer.BackwardARGState> elementsMap = new HashMap<ARGState, BAMSubgraphComputer.BackwardARGState>();
        BAMSubgraphComputer.BackwardARGState root = null;
        boolean inCallstackFunction = false;
        this.remainingStates.clear();
        for (List<Integer> newList : pProcessedStates) {
            this.remainingStates.add(new ArrayDeque<Integer>(newList));
        }
        ARGState target = newTreeTarget.getARGState();
        elementsMap.put(target, newTreeTarget);
        ARGState currentState = target;
        TreeSet<ARGState> openElements = new TreeSet<ARGState>(target.getParents());
        while (!openElements.isEmpty()) {
            currentState = (ARGState)openElements.pollLast();
            if (elementsMap.containsKey(currentState)) continue;
            BAMSubgraphComputer.BackwardARGState newCurrentElement = new BAMSubgraphComputer.BackwardARGState(currentState);
            elementsMap.put(currentState, newCurrentElement);
            TreeSet<BAMSubgraphComputer.BackwardARGState> childrenInSubgraph = new TreeSet<BAMSubgraphComputer.BackwardARGState>();
            for (ARGState aRGState : currentState.getChildren()) {
                if (!elementsMap.containsKey(aRGState)) continue;
                childrenInSubgraph.add((BAMSubgraphComputer.BackwardARGState)elementsMap.get(aRGState));
            }
            if (childrenInSubgraph.isEmpty()) continue;
            inCallstackFunction = false;
            if (currentState.getParents().isEmpty()) {
                TreeSet<AbstractState> expandedStates = new TreeSet<AbstractState>((Collection<AbstractState>)this.data.getNonReducedInitialStates(currentState));
                if (expandedStates.isEmpty()) {
                    for (BAMSubgraphComputer.BackwardARGState newChild : childrenInSubgraph) {
                        newChild.addParent(newCurrentElement);
                        if (!this.checkRepeatitionOfState(newChild)) continue;
                        return DUMMY_STATE_FOR_REPEATED_STATE;
                    }
                    root = newCurrentElement;
                    break;
                }
                currentState = (ARGState)expandedStates.iterator().next();
                newCurrentElement = new BAMSubgraphComputer.BackwardARGState(currentState);
                elementsMap.put(currentState, newCurrentElement);
                inCallstackFunction = true;
            }
            openElements.addAll(currentState.getParents());
            if (this.data.hasInitialState(currentState) && !inCallstackFunction) {
                this.computeCounterexampleSubgraphForBlock(newCurrentElement, childrenInSubgraph);
                assert (childrenInSubgraph.size() == 1);
                BAMSubgraphComputer.BackwardARGState tmpState = (BAMSubgraphComputer.BackwardARGState)childrenInSubgraph.iterator().next();
                ArrayDeque<ARGState> arrayDeque = new ArrayDeque<ARGState>();
                arrayDeque.add(tmpState);
                while (!arrayDeque.isEmpty() && !(tmpState = (BAMSubgraphComputer.BackwardARGState)arrayDeque.pop()).equals(newCurrentElement)) {
                    if (this.checkRepeatitionOfState(tmpState.getARGState())) {
                        return DUMMY_STATE_FOR_REPEATED_STATE;
                    }
                    arrayDeque.addAll(tmpState.getParents());
                }
            } else {
                for (BAMSubgraphComputer.BackwardARGState backwardARGState : childrenInSubgraph) {
                    backwardARGState.addParent(newCurrentElement);
                    if (!this.checkRepeatitionOfState(backwardARGState)) continue;
                    return DUMMY_STATE_FOR_REPEATED_STATE;
                }
                if (currentState.getParents().isEmpty()) {
                    root = newCurrentElement;
                    break;
                }
            }
            if (!currentState.isDestroyed()) continue;
            return null;
        }
        assert (root != null);
        return root;
    }

    private boolean checkRepeatitionOfState(ARGState currentElement) {
        if (currentElement != null && this.getStateId != null) {
            Integer currentId = (Integer)this.getStateId.apply((Object)currentElement);
            for (ArrayDeque<Integer> rest : this.remainingStates) {
                if (!rest.getLast().equals(currentId)) continue;
                rest.removeLast();
                if (!rest.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    ARGPath restorePathFrom(BAMSubgraphComputer.BackwardARGState pLastElement, Set<List<Integer>> pRefinedStates) {
        assert (pLastElement != null && !pLastElement.isDestroyed());
        try {
            ARGState rootOfSubgraph = this.findPath(pLastElement, pRefinedStates);
            assert (rootOfSubgraph != null);
            if (rootOfSubgraph.equals(DUMMY_STATE_FOR_REPEATED_STATE)) {
                return null;
            }
            ARGPath result = ARGUtils.getRandomPath(rootOfSubgraph);
            if (result != null && this.checkThePathHasRepeatedStates(result, pRefinedStates)) {
                return null;
            }
            return result;
        }
        catch (InterruptedException | BAMSubgraphComputer.MissingBlockException e) {
            return null;
        }
    }

    public ARGPath computePath(ARGState pLastElement) {
        return this.computePath(pLastElement, (Set<List<Integer>>)ImmutableSet.of());
    }

    public ARGPath computePath(ARGState pLastElement, Set<List<Integer>> pRefinedStates) {
        return this.restorePathFrom(new BAMSubgraphComputer.BackwardARGState(pLastElement), pRefinedStates);
    }

    boolean checkThePathHasRepeatedStates(ARGPath path, Set<List<Integer>> pRefinedStates) {
        ImmutableList ids = Collections3.transformedImmutableListCopy(path.asStatesList(), this.getStateId);
        return FluentIterable.from(pRefinedStates).anyMatch(((List)ids)::containsAll);
    }

    public BAMSubgraphIterator iterator(ARGState target) {
        return new BAMSubgraphIterator(target, this, this.data);
    }
}

