/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGBlockStartState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="pcc.proofgen")
public final class BAMPCCManager {
    @Option(secure=true, description="Generate and dump a proof")
    private boolean doPCC = false;
    private final ProofChecker wrappedProofChecker;
    private Map<Pair<ARGState, Block>, Collection<ARGState>> correctARGsForBlocks = null;
    private final BlockPartitioning partitioning;
    private final Reducer wrappedReducer;
    private final BAMCPA bamCPA;
    private final BAMDataManager data;
    private Block currentBlock = null;

    public BAMPCCManager(ProofChecker pWrappedProofChecker, Configuration pConfiguration, BlockPartitioning pPartitioning, Reducer pWrappedReducer, BAMCPA pBamCPA, BAMDataManager pData) throws InvalidConfigurationException {
        this.wrappedProofChecker = pWrappedProofChecker;
        this.partitioning = pPartitioning;
        this.wrappedReducer = pWrappedReducer;
        this.bamCPA = pBamCPA;
        this.data = pData;
        pConfiguration.inject((Object)this);
    }

    public boolean isPCCEnabled() {
        return this.doPCC;
    }

    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        if (pCfaEdge != null) {
            return this.wrappedProofChecker.areAbstractSuccessors(pState, pCfaEdge, pSuccessors);
        }
        return this.areAbstractSuccessors0(pState, pSuccessors, this.partitioning.getMainBlock());
    }

    private boolean areAbstractSuccessors0(AbstractState pState, Collection<? extends AbstractState> pSuccessors, Block pBlock) throws CPATransferException, InterruptedException {
        block15: {
            CFANode node = AbstractStates.extractLocation(pState);
            if (this.partitioning.isCallNode(node) && !this.partitioning.getBlockForCallNode(node).equals(pBlock)) {
                Block analyzedBlock = this.partitioning.getBlockForCallNode(node);
                try {
                    if (!(pState instanceof BAMARGBlockStartState) || ((BAMARGBlockStartState)pState).getAnalyzedBlock() == null || !this.bamCPA.isCoveredBy(this.wrappedReducer.getVariableReducedStateForProofChecking(pState, analyzedBlock, node), ((BAMARGBlockStartState)pState).getAnalyzedBlock())) {
                        return false;
                    }
                }
                catch (CPAException e) {
                    throw new CPATransferException("Missing information about block whose analysis is expected to be started at " + pState);
                }
                try {
                    Collection<ARGState> endOfBlock;
                    Pair<ARGState, Block> pair = Pair.of(((BAMARGBlockStartState)pState).getAnalyzedBlock(), analyzedBlock);
                    if (this.correctARGsForBlocks != null && this.correctARGsForBlocks.containsKey(pair)) {
                        endOfBlock = this.correctARGsForBlocks.get(pair);
                    } else {
                        Pair<Boolean, Collection<ARGState>> result = this.checkARGBlock(((BAMARGBlockStartState)pState).getAnalyzedBlock(), analyzedBlock);
                        if (!result.getFirst().booleanValue()) {
                            return false;
                        }
                        endOfBlock = result.getSecond();
                        this.setCorrectARG(pair, endOfBlock);
                    }
                    HashSet<? extends AbstractState> notFoundSuccessors = new HashSet<AbstractState>(pSuccessors);
                    HashMultimap blockSuccessors = HashMultimap.create();
                    for (AbstractState abstractState : pSuccessors) {
                        ARGState successorElem = (ARGState)abstractState;
                        blockSuccessors.put((Object)AbstractStates.extractLocation(abstractState), (Object)successorElem);
                    }
                    for (ARGState aRGState : endOfBlock) {
                        boolean successorExists = false;
                        AbstractState expandedState = this.wrappedReducer.getVariableExpandedStateForProofChecking(pState, analyzedBlock, aRGState);
                        for (AbstractState next : blockSuccessors.get((Object)AbstractStates.extractLocation(aRGState))) {
                            if (!this.bamCPA.isCoveredBy(expandedState, next)) continue;
                            successorExists = true;
                            notFoundSuccessors.remove(next);
                        }
                        if (successorExists) continue;
                        return false;
                    }
                    if (!notFoundSuccessors.isEmpty()) {
                        return false;
                    }
                    break block15;
                }
                catch (CPAException e) {
                    throw new CPATransferException("Checking ARG with root " + ((BAMARGBlockStartState)pState).getAnalyzedBlock() + " for block " + pBlock + "failed.");
                }
            }
            HashSet<CFAEdge> usedEdges = new HashSet<CFAEdge>();
            for (AbstractState abstractState : pSuccessors) {
                ARGState successorElem = (ARGState)abstractState;
                usedEdges.add(((ARGState)pState).getEdgeToChild(successorElem));
            }
            for (CFAEdge cFAEdge : CFAUtils.leavingEdges(node)) {
                ImmutableList<Block> blocks = this.partitioning.getBlocksForReturnNode(node);
                Preconditions.checkState((blocks.size() <= 1 ? 1 : 0) != 0, (Object)"PCC does not expect more blocks for a single return node");
                Block currentNodeBlock = (Block)Iterables.getFirst(blocks, null);
                if (!(currentNodeBlock != null && !pBlock.equals(currentNodeBlock) && currentNodeBlock.getNodes().contains(cFAEdge.getSuccessor()) ? usedEdges.contains(cFAEdge) : (!pBlock.isCallNode(node) && pBlock.isReturnNode(node) && !pBlock.getNodes().contains(cFAEdge.getSuccessor()) ? usedEdges.contains(cFAEdge) : !this.wrappedProofChecker.areAbstractSuccessors(pState, cFAEdge, pSuccessors)))) continue;
                return false;
            }
        }
        return true;
    }

    private Pair<Boolean, Collection<ARGState>> checkARGBlock(ARGState rootNode, Block pBlock) throws CPAException, InterruptedException {
        ImmutableList returnNodes = new ArrayList();
        HashSet<ARGState> waitingForUnexploredParents = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> visited = new HashSet<ARGState>();
        HashSet<ARGState> coveredNodes = new HashSet<ARGState>();
        waitlist.add(rootNode);
        visited.add(rootNode);
        while (!waitlist.isEmpty()) {
            boolean unexploredParent;
            ARGState current = (ARGState)waitlist.pop();
            if (current.isTarget()) {
                returnNodes.add(current);
            }
            if (current.isCovered()) {
                coveredNodes.clear();
                coveredNodes.add(current);
                do {
                    if (!this.bamCPA.isCoveredBy(current, current.getCoveringState())) {
                        returnNodes = ImmutableList.of();
                        return Pair.of(false, returnNodes);
                    }
                    coveredNodes.add(current);
                    if (!coveredNodes.contains(current.getCoveringState())) continue;
                    returnNodes = ImmutableList.of();
                    return Pair.of(false, returnNodes);
                } while ((current = current.getCoveringState()).isCovered());
                if (visited.contains(current)) continue;
                unexploredParent = false;
                for (ARGState p : current.getParents()) {
                    if (visited.contains(p) && !waitlist.contains(p)) continue;
                    waitingForUnexploredParents.add(current);
                    unexploredParent = true;
                    break;
                }
                if (unexploredParent) continue;
                visited.add(current);
                waitlist.add(current);
                continue;
            }
            CFANode node = AbstractStates.extractLocation(current);
            if (pBlock.isReturnNode(node)) {
                returnNodes.add(current);
            }
            if (!this.areAbstractSuccessors0(current, current.getChildren(), pBlock)) {
                returnNodes = ImmutableList.of();
                return Pair.of(false, returnNodes);
            }
            for (ARGState child : current.getChildren()) {
                unexploredParent = false;
                for (ARGState p : child.getParents()) {
                    if (visited.contains(p) && !waitlist.contains(p)) continue;
                    waitingForUnexploredParents.add(child);
                    unexploredParent = true;
                    break;
                }
                if (unexploredParent) continue;
                if (visited.contains(child)) {
                    returnNodes = ImmutableList.of();
                    return Pair.of(false, returnNodes);
                }
                waitingForUnexploredParents.remove(child);
                visited.add(child);
                waitlist.add(child);
            }
        }
        if (!waitingForUnexploredParents.isEmpty()) {
            returnNodes = ImmutableList.of();
            return Pair.of(false, returnNodes);
        }
        return Pair.of(true, returnNodes);
    }

    public void setCorrectARG(Pair<ARGState, Block> pKey, Collection<ARGState> pEndOfBlock) {
        if (this.correctARGsForBlocks == null) {
            this.correctARGsForBlocks = new HashMap<Pair<ARGState, Block>, Collection<ARGState>>();
        }
        this.correctARGsForBlocks.put(pKey, pEndOfBlock);
    }

    Collection<? extends AbstractState> attachAdditionalInfoToCallNodes(Collection<? extends AbstractState> pSuccessors) {
        ArrayList<AbstractState> successorsWithExtendedInfo = new ArrayList<AbstractState>(pSuccessors.size());
        for (AbstractState abstractState : pSuccessors) {
            if (!(abstractState instanceof ARGState)) {
                return pSuccessors;
            }
            if (!(abstractState instanceof BAMARGBlockStartState)) {
                successorsWithExtendedInfo.add(this.createAdditionalInfo((ARGState)abstractState));
                continue;
            }
            successorsWithExtendedInfo.add(abstractState);
        }
        return successorsWithExtendedInfo;
    }

    AbstractState attachAdditionalInfoToCallNode(AbstractState pElem) {
        if (!(pElem instanceof BAMARGBlockStartState) && pElem instanceof ARGState) {
            return this.createAdditionalInfo((ARGState)pElem);
        }
        return pElem;
    }

    private ARGState createAdditionalInfo(ARGState pElem) {
        CFANode node = AbstractStates.extractLocation(pElem);
        if (this.partitioning.isCallNode(node) && !this.partitioning.getBlockForCallNode(node).equals(this.currentBlock)) {
            BAMARGBlockStartState replaceWith = new BAMARGBlockStartState(pElem.getWrappedState(), null);
            this.replaceInARG(pElem, replaceWith);
            return replaceWith;
        }
        return pElem;
    }

    private void replaceInARG(ARGState toReplace, ARGState replaceWith) {
        if (toReplace.isCovered()) {
            replaceWith.setCovered(toReplace.getCoveringState());
        }
        toReplace.uncover();
        toReplace.replaceInARGWith(replaceWith);
    }

    void addBlockAnalysisInfo(AbstractState pElement) throws CPATransferException {
        if (this.data.getCache().getLastAnalyzedBlock() == null || !(pElement instanceof BAMARGBlockStartState)) {
            throw new CPATransferException("Cannot build proof, ARG, for BAM analysis.");
        }
        ((BAMARGBlockStartState)pElement).setAnalyzedBlock(this.data.getCache().getLastAnalyzedBlock());
    }

    void setCurrentBlock(Block pCurrentBlock) {
        this.currentBlock = pCurrentBlock;
    }
}

