/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Function;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMPCCManager;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class BAMPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecisionAdjustment;
    private final @Nullable BAMPCCManager bamPccManager;
    private final BAMDataManager data;
    private final LogManager logger;
    private final BlockPartitioning blockPartitioning;

    public BAMPrecisionAdjustment(PrecisionAdjustment pWrappedPrecisionAdjustment, BAMDataManager pData, @Nullable BAMPCCManager pBamPccManager, LogManager pLogger, BlockPartitioning pBlockPartitioning) {
        this.wrappedPrecisionAdjustment = pWrappedPrecisionAdjustment;
        this.data = pData;
        this.bamPccManager = pBamPccManager;
        this.logger = pLogger;
        this.blockPartitioning = pBlockPartitioning;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        AbstractState newState;
        Optional<PrecisionAdjustmentResult> result;
        Precision expandedPrecision;
        Precision validPrecision = pPrecision;
        if ((AbstractStates.isTargetState(pElement) || this.blockPartitioning.isReturnNode(AbstractStates.extractLocation(pElement))) && (expandedPrecision = this.data.getExpandedPrecisionForState(pElement)) != null) {
            validPrecision = expandedPrecision;
        }
        if (!(result = this.wrappedPrecisionAdjustment.prec(pElement, validPrecision, pElements, projection, fullState)).isPresent()) {
            return result;
        }
        if (this.bamPccManager != null && this.bamPccManager.isPCCEnabled()) {
            result = result.map(t -> t.withAbstractState(this.bamPccManager.attachAdditionalInfoToCallNode(t.abstractState())));
        }
        if (pElement != (newState = result.orElseThrow().abstractState())) {
            this.logger.log(Level.ALL, new Object[]{"before PREC:", pElement});
            this.logger.log(Level.ALL, new Object[]{"after PREC:", newState});
            this.data.replaceStateInCaches(pElement, newState, false);
        }
        return result;
    }
}

