/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Function;
import java.util.Optional;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.bam.MissingBlockAbstractionState;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;

class BAMPrecisionAdjustmentWithBreakOnMissingBlock
extends BAMPrecisionAdjustment {
    private final boolean breakOnMissingBlock;

    public BAMPrecisionAdjustmentWithBreakOnMissingBlock(PrecisionAdjustment pWrappedPrecisionAdjustment, BAMDataManager pData, LogManager pLogger, BlockPartitioning pBlockPartitioning, boolean pBreakForMissingBlock) {
        super(pWrappedPrecisionAdjustment, pData, null, pLogger, pBlockPartitioning);
        this.breakOnMissingBlock = pBreakForMissingBlock;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision pPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        if (pElement instanceof MissingBlockAbstractionState) {
            PrecisionAdjustmentResult.Action action = this.breakOnMissingBlock ? PrecisionAdjustmentResult.Action.BREAK : PrecisionAdjustmentResult.Action.CONTINUE;
            return Optional.of(PrecisionAdjustmentResult.create(pElement, pPrecision, action));
        }
        return super.prec(pElement, pPrecision, pElements, projection, fullState);
    }
}

