/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableSubgraphReachedSetView;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.ARGCopyOnWriteSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.ARGInPlaceSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.ARGSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class BAMReachedSet
extends ARGReachedSet.ForwardingARGReachedSet {
    private final AbstractBAMCPA bamCpa;
    private final ARGPath path;
    private final ThreadSafeTimerContainer.TimerWrapper removeCachedSubtreeTimer;

    public BAMReachedSet(AbstractBAMCPA cpa, ARGReachedSet pMainReachedSet, ARGPath pPath, ThreadSafeTimerContainer.TimerWrapper pRemoveCachedSubtreeTimer) {
        super(pMainReachedSet);
        this.bamCpa = cpa;
        this.path = pPath;
        this.removeCachedSubtreeTimer = pRemoveCachedSubtreeTimer;
        assert (this.path.getFirstState().getSubgraph().toSet().containsAll(this.path.asStatesList())) : "path should traverse reachable states";
    }

    @Override
    public UnmodifiableReachedSet asReachedSet() {
        return new UnmodifiableSubgraphReachedSetView(this.path, (Function<AbstractState, Precision>)((Function)s -> super.asReachedSet().getPrecision(super.asReachedSet().getLastState())));
    }

    @Override
    public void removeSubtree(ARGState element, Precision newPrecision, Predicate<? super Precision> pPrecisionType) throws InterruptedException {
        this.removeSubtree(element, (List<Precision>)ImmutableList.of((Object)newPrecision), (List<Predicate<? super Precision>>)ImmutableList.of(pPrecisionType));
    }

    @Override
    public void removeSubtree(ARGState element, List<Precision> newPrecisions, List<Predicate<? super Precision>> pPrecisionTypes) throws InterruptedException {
        Preconditions.checkArgument((newPrecisions.size() == pPrecisionTypes.size() ? 1 : 0) != 0);
        assert (this.path.getFirstState().getSubgraph().contains((Object)element));
        ARGSubtreeRemover argSubtreeRemover = this.bamCpa.useCopyOnWriteRefinement() ? new ARGCopyOnWriteSubtreeRemover(this.bamCpa, this.removeCachedSubtreeTimer) : new ARGInPlaceSubtreeRemover(this.bamCpa, this.removeCachedSubtreeTimer);
        argSubtreeRemover.removeSubtree(this.delegate, this.path, element, newPrecisions, pPrecisionTypes);
        for (ARGState state : element.getSubgraph()) {
            state.removeFromARG();
        }
    }

    @Override
    public void removeSubtree(ARGState state) throws InterruptedException {
        this.removeSubtree(state, (List<Precision>)ImmutableList.of(), (List<Predicate<? super Precision>>)ImmutableList.of());
    }

    public String toString() {
        return "BAMReachedSet {{" + this.asReachedSet().asCollection() + "}}";
    }
}

