/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;

@Options(prefix="cpa.bam")
class BAMReachedSetExporter
implements Statistics {
    @Option(secure=true, description="export blocked ARG as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path argFile = Path.of("BlockedARG.dot", new String[0]);
    @Option(secure=true, description="export single blocked ARG as .dot files, should contain '%d'")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate indexedArgFile = PathTemplate.ofFormatString((String)"ARGs/ARG_%d.dot");
    @Option(secure=true, description="export used parts of blocked ARG as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path simplifiedArgFile = Path.of("BlockedARGSimplified.dot", new String[0]);
    private final LogManager logger;
    private final AbstractBAMCPA bamcpa;

    BAMReachedSetExporter(Configuration pConfig, LogManager pLogger, AbstractBAMCPA pCpa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.bamcpa = pCpa;
    }

    private static boolean highlightSummaryEdge(ARGState firstState, ARGState secondState) {
        return firstState.getEdgeToChild(secondState) instanceof FunctionSummaryEdge;
    }

    @Override
    public @Nullable String getName() {
        return null;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        this.exportAllReachedSets(this.argFile, this.indexedArgFile, pReached);
        this.exportUsedReachedSets(this.simplifiedArgFile, pReached);
    }

    private void exportAllReachedSets(Path superArgFile, PathTemplate indexedFile, UnmodifiableReachedSet mainReachedSet) {
        if (superArgFile != null) {
            LinkedHashSet<ReachedSet> allReachedSets = new LinkedHashSet<ReachedSet>(this.bamcpa.getData().getCache().getAllCachedReachedStates());
            allReachedSets.add((ReachedSet)mainReachedSet);
            LinkedHashSet<ARGState> rootStates = new LinkedHashSet<ARGState>();
            LinkedHashMultimap connections = LinkedHashMultimap.create();
            for (UnmodifiableReachedSet unmodifiableReachedSet : allReachedSets) {
                ARGState rootState = (ARGState)unmodifiableReachedSet.getFirstState();
                rootStates.add(rootState);
                LinkedHashMultimap localConnections = LinkedHashMultimap.create();
                this.getConnections(rootState, (Multimap<ARGState, ARGState>)localConnections);
                connections.putAll((Multimap)localConnections);
                this.writeArg(indexedFile.getPath(new Object[]{((ARGState)unmodifiableReachedSet.getFirstState()).getStateId()}), (Multimap<ARGState, ARGState>)localConnections, Collections.singleton((ARGState)unmodifiableReachedSet.getFirstState()));
            }
            this.writeArg(superArgFile, (Multimap<ARGState, ARGState>)connections, rootStates);
        }
    }

    private void exportUsedReachedSets(Path superArgFile, UnmodifiableReachedSet mainReachedSet) {
        if (superArgFile != null) {
            LinkedHashMultimap connections = LinkedHashMultimap.create();
            Set<ARGState> rootStates = this.getUsedRootStates(mainReachedSet, (Multimap<ARGState, ARGState>)connections);
            this.writeArg(superArgFile, (Multimap<ARGState, ARGState>)connections, rootStates);
        }
    }

    private void writeArg(Path file, Multimap<ARGState, ARGState> connections, Set<ARGState> rootStates) {
        try (Writer w = IO.openOutputFile((Path)file, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            ARGToDotWriter.write(w, rootStates, connections, ARGState::getChildren, (Predicate<? super ARGState>)Predicates.alwaysTrue(), BAMReachedSetExporter::highlightSummaryEdge);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, String.format("Could not write ARG to file: %s", file));
        }
    }

    private Set<ARGState> getUsedRootStates(UnmodifiableReachedSet mainReachedSet, Multimap<ARGState, ARGState> connections) {
        LinkedHashSet<UnmodifiableReachedSet> finished = new LinkedHashSet<UnmodifiableReachedSet>();
        ArrayDeque<UnmodifiableReachedSet> waitlist = new ArrayDeque<UnmodifiableReachedSet>();
        waitlist.add(mainReachedSet);
        while (!waitlist.isEmpty()) {
            UnmodifiableReachedSet reachedSet = (UnmodifiableReachedSet)waitlist.pop();
            if (!finished.add(reachedSet)) continue;
            ARGState rootState = (ARGState)reachedSet.getFirstState();
            Set<ReachedSet> referencedReachedSets = this.getConnections(rootState, connections);
            waitlist.addAll(referencedReachedSets);
        }
        LinkedHashSet<ARGState> rootStates = new LinkedHashSet<ARGState>();
        for (UnmodifiableReachedSet reachedSet : finished) {
            rootStates.add((ARGState)reachedSet.getFirstState());
        }
        return rootStates;
    }

    private Set<ReachedSet> getConnections(ARGState rootState, Multimap<ARGState, ARGState> connections) {
        BAMDataManager data = this.bamcpa.getData();
        LinkedHashSet<ReachedSet> referencedReachedSets = new LinkedHashSet<ReachedSet>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(rootState);
        while (!waitlist.isEmpty()) {
            ARGState state = (ARGState)waitlist.pop();
            if (!finished.add(state)) continue;
            if (data.hasInitialState(state)) {
                for (ARGState child : state.getChildren()) {
                    assert (data.hasExpandedState(child));
                    ARGState reducedExitState = (ARGState)data.getReducedStateForExpandedState(child);
                    if (reducedExitState.isDestroyed()) continue;
                    ReachedSet target = data.getReachedSetForInitialState(state, reducedExitState);
                    referencedReachedSets.add(target);
                    ARGState targetState = (ARGState)target.getFirstState();
                    connections.put((Object)state, (Object)targetState);
                }
            }
            if (data.hasExpandedState(state)) {
                AbstractState sourceState = data.getReducedStateForExpandedState(state);
                connections.put((Object)((ARGState)sourceState), (Object)state);
            }
            waitlist.addAll(state.getChildren());
        }
        return referencedReachedSets;
    }
}

