/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class BAMReachedSetValidator {
    public static boolean validateData(BAMDataManager data, BlockPartitioning partitioning, ARGReachedSet mainReachedSet) {
        ARGState mainEntry = (ARGState)mainReachedSet.asReachedSet().getFirstState();
        assert (mainEntry.getParents().isEmpty());
        Collection<ReachedSet> reachedSets = data.getCache().getAllCachedReachedStates();
        assert (BAMReachedSetValidator.validateReachedSet((Set<ARGState>)mainEntry.getSubgraph().toSet(), mainReachedSet.asReachedSet(), data, partitioning, reachedSets));
        assert (!reachedSets.contains(mainReachedSet.asReachedSet()));
        for (ReachedSet rs : reachedSets) {
            assert (BAMReachedSetValidator.validateReachedSet((Set<ARGState>)((ARGState)rs.getFirstState()).getSubgraph().toSet(), rs, data, partitioning, reachedSets));
        }
        return true;
    }

    private static boolean validateReachedSet(Set<ARGState> subgraph, UnmodifiableReachedSet reachedSet, BAMDataManager data, BlockPartitioning partitioning, @Nullable Collection<ReachedSet> reachedSets) {
        assert (subgraph.containsAll(reachedSet.asCollection()));
        for (ARGState aRGState : subgraph) {
            assert (!aRGState.isDestroyed());
            assert (subgraph.containsAll(aRGState.getChildren()));
            assert (subgraph.containsAll(aRGState.getParents()));
            assert (subgraph.containsAll(aRGState.getCoveredByThis()));
            if (aRGState.isCovered()) {
                assert (subgraph.contains(aRGState.getCoveringState()));
                assert (!reachedSet.contains(aRGState));
                continue;
            }
            assert (reachedSet.contains(aRGState));
        }
        for (AbstractState abstractState : reachedSet.getWaitlist()) {
            assert (reachedSet.contains(abstractState));
        }
        for (ARGState aRGState : subgraph) {
            CFANode node = AbstractStates.extractLocation(aRGState);
            if (partitioning.isCallNode(node) && data.hasInitialState(aRGState)) {
                for (ARGState child : aRGState.getChildren()) {
                    assert (data.hasExpandedState(child)) : "child of non-reduced initial state should be expanded: " + child;
                    ARGState reducedChild = (ARGState)data.getReducedStateForExpandedState(child);
                    if (reducedChild.isDestroyed()) continue;
                    ReachedSet reachedSet2 = data.getReachedSetForInitialState(aRGState, reducedChild);
                }
            }
            if (!partitioning.isReturnNode(node)) continue;
            for (AbstractState tmp : data.getExpandedStatesList(aRGState)) {
                assert (data.hasInitialState((AbstractState)Iterables.getOnlyElement(((ARGState)tmp).getParents()))) : "single parent of expanded state should be non-reduced initial state: " + aRGState;
            }
        }
        return true;
    }
}

