/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.ARGInPlaceSubtreeRemover;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;

public class BAMSubgraphComputer {
    private final BlockPartitioning partitioning;
    private final Reducer reducer;
    protected final BAMDataManager data;
    private final LogManager logger;
    private final boolean useCopyOnWriteRefinement;
    private final boolean cleanupOnMissingBlock;

    BAMSubgraphComputer(AbstractBAMCPA bamCpa, boolean pCleanupOnMissingBlock) {
        this.partitioning = bamCpa.getBlockPartitioning();
        this.reducer = bamCpa.getReducer();
        this.data = bamCpa.getData();
        this.logger = bamCpa.getLogger();
        this.useCopyOnWriteRefinement = bamCpa.useCopyOnWriteRefinement();
        this.cleanupOnMissingBlock = pCleanupOnMissingBlock;
    }

    Pair<BackwardARGState, BackwardARGState> computeCounterexampleSubgraph(ARGState target, ARGReachedSet pMainReachedSet) throws MissingBlockException, InterruptedException {
        Pair<BackwardARGState, Collection<BackwardARGState>> p = this.computeCounterexampleSubgraph(Collections.singleton(target), pMainReachedSet);
        return Pair.of(p.getFirst(), (BackwardARGState)Iterables.getOnlyElement((Iterable)p.getSecond()));
    }

    Pair<BackwardARGState, Collection<BackwardARGState>> computeCounterexampleSubgraph(Collection<ARGState> targets, ARGReachedSet pMainReachedSet) throws MissingBlockException, InterruptedException {
        UnmodifiableReachedSet mainRs = pMainReachedSet.asReachedSet();
        assert (mainRs.asCollection().containsAll(targets)) : "target states should be contained in reached-set. The following states are not contained: " + Iterables.filter(targets, s -> !mainRs.contains((AbstractState)s));
        if (targets.isEmpty()) {
            return Pair.of(new BackwardARGState((ARGState)mainRs.getFirstState()), ImmutableList.of());
        }
        ImmutableList newTargets = Collections3.transformedImmutableListCopy(targets, BackwardARGState::new);
        BackwardARGState root = this.computeCounterexampleSubgraph(pMainReachedSet, (Collection<BackwardARGState>)newTargets);
        assert (mainRs.getFirstState() == root.getARGState());
        return Pair.of(root, newTargets);
    }

    private BackwardARGState computeCounterexampleSubgraph(ARGReachedSet reachedSet, Collection<BackwardARGState> newTreeTargets) throws MissingBlockException, InterruptedException {
        UnmodifiableReachedSet rs = reachedSet.asReachedSet();
        HashMap<ARGState, BackwardARGState> finishedStates = new HashMap<ARGState, BackwardARGState>();
        TreeSet<ARGState> waitlist = new TreeSet<ARGState>();
        BackwardARGState root = null;
        for (BackwardARGState newTreeTarget : newTreeTargets) {
            ARGState target = newTreeTarget.getARGState();
            assert (rs.contains(target));
            finishedStates.put(target, newTreeTarget);
            waitlist.addAll(target.getParents());
        }
        while (!waitlist.isEmpty()) {
            ARGState currentState = (ARGState)waitlist.pollLast();
            assert (rs.contains(currentState));
            if (finishedStates.containsKey(currentState)) continue;
            BackwardARGState newCurrentState = new BackwardARGState(currentState);
            finishedStates.put(currentState, newCurrentState);
            waitlist.addAll(currentState.getParents());
            TreeSet<BackwardARGState> childrenInSubgraph = new TreeSet<BackwardARGState>();
            for (ARGState child : currentState.getChildren()) {
                if (!finishedStates.containsKey(child)) continue;
                childrenInSubgraph.add((BackwardARGState)finishedStates.get(child));
            }
            if (this.data.hasInitialState(currentState)) {
                try {
                    this.computeCounterexampleSubgraphForBlock(newCurrentState, childrenInSubgraph);
                }
                catch (MissingBlockException e) {
                    assert (!this.useCopyOnWriteRefinement) : "CopyOnWrite-refinement should never cause missing blocks: " + e;
                    if (this.cleanupOnMissingBlock && !currentState.isDestroyed()) {
                        ARGInPlaceSubtreeRemover.removeSubtree(reachedSet, currentState);
                    }
                    throw e;
                }
            } else {
                for (BackwardARGState newChild : childrenInSubgraph) {
                    newChild.addParent(newCurrentState);
                }
            }
            if (!currentState.getParents().isEmpty()) continue;
            assert (root == null) : "root should not be set before";
            assert (waitlist.isEmpty()) : "root should have the smallest ID";
            root = newCurrentState;
        }
        assert (root != null) : "no root state found in reachedset with initial state " + reachedSet.asReachedSet().getFirstState();
        return root;
    }

    protected void computeCounterexampleSubgraphForBlock(BackwardARGState newExpandedRoot, Set<BackwardARGState> newExpandedTargets) throws MissingBlockException, InterruptedException {
        ARGState expandedRoot = (ARGState)newExpandedRoot.getWrappedState();
        LinkedHashMultimap reachedSets = LinkedHashMultimap.create();
        HashMap<BackwardARGState, BackwardARGState> newExpandedToNewInnerTargets = new HashMap<BackwardARGState, BackwardARGState>();
        for (BackwardARGState backwardARGState : newExpandedTargets) {
            if (!this.data.hasExpandedState(backwardARGState.getARGState())) {
                this.logger.log(Level.FINE, new Object[]{"Target state refers to a missing ARGState, i.e., the cached subtree was deleted. Updating it."});
                throw new MissingBlockException(expandedRoot, backwardARGState.getWrappedState());
            }
            ARGState reducedTarget = (ARGState)this.data.getReducedStateForExpandedState(backwardARGState.getARGState());
            if (reducedTarget.isDestroyed()) {
                this.logger.log(Level.FINE, new Object[]{"Target state refers to a destroyed ARGState, i.e., the cached subtree is outdated. Updating it."});
                throw new MissingBlockException(expandedRoot, backwardARGState.getWrappedState());
            }
            ReachedSet reachedSet = this.data.getReachedSetForInitialState(expandedRoot, reducedTarget);
            assert (reachedSet.contains(reducedTarget)) : String.format("reduced state '%s' is not part of reachedset with root '%s' from expanded root '%s'", reducedTarget, reachedSet.getFirstState(), expandedRoot);
            BackwardARGState newBackwardTarget = new BackwardARGState(reducedTarget);
            newExpandedToNewInnerTargets.put(backwardARGState, newBackwardTarget);
            reachedSets.put((Object)reachedSet, (Object)newBackwardTarget);
        }
        for (ReachedSet reachedSet : reachedSets.keySet()) {
            BackwardARGState newInnerRoot;
            try {
                newInnerRoot = this.computeCounterexampleSubgraph(new ARGReachedSet(reachedSet), newExpandedToNewInnerTargets.values());
            }
            catch (MissingBlockException e) {
                this.logger.log(Level.FINE, new Object[]{"Target state refers to a destroyed ARGState, i.e., the cached subtree will be removed."});
                CFANode rootNode = AbstractStates.extractLocation(expandedRoot);
                Block rootBlock = this.partitioning.getBlockForCallNode(rootNode);
                AbstractState reducedRootState = this.reducer.getVariableReducedState(expandedRoot, rootBlock, rootNode);
                BAMCache.BAMCacheEntry cacheEntry = this.data.getCache().get(reducedRootState, reachedSet.getPrecision(reachedSet.getFirstState()), rootBlock);
                if (cacheEntry != null) {
                    cacheEntry.deleteInfo();
                }
                throw e;
            }
            for (ARGState innerChild : newInnerRoot.getChildren()) {
                innerChild.addParent(newExpandedRoot);
            }
            newInnerRoot.removeFromARG();
        }
        for (ARGState aRGState : newExpandedTargets) {
            BackwardARGState newInnerTarget = (BackwardARGState)newExpandedToNewInnerTargets.get(aRGState);
            for (ARGState innerParent : newInnerTarget.getParents()) {
                aRGState.addParent(innerParent);
            }
            newInnerTarget.removeFromARG();
        }
    }

    static class MissingBlockException
    extends CPAException {
        private static final long serialVersionUID = 123L;
        private final AbstractState initialState;
        private final AbstractState exitState;

        public MissingBlockException(AbstractState pInitialState, AbstractState pExitState) {
            super(String.format("missing block for non-reduced initial state %n%s and expanded exit state %n%s", pInitialState, pExitState));
            this.initialState = (AbstractState)Preconditions.checkNotNull((Object)pInitialState);
            this.exitState = (AbstractState)Preconditions.checkNotNull((Object)pExitState);
        }

        AbstractState getInitialState() {
            return this.initialState;
        }

        AbstractState getExitState() {
            return this.exitState;
        }
    }

    static class BackwardARGState
    extends ARGState {
        private static final long serialVersionUID = -3279533907385516993L;

        public BackwardARGState(ARGState originalState) {
            super(originalState, null);
        }

        public ARGState getARGState() {
            return (ARGState)this.getWrappedState();
        }

        public BackwardARGState copy() {
            return new BackwardARGState(this.getARGState());
        }

        @Override
        public String toString() {
            return "BackwardARGState {{" + super.toString() + "}}";
        }
    }
}

