/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bam.BAMMultipleCEXSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.BAMSubgraphComputer;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class BAMSubgraphIterator {
    private final ARGState targetState;
    private final BAMMultipleCEXSubgraphComputer subgraphComputer;
    private final BAMDataManager data;
    private BAMSubgraphComputer.BackwardARGState firstState;
    private Map<ARGState, Iterator<ARGState>> toCallerStatesIterator = new HashMap<ARGState, Iterator<ARGState>>();
    private boolean hasNextPath;

    BAMSubgraphIterator(ARGState pTargetState, BAMMultipleCEXSubgraphComputer sComputer, BAMDataManager pData) {
        this.targetState = pTargetState;
        this.subgraphComputer = sComputer;
        this.data = pData;
        this.firstState = null;
        this.hasNextPath = true;
    }

    private ARGPath computeNextPath(BAMSubgraphComputer.BackwardARGState lastAffectedState, Set<List<Integer>> pRefinedStates) {
        BAMSubgraphComputer.BackwardARGState nextBranchingParentOnPath;
        assert (lastAffectedState != null);
        ARGState nextParent = null;
        BAMSubgraphComputer.BackwardARGState childOfReducedState = null;
        ARGPath newPath = null;
        List<BAMSubgraphComputer.BackwardARGState> potentialBranchingStates = this.findBranchingStatesAfter(lastAffectedState);
        if (potentialBranchingStates.isEmpty()) {
            return null;
        }
        Iterator<BAMSubgraphComputer.BackwardARGState> forkIterator = potentialBranchingStates.iterator();
        do {
            nextParent = null;
            while (nextParent == null && forkIterator.hasNext()) {
                childOfReducedState = forkIterator.next();
                nextParent = this.findNextExpandedState(childOfReducedState);
            }
            if (nextParent == null) {
                return null;
            }
            BAMSubgraphComputer.BackwardARGState rootOfTheClonedPath = this.cloneTheRestOfPath(childOfReducedState);
            nextBranchingParentOnPath = new BAMSubgraphComputer.BackwardARGState(nextParent);
            rootOfTheClonedPath.addParent(nextBranchingParentOnPath);
        } while ((newPath = this.subgraphComputer.restorePathFrom(nextBranchingParentOnPath, pRefinedStates)) == null);
        return newPath;
    }

    private BAMSubgraphComputer.BackwardARGState cloneTheRestOfPath(BAMSubgraphComputer.BackwardARGState pChildOfForkState) {
        BAMSubgraphComputer.BackwardARGState stateOnClonedPath;
        BAMSubgraphComputer.BackwardARGState stateOnOriginPath = pChildOfForkState;
        BAMSubgraphComputer.BackwardARGState root = stateOnClonedPath = stateOnOriginPath.copy();
        while (!stateOnOriginPath.getChildren().isEmpty()) {
            stateOnOriginPath = this.getNextStateOnPath(stateOnOriginPath);
            BAMSubgraphComputer.BackwardARGState tmpStateOnPath = stateOnOriginPath.copy();
            tmpStateOnPath.addParent(stateOnClonedPath);
            stateOnClonedPath = tmpStateOnPath;
        }
        return root;
    }

    private ARGState findNextExpandedState(BAMSubgraphComputer.BackwardARGState forkChildInPath) {
        Iterator iterator;
        ARGState forkChildInARG = forkChildInPath.getARGState();
        if (this.toCallerStatesIterator.containsKey(forkChildInARG)) {
            iterator = this.toCallerStatesIterator.get(forkChildInARG);
        } else {
            ARGState reducedStateInARG = forkChildInARG.getParents().iterator().next();
            iterator = FluentIterable.from(new TreeSet<AbstractState>((Collection<AbstractState>)this.data.getNonReducedInitialStates(reducedStateInARG))).skip(1).transform(s -> (ARGState)s).iterator();
            this.toCallerStatesIterator.put(forkChildInARG, iterator);
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private List<BAMSubgraphComputer.BackwardARGState> findBranchingStatesAfter(BAMSubgraphComputer.BackwardARGState parent) {
        ArrayList<BAMSubgraphComputer.BackwardARGState> potentialForkStates = new ArrayList<BAMSubgraphComputer.BackwardARGState>();
        HashMap<ARGState, BAMSubgraphComputer.BackwardARGState> mapToPath = new HashMap<ARGState, BAMSubgraphComputer.BackwardARGState>();
        BAMSubgraphComputer.BackwardARGState currentStateOnPath = parent;
        while (!currentStateOnPath.getChildren().isEmpty()) {
            ARGState currentStateInARG = (currentStateOnPath = this.getNextStateOnPath(currentStateOnPath)).getARGState();
            ARGState parentInARG = currentStateInARG.getParents().iterator().next();
            if (this.data.getNonReducedInitialStates(parentInARG).size() > 1) {
                assert (parentInARG.getParents().isEmpty());
                assert (AbstractStates.extractLocation(parentInARG) instanceof FunctionEntryNode);
                ARGState expandedEntryState = this.getPreviousStateOnPath(currentStateOnPath).getARGState();
                mapToPath.put(expandedEntryState, currentStateOnPath);
                potentialForkStates.add(currentStateOnPath);
            }
            FluentIterable.from(parentInARG.getParents()).filter(mapToPath::containsKey).transform(mapToPath::get).forEach(potentialForkStates::remove);
        }
        return potentialForkStates;
    }

    public ARGPath nextPath(Set<List<Integer>> pRefinedStatesIds) {
        ARGPath path;
        if (!this.hasNextPath) {
            return null;
        }
        do {
            if ((path = this.firstState == null ? this.subgraphComputer.restorePathFrom(new BAMSubgraphComputer.BackwardARGState(this.targetState), pRefinedStatesIds) : this.computeNextPath(this.firstState, pRefinedStatesIds)) == null) continue;
            this.firstState = (BAMSubgraphComputer.BackwardARGState)path.getFirstState();
        } while (path != null && this.subgraphComputer.checkThePathHasRepeatedStates(path, pRefinedStatesIds));
        if (path == null) {
            this.hasNextPath = false;
        }
        return path;
    }

    private BAMSubgraphComputer.BackwardARGState getNextStateOnPath(BAMSubgraphComputer.BackwardARGState state) {
        return (BAMSubgraphComputer.BackwardARGState)state.getChildren().iterator().next();
    }

    private BAMSubgraphComputer.BackwardARGState getPreviousStateOnPath(BAMSubgraphComputer.BackwardARGState state) {
        return (BAMSubgraphComputer.BackwardARGState)state.getParents().iterator().next();
    }
}

