/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperTransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGUtils;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAStatistics;
import org.sosy_lab.cpachecker.cpa.bam.BAMPCCManager;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

public class BAMTransferRelation
extends AbstractBAMTransferRelation<CPAException> {
    protected final Deque<Triple<AbstractState, Precision, Block>> stack = new ArrayDeque<Triple<AbstractState, Precision, Block>>();
    private final Algorithm.AlgorithmFactory algorithmFactory;
    protected final BAMPCCManager bamPccManager;
    private final CallstackTransferRelation callstackTransfer;
    private final BAMCPAStatistics stats;
    private final boolean searchTargetStatesOnExit;

    public BAMTransferRelation(BAMCPA bamCpa, ShutdownNotifier pShutdownNotifier, Algorithm.AlgorithmFactory pFactory, BAMPCCManager pBamPccManager, boolean pSearchTargetStatesOnExit) {
        super(bamCpa, pShutdownNotifier);
        this.algorithmFactory = pFactory;
        this.callstackTransfer = (CallstackTransferRelation)Preconditions.checkNotNull((Object)((WrapperTransferRelation)this.transferRelation).retrieveWrappedTransferRelation(CallstackTransferRelation.class));
        this.bamPccManager = pBamPccManager;
        this.stats = bamCpa.getStatistics();
        this.searchTargetStatesOnExit = pSearchTargetStatesOnExit;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        Collection<AbstractState> successors = super.getAbstractSuccessors(pState, pPrecision);
        if (this.bamPccManager.isPCCEnabled()) {
            return this.bamPccManager.attachAdditionalInfoToCallNodes(successors);
        }
        if (Iterables.any(successors, AbstractStates::isTargetState)) {
            this.stats.depthsOfTargetStates.insertValue(this.stack.size());
            this.stats.depthsOfFoundTargetStates.insertValue(this.stack.size() + this.data.getExpandedStatesList(successors.iterator().next()).size());
        }
        return successors;
    }

    @Override
    protected Collection<? extends AbstractState> getWrappedTransferSuccessor(ARGState pState, Precision pPrecision, CFANode node) throws CPATransferException, InterruptedException {
        boolean foundRecursion = this.isRecursiveCall(node);
        if (foundRecursion) {
            this.callstackTransfer.enableRecursiveContext();
        }
        Collection<? extends AbstractState> result = this.transferRelation.getAbstractSuccessors(pState, pPrecision);
        if (foundRecursion) {
            this.callstackTransfer.disableRecursiveContext();
        }
        return result;
    }

    @Override
    protected Block getBlockForState(ARGState state) {
        return this.stack.isEmpty() ? this.partitioning.getMainBlock() : this.stack.peek().getThird();
    }

    protected boolean isRecursiveCall(CFANode node) {
        if (!this.partitioning.isCallNode(node)) {
            for (CFAEdge e : CFAUtils.leavingEdges(node).filter(CFunctionCallEdge.class)) {
                for (Block block : Iterables.transform(this.stack, Triple::getThird)) {
                    if (!block.getCallNodes().contains(e.getSuccessor())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<AbstractState> doRecursiveAnalysis(AbstractState initialState, Precision pPrecision, CFANode node) throws CPAException, InterruptedException {
        Collection<AbstractState> collection;
        Block outerSubtree = this.getBlockForState((ARGState)initialState);
        assert (outerSubtree == (this.stack.isEmpty() ? this.partitioning.getMainBlock() : this.stack.peek().getThird()));
        Block innerSubtree = this.partitioning.getBlockForCallNode(node);
        this.bamPccManager.setCurrentBlock(innerSubtree);
        assert (innerSubtree.getCallNodes().contains(node));
        this.logger.log(Level.FINEST, new Object[]{"Reducing state", initialState});
        AbstractState reducedInitialState = this.wrappedReducer.getVariableReducedState(initialState, innerSubtree, node);
        Precision reducedInitialPrecision = this.wrappedReducer.getVariableReducedPrecision(pPrecision, innerSubtree);
        Triple<AbstractState, Precision, Block> currentLevel = Triple.of(reducedInitialState, reducedInitialPrecision, innerSubtree);
        this.stack.push(currentLevel);
        this.logger.log(Level.FINEST, new Object[]{"Starting recursive analysis of depth", this.stack.size(), " with current Stack:", this.stack});
        this.stats.updateBlockNestingLevel(this.stack.size());
        this.stats.switchBlock(outerSubtree, innerSubtree);
        try {
            collection = this.analyseBlockAndExpand(initialState, pPrecision, innerSubtree, outerSubtree, reducedInitialState, reducedInitialPrecision);
        }
        catch (Throwable throwable) {
            this.logger.log(Level.FINEST, new Object[]{"Finished recursive analysis of depth", this.stack.size()});
            this.stats.switchBlock(innerSubtree, outerSubtree);
            Triple<AbstractState, Precision, Block> lastLevel = this.stack.pop();
            assert (lastLevel.equals(currentLevel));
            this.bamPccManager.setCurrentBlock(outerSubtree);
            throw throwable;
        }
        this.logger.log(Level.FINEST, new Object[]{"Finished recursive analysis of depth", this.stack.size()});
        this.stats.switchBlock(innerSubtree, outerSubtree);
        Triple<AbstractState, Precision, Block> lastLevel = this.stack.pop();
        assert (lastLevel.equals(currentLevel));
        this.bamPccManager.setCurrentBlock(outerSubtree);
        return collection;
    }

    protected Collection<AbstractState> analyseBlockAndExpand(AbstractState entryState, Precision precision, Block innerSubtree, @Nullable Block outerSubtree, AbstractState reducedInitialState, Precision reducedInitialPrecision) throws CPAException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        Pair<Collection<AbstractState>, ReachedSet> reducedResult = this.getReducedResult(entryState, reducedInitialState, reducedInitialPrecision, innerSubtree);
        this.shutdownNotifier.shutdownIfNecessary();
        if (this.bamPccManager.isPCCEnabled()) {
            this.bamPccManager.addBlockAnalysisInfo(reducedInitialState);
        }
        List<AbstractState> expandedStates = this.expandResultStates(reducedResult.getFirst(), reducedResult.getSecond(), innerSubtree, outerSubtree, entryState, precision);
        this.shutdownNotifier.shutdownIfNecessary();
        return expandedStates;
    }

    private Pair<Collection<AbstractState>, ReachedSet> getReducedResult(AbstractState initialState, AbstractState reducedInitialState, Precision reducedInitialPrecision, Block innerSubtree) throws InterruptedException, CPAException {
        Collection<AbstractState> statesForFurtherAnalysis;
        Set<AbstractState> reducedResult;
        ReachedSet reached;
        BAMCache.BAMCacheEntry entry = this.data.getCache().get(reducedInitialState, reducedInitialPrecision, innerSubtree);
        if (entry == null) {
            entry = this.data.createAndRegisterNewReachedSet(reducedInitialState, reducedInitialPrecision, innerSubtree);
            this.logger.log(Level.FINEST, new Object[]{"Cache miss: starting recursive CPAAlgorithm with new initial reached-set."});
            reached = entry.getReachedSet();
            reducedResult = this.performCompositeAnalysisWithCPAAlgorithm(reached, innerSubtree);
            assert (reducedResult != null);
            statesForFurtherAnalysis = this.filterResultStatesForFurtherAnalysis(reducedResult, null);
        } else {
            ReachedSet cachedReached = entry.getReachedSet();
            Preconditions.checkNotNull((Object)cachedReached);
            @Nullable Set<AbstractState> cachedReturnStates = entry.getExitStates();
            if (this.isCacheHit(cachedReached, cachedReturnStates)) {
                this.logger.log(Level.FINEST, new Object[]{"Cache hit with finished reached-set with root", cachedReached.getFirstState()});
                Preconditions.checkNotNull(cachedReturnStates);
                reducedResult = cachedReturnStates;
                statesForFurtherAnalysis = cachedReturnStates;
                reached = cachedReached;
            } else {
                reached = cachedReached;
                this.logger.log(Level.FINEST, new Object[]{"Partial cache hit: starting recursive CPAAlgorithm with partial reached-set with root", reached.getFirstState()});
                reducedResult = this.performCompositeAnalysisWithCPAAlgorithm(reached, innerSubtree);
                Preconditions.checkNotNull(reducedResult);
                statesForFurtherAnalysis = this.filterResultStatesForFurtherAnalysis(reducedResult, cachedReturnStates);
            }
        }
        assert (reached != null);
        this.registerInitalAndExitStates(initialState, statesForFurtherAnalysis, reached);
        ARGState rootOfBlock = null;
        if (this.bamPccManager.isPCCEnabled()) {
            if (!(reached.getFirstState() instanceof ARGState)) {
                throw new CPATransferException("Cannot build proof, ARG, for BAM analysis.");
            }
            rootOfBlock = BAMARGUtils.copyARG((ARGState)reached.getFirstState());
        }
        entry.setExitStates(reducedResult);
        entry.setRootOfBlock(rootOfBlock);
        return Pair.of(statesForFurtherAnalysis, reached);
    }

    protected Collection<AbstractState> filterResultStatesForFurtherAnalysis(Collection<AbstractState> reducedResult, Collection<AbstractState> cachedReturnStates) throws CPAException, InterruptedException {
        return reducedResult;
    }

    private Set<AbstractState> performCompositeAnalysisWithCPAAlgorithm(ReachedSet reached, Block innerSubtree) throws InterruptedException, CPAException {
        this.stats.algorithmInstances.inc();
        Algorithm algorithm = this.algorithmFactory.newInstance();
        algorithm.run(reached);
        return BAMTransferRelation.extractExitStates(reached, innerSubtree, this.searchTargetStatesOnExit);
    }

    public static Set<AbstractState> extractExitStates(ReachedSet reached, Block innerSubtree, boolean pSearchTargetStatesOnExit) {
        Set<AbstractState> returnStates;
        AbstractState lastState = reached.getLastState();
        if (!pSearchTargetStatesOnExit && AbstractStates.isTargetState(lastState)) {
            returnStates = Collections.singleton(lastState);
        } else {
            assert (!reached.hasWaitingState());
            returnStates = new LinkedHashSet<AbstractState>();
            for (AbstractState returnState : AbstractStates.filterLocations(reached, innerSubtree.getReturnNodes())) {
                if (!((ARGState)returnState).getChildren().isEmpty()) continue;
                returnStates.add(returnState);
            }
            if (pSearchTargetStatesOnExit) {
                for (AbstractState targetState : AbstractStates.getTargetStates(reached)) {
                    assert (((ARGState)targetState).getChildren().isEmpty());
                    returnStates.add(targetState);
                }
            }
        }
        return returnStates;
    }

    public void cleanCaches() {
        this.data.clear();
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, Iterable<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        Collection<AbstractState> out = super.strengthen(pElement, pOtherElements, pCfaEdge, pPrecision);
        if (this.bamPccManager.isPCCEnabled()) {
            return this.bamPccManager.attachAdditionalInfoToCallNodes(out);
        }
        return out;
    }
}

