/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.MissingBlockAbstractionState;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.Pair;

public class BAMTransferRelationWithBreakOnMissingBlock
extends AbstractBAMTransferRelation<CPATransferException> {
    public BAMTransferRelationWithBreakOnMissingBlock(AbstractBAMCPA bamCPA, ShutdownNotifier pShutdownNotifier) {
        super(bamCPA, pShutdownNotifier);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        if (pState instanceof MissingBlockAbstractionState) {
            return ImmutableSet.of();
        }
        return super.getAbstractSuccessors(pState, pPrecision);
    }

    @Override
    protected Collection<AbstractState> doRecursiveAnalysis(AbstractState initialState, Precision pPrecision, CFANode node) throws InterruptedException {
        Precision reducedInitialPrecision;
        Block outerSubtree = this.getBlockForState((ARGState)initialState);
        Block innerSubtree = this.partitioning.getBlockForCallNode(node);
        assert (innerSubtree.getCallNodes().contains(node));
        AbstractState reducedInitialState = this.wrappedReducer.getVariableReducedState(initialState, innerSubtree, node);
        Pair<Collection<AbstractState>, ReachedSet> reducedResult = this.getReducedResult(initialState, reducedInitialState, reducedInitialPrecision = this.wrappedReducer.getVariableReducedPrecision(pPrecision, innerSubtree), innerSubtree);
        Collection<AbstractState> cachedReturnStates = reducedResult.getFirst();
        if (cachedReturnStates.size() == 1 && Iterables.getOnlyElement(cachedReturnStates) instanceof MissingBlockAbstractionState) {
            return cachedReturnStates;
        }
        return this.expandResultStates(cachedReturnStates, reducedResult.getSecond(), innerSubtree, outerSubtree, initialState, pPrecision);
    }

    private Pair<Collection<AbstractState>, ReachedSet> getReducedResult(AbstractState initialState, AbstractState reducedInitialState, Precision reducedInitialPrecision, Block innerSubtree) {
        Set<AbstractState> cachedReturnStates;
        BAMCache.BAMCacheEntry entry = this.data.getCache().get(reducedInitialState, reducedInitialPrecision, innerSubtree);
        ReachedSet cachedReached = entry == null ? null : entry.getReachedSet();
        Set<AbstractState> set = cachedReturnStates = entry == null ? null : entry.getExitStates();
        assert (cachedReturnStates == null || cachedReached != null) : "there cannot be result-states without reached-states";
        if (!this.isCacheHit(cachedReached, cachedReturnStates)) {
            MissingBlockAbstractionState mbas = new MissingBlockAbstractionState(initialState, reducedInitialState, reducedInitialPrecision, innerSubtree, cachedReached);
            return Pair.of(Collections.singleton(mbas), cachedReached);
        }
        Preconditions.checkNotNull((Object)entry);
        Preconditions.checkNotNull((Object)cachedReached);
        this.registerInitalAndExitStates(initialState, cachedReturnStates, cachedReached);
        entry.setExitStates(cachedReturnStates);
        entry.setRootOfBlock(null);
        return Pair.of(cachedReturnStates, cachedReached);
    }
}

