/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMPCCManager;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Triple;

@Options(prefix="cpa.bam")
public class BAMTransferRelationWithFixPointForRecursion
extends BAMTransferRelation {
    @Option(secure=true, description="if we cannot determine a repeating/covering call-state, we will run into CallStackOverflowException. Thus we bound the stack size (unsound!). This option only limits non-covered recursion, but not a recursion where we find a coverage and re-use the cached block several times. The value '-1' disables this option.")
    private int maximalDepthForExplicitRecursion = -1;
    private final BAMCPA bamCpa;
    private boolean recursionSeen = false;
    private boolean resultStatesChanged = false;
    private boolean targetFound = false;
    private final Collection<AbstractState> potentialRecursionUpdateStates = new LinkedHashSet<AbstractState>();

    public BAMTransferRelationWithFixPointForRecursion(Configuration pConfig, BAMCPA pBamCpa, ShutdownNotifier pShutdownNotifier, Algorithm.AlgorithmFactory pAlgorithmFactory, BAMPCCManager pBamPccManager, boolean pSearchTargetStatesOnExit) throws InvalidConfigurationException {
        super(pBamCpa, pShutdownNotifier, pAlgorithmFactory, pBamPccManager, pSearchTargetStatesOnExit);
        pConfig.inject((Object)this);
        this.bamCpa = pBamCpa;
    }

    @Override
    protected Collection<? extends AbstractState> getAbstractSuccessorsWithoutWrapping(AbstractState pState, Precision pPrecision) throws CPAException, InterruptedException {
        CFANode node = AbstractStates.extractLocation(pState);
        if (this.stack.isEmpty() && BAMTransferRelationWithFixPointForRecursion.isHeadOfMainFunction(node)) {
            return this.doFixpointIterationForRecursion(pState, pPrecision, node);
        }
        if (this.maximalDepthForExplicitRecursion != -1 && this.stack.size() > this.maximalDepthForExplicitRecursion) {
            return ImmutableSet.of();
        }
        return super.getAbstractSuccessorsWithoutWrapping(pState, pPrecision);
    }

    @Override
    protected boolean startNewBlockAnalysis(ARGState pState, CFANode node) {
        return this.partitioning.isCallNode(node) && !pState.getParents().isEmpty() && (!this.partitioning.getBlockForCallNode(node).equals(this.stack.isEmpty() ? null : ((Triple)this.stack.peek()).getThird()) || BAMTransferRelationWithFixPointForRecursion.isFunctionBlock(this.partitioning.getBlockForCallNode(node)));
    }

    @Override
    protected boolean exitBlockAnalysis(ARGState pState, CFANode node) {
        return super.exitBlockAnalysis(pState, node) && !this.data.alreadyReturnedFromSameBlock(pState, this.stack.isEmpty() ? null : (Block)((Triple)this.stack.peek()).getThird());
    }

    @Override
    protected boolean isRecursiveCall(CFANode node) {
        return false;
    }

    private Collection<? extends AbstractState> doFixpointIterationForRecursion(AbstractState pHeadOfMainFunctionState, Precision pPrecision, CFANode pHeadOfMainFunction) throws CPAException, InterruptedException {
        Collection<AbstractState> resultStates;
        assert (BAMTransferRelationWithFixPointForRecursion.isHeadOfMainFunction(pHeadOfMainFunction) && this.stack.isEmpty());
        int iterationCounter = 0;
        while (true) {
            if (!this.targetFound) {
                this.recursionSeen = false;
                this.resultStatesChanged = false;
                this.potentialRecursionUpdateStates.clear();
            }
            this.logger.log(Level.FINEST, new Object[]{"Starting recursive analysis of main-block"});
            resultStates = this.doRecursiveAnalysis(pHeadOfMainFunctionState, pPrecision, pHeadOfMainFunction);
            this.logger.log(Level.FINEST, new Object[]{"Finished recursive analysis of main-block"});
            this.targetFound = Iterables.any(resultStates, AbstractStates::isTargetState);
            if (this.targetFound) {
                this.logger.log(Level.INFO, new Object[]{"fixpoint-iteration aborted, because there was a target state."});
                break;
            }
            if (!this.resultStatesChanged) {
                this.logger.log(Level.INFO, new Object[]{"fixpoint-iteration aborted, because we did not get new states (fixpoint reached)."});
                ArrayList<AbstractState> exitStates = new ArrayList<AbstractState>(((ARGState)pHeadOfMainFunctionState).getChildren());
                assert (this.getStatesNotCoveredBy(resultStates, exitStates).isEmpty()) : "there should not be any new state.";
                resultStates = exitStates;
                break;
            }
            this.logger.log(Level.INFO, new Object[]{"fixpoint was not reached, starting new iteration", ++iterationCounter});
            this.reAddStatesForFixPointIteration();
        }
        return resultStates;
    }

    private void reAddStatesForFixPointIteration() {
        for (AbstractState recursionUpdateState : this.potentialRecursionUpdateStates) {
            for (ReachedSet reachedSet : this.data.getCache().getAllCachedReachedStates()) {
                if (!reachedSet.contains(recursionUpdateState)) continue;
                this.logger.log(Level.FINEST, new Object[]{"re-adding state", recursionUpdateState});
                reachedSet.reAddToWaitlist(recursionUpdateState);
            }
        }
    }

    private Triple<AbstractState, Precision, Block> getCoveringLevel(Triple<AbstractState, Precision, Block> currentLevel) throws CPAException, InterruptedException {
        for (Triple level : Iterables.skip((Iterable)this.stack, (int)1)) {
            if (level.getThird() != currentLevel.getThird() || !this.bamCpa.getWrappedCpa().isCoveredByRecursiveState(currentLevel.getFirst(), (AbstractState)level.getFirst())) continue;
            return level;
        }
        return null;
    }

    private Collection<AbstractState> getStatesNotCoveredBy(@NonNull Collection<AbstractState> baseStates, @NonNull Collection<AbstractState> coveringStates) throws CPAException, InterruptedException {
        ArrayList<AbstractState> notCoveredStates = new ArrayList<AbstractState>();
        for (AbstractState baseState : baseStates) {
            if (this.isCoveredByAny(baseState, coveringStates)) continue;
            notCoveredStates.add(baseState);
        }
        return notCoveredStates;
    }

    private boolean isCoveredByAny(@NonNull AbstractState baseState, @NonNull Collection<AbstractState> coveringStates) throws CPAException, InterruptedException {
        if (coveringStates.contains(baseState)) {
            return true;
        }
        for (AbstractState coveringState : coveringStates) {
            if (!this.bamCpa.getAbstractDomain().isLessOrEqual(baseState, coveringState)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Collection<AbstractState> analyseBlockAndExpand(AbstractState initialState, Precision pPrecision, Block innerSubtree, Block outerSubtree, AbstractState reducedInitialState, Precision reducedInitialPrecision) throws CPAException, InterruptedException {
        CFANode node = AbstractStates.extractLocation(initialState);
        Collection<AbstractState> resultStates = !(node instanceof FunctionEntryNode) || BAMTransferRelationWithFixPointForRecursion.isHeadOfMainFunction(node) ? super.analyseBlockAndExpand(initialState, pPrecision, innerSubtree, outerSubtree, reducedInitialState, reducedInitialPrecision) : this.analyseBlockAndExpandForRecursion(initialState, pPrecision, node, innerSubtree, outerSubtree, reducedInitialState, reducedInitialPrecision);
        if (this.recursionSeen) {
            this.potentialRecursionUpdateStates.add(initialState);
        }
        return resultStates;
    }

    private Collection<AbstractState> analyseBlockAndExpandForRecursion(AbstractState initialState, Precision pPrecision, CFANode node, Block innerSubtree, Block outerSubtree, AbstractState reducedInitialState, Precision reducedInitialPrecision) throws CPAException, InterruptedException {
        Collection<AbstractState> expandedFunctionReturnStates;
        Triple<AbstractState, Precision, Block> coveringLevel = this.getCoveringLevel((Triple)this.stack.peek());
        if (coveringLevel != null) {
            this.logger.logf(Level.FINEST, "recursion will cause endless unrolling (with current precision), aborting call of function '%s' at state %s", new Object[]{node.getFunctionName(), reducedInitialState});
            expandedFunctionReturnStates = this.analyseRecursiveBlockAndExpand(initialState, pPrecision, innerSubtree, outerSubtree, reducedInitialState, coveringLevel);
        } else {
            expandedFunctionReturnStates = super.analyseBlockAndExpand(initialState, pPrecision, innerSubtree, outerSubtree, reducedInitialState, reducedInitialPrecision);
        }
        AbstractState rootState = (AbstractState)Iterables.getOnlyElement(((ARGState)initialState).getParents());
        ArrayList<AbstractState> rebuildStates = new ArrayList<AbstractState>(expandedFunctionReturnStates.size());
        for (AbstractState expandedState : expandedFunctionReturnStates) {
            rebuildStates.add(this.getRebuildState(rootState, initialState, expandedState));
        }
        return rebuildStates;
    }

    private Collection<AbstractState> analyseRecursiveBlockAndExpand(AbstractState initialState, Precision pPrecision, Block innerSubtree, Block pOuterSubtree, AbstractState pReducedInitialState, Triple<AbstractState, Precision, Block> pCoveringLevel) throws CPATransferException, InterruptedException {
        Object reducedResult;
        this.recursionSeen = true;
        BAMCache.BAMCacheEntry entry = this.data.getCache().get(pCoveringLevel.getFirst(), pCoveringLevel.getSecond(), pCoveringLevel.getThird());
        ReachedSet reached = entry.getReachedSet();
        Set<AbstractState> previousResult = entry.getExitStates();
        assert (reached != null) : "cached entry has no reached set";
        if (previousResult == null) {
            reducedResult = ImmutableSet.of();
            this.logger.logf(Level.FINEST, "skipping recursive call with new empty result (root is %s)", new Object[]{reached.getFirstState()});
        } else {
            reducedResult = previousResult;
            this.logger.logf(Level.FINEST, "skipping recursive call with cached result (root is %s)", new Object[]{reached.getFirstState()});
        }
        this.registerInitalAndExitStates(initialState, (Collection<AbstractState>)reducedResult, reached);
        if (this.bamPccManager.isPCCEnabled()) {
            this.bamPccManager.addBlockAnalysisInfo(pReducedInitialState);
        }
        return this.expandResultStates((Collection<AbstractState>)reducedResult, reached, innerSubtree, pOuterSubtree, initialState, pPrecision);
    }

    @Override
    protected Collection<AbstractState> filterResultStatesForFurtherAnalysis(Collection<AbstractState> reducedResult, Collection<AbstractState> cachedReturnStates) throws CPAException, InterruptedException {
        if (cachedReturnStates == null) {
            this.logger.log(Level.FINEST, new Object[]{"there was no cache-entry for result-states."});
            this.resultStatesChanged = true;
        } else {
            Collection<AbstractState> newStates = this.getStatesNotCoveredBy(reducedResult, cachedReturnStates);
            if (newStates.isEmpty()) {
                this.logger.log(Level.FINEST, new Object[]{"all previous return-states are covering the current new states, no new states found."});
            } else {
                this.logger.log(Level.FINEST, new Object[]{"some cached result-states are not covered. returning new result-states."});
                this.resultStatesChanged = true;
            }
        }
        return super.filterResultStatesForFurtherAnalysis(reducedResult, cachedReturnStates);
    }

    private AbstractState getRebuildState(AbstractState rootState, AbstractState entryState, AbstractState expandedState) {
        this.logger.log(Level.ALL, new Object[]{"rebuilding state with root state", rootState});
        this.logger.log(Level.ALL, new Object[]{"rebuilding state with entry state", entryState});
        this.logger.log(Level.ALL, new Object[]{"rebuilding state with expanded state", expandedState});
        CFANode location = AbstractStates.extractLocation(expandedState);
        if (!(location instanceof FunctionExitNode)) {
            this.logger.log(Level.ALL, new Object[]{"rebuilding skipped because of non-function-exit-location"});
            assert (AbstractStates.isTargetState(expandedState)) : "only target states are returned without rebuild";
            return expandedState;
        }
        AbstractState rebuildState = this.wrappedReducer.rebuildStateAfterFunctionCall(rootState, entryState, expandedState, (FunctionExitNode)location);
        this.logger.log(Level.ALL, new Object[]{"rebuilding finished with state", rebuildState});
        assert (((ARGState)expandedState).getChildren().isEmpty() && ((ARGState)expandedState).getParents().size() == 1) : "unexpected expanded state: " + expandedState;
        assert (((ARGState)entryState).getChildren().contains(expandedState)) : "successor of entry state " + entryState + " must be expanded state " + expandedState;
        ((ARGState)expandedState).removeFromARG();
        ((ARGState)rebuildState).addParent((ARGState)entryState);
        this.data.replaceStateInCaches(expandedState, rebuildState, true);
        return rebuildState;
    }
}

