/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam;

import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

class TimedReducer
implements Reducer {
    private final Reducer wrappedReducer;
    private final ThreadSafeTimerContainer.TimerWrapper reduceTimer;
    private final ThreadSafeTimerContainer.TimerWrapper expandTimer;
    private final ThreadSafeTimerContainer.TimerWrapper reducePrecisionTimer;
    private final ThreadSafeTimerContainer.TimerWrapper expandPrecisionTimer;

    public TimedReducer(ReducerStatistics pReducerStatistics, Reducer pWrappedReducer) {
        this.wrappedReducer = pWrappedReducer;
        this.reduceTimer = pReducerStatistics.reduceTime.getNewTimer();
        this.expandTimer = pReducerStatistics.expandTime.getNewTimer();
        this.reducePrecisionTimer = pReducerStatistics.reducePrecisionTime.getNewTimer();
        this.expandPrecisionTimer = pReducerStatistics.expandPrecisionTime.getNewTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pContext, CFANode pCallNode) throws InterruptedException {
        this.reduceTimer.start();
        try {
            AbstractState abstractState = this.wrappedReducer.getVariableReducedState(pExpandedState, pContext, pCallNode);
            return abstractState;
        }
        finally {
            this.reduceTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) throws InterruptedException {
        this.expandTimer.start();
        try {
            AbstractState abstractState = this.wrappedReducer.getVariableExpandedState(pRootState, pReducedContext, pReducedState);
            return abstractState;
        }
        finally {
            this.expandTimer.stop();
        }
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        return this.wrappedReducer.getHashCodeForState(pElementKey, pPrecisionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        this.reducePrecisionTimer.start();
        try {
            Precision precision = this.wrappedReducer.getVariableReducedPrecision(pPrecision, pContext);
            return precision;
        }
        finally {
            this.reducePrecisionTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Precision getVariableExpandedPrecision(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        this.expandPrecisionTimer.start();
        try {
            Precision precision = this.wrappedReducer.getVariableExpandedPrecision(rootPrecision, rootContext, reducedPrecision);
            return precision;
        }
        finally {
            this.expandPrecisionTimer.stop();
        }
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        return this.wrappedReducer.measurePrecisionDifference(pPrecision, pOtherPrecision);
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) throws InterruptedException {
        return this.wrappedReducer.getVariableReducedStateForProofChecking(pExpandedState, pContext, pCallNode);
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) throws InterruptedException {
        return this.wrappedReducer.getVariableExpandedStateForProofChecking(pRootState, pReducedContext, pReducedState);
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState rootState, AbstractState entryState, AbstractState expandedState, FunctionExitNode exitLocation) {
        return this.wrappedReducer.rebuildStateAfterFunctionCall(rootState, entryState, expandedState, exitLocation);
    }

    @Override
    public boolean canBeUsedInCache(AbstractState pState) {
        return this.wrappedReducer.canBeUsedInCache(pState);
    }

    static class ReducerStatistics {
        final ThreadSafeTimerContainer reduceTime = new ThreadSafeTimerContainer("Time for reducing abstract states");
        final ThreadSafeTimerContainer expandTime = new ThreadSafeTimerContainer("Time for expanding abstract states");
        final ThreadSafeTimerContainer reducePrecisionTime = new ThreadSafeTimerContainer("Time for reducing precisions");
        final ThreadSafeTimerContainer expandPrecisionTime = new ThreadSafeTimerContainer("Time for expanding precisions");

        ReducerStatistics() {
        }
    }
}

