/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;

public interface BAMCache
extends Statistics {
    public BAMCacheEntry put(AbstractState var1, Precision var2, Block var3, ReachedSet var4);

    public BAMCacheEntry get(AbstractState var1, Precision var2, Block var3);

    @Deprecated
    public ARGState getLastAnalyzedBlock();

    public boolean containsPreciseKey(AbstractState var1, Precision var2, Block var3);

    public Collection<ReachedSet> getAllCachedReachedStates();

    public void clear();

    public static class BAMCacheEntry {
        private final ReachedSet rs;
        private Set<AbstractState> exitStates;
        private ARGState rootOfBlock;

        protected BAMCacheEntry(ReachedSet pRs) {
            this.rs = (ReachedSet)Preconditions.checkNotNull((Object)pRs);
        }

        public ReachedSet getReachedSet() {
            return this.rs;
        }

        public void setExitStates(Set<AbstractState> pExitStates) {
            this.exitStates = (Set)Preconditions.checkNotNull(pExitStates);
            this.check();
        }

        public @Nullable Set<AbstractState> getExitStates() {
            return this.exitStates;
        }

        private void check() {
            Preconditions.checkArgument((boolean)Iterables.all(this.exitStates, s -> !((ARGState)s).isDestroyed()), (String)"do not use destroyed states: %s.", (Object)Collections2.transform(this.exitStates, this::id));
            Preconditions.checkArgument((boolean)this.rs.asCollection().containsAll(this.exitStates), (String)"exit-states %s not available in reached-set with root %s and last state %s.", (Object)Collections2.transform(this.exitStates, this::id), (Object)this.id(this.rs.getFirstState()), (Object)this.id(this.rs.getLastState()));
        }

        public void setRootOfBlock(ARGState pRootOfBlock) {
            this.rootOfBlock = pRootOfBlock;
        }

        public @Nullable ARGState getRootOfBlock() {
            return this.rootOfBlock;
        }

        public void deleteInfo() {
            this.exitStates = null;
            this.rootOfBlock = null;
        }

        private String id(AbstractState s) {
            return "" + (s instanceof ARGState ? Integer.valueOf(((ARGState)s).getStateId()) : s);
        }

        public String toString() {
            return String.format("CacheEntry {root=%s, exits=%s}", this.id(this.rs.getFirstState()), this.exitStates == null ? null : Collections2.transform(this.exitStates, this::id));
        }
    }
}

