/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCacheImpl;

public class BAMCacheAggressiveImpl
extends BAMCacheImpl {
    private final Map<BAMCacheImpl.AbstractStateHash, BAMCache.BAMCacheEntry> impreciseReachedCache = new LinkedHashMap<BAMCacheImpl.AbstractStateHash, BAMCache.BAMCacheEntry>();

    public BAMCacheAggressiveImpl(Configuration config, Reducer reducer, LogManager logger) throws InvalidConfigurationException {
        super(config, reducer, logger);
    }

    @Override
    protected @Nullable BAMCache.BAMCacheEntry getIfNotExistant(AbstractState stateKey, Precision precisionKey, Block context, BAMCacheImpl.AbstractStateHash hash) {
        BAMCache.BAMCacheEntry result = this.impreciseReachedCache.get(hash);
        if (result != null) {
            this.lastAnalyzedEntry = result;
            this.logger.log(Level.FINEST, new Object[]{"CACHE_ACCESS: imprecise entry, directly from cache"});
            return result;
        }
        result = this.lookForSimilarState(stateKey, precisionKey, context);
        if (result != null) {
            this.impreciseReachedCache.put(hash, result);
            this.lastAnalyzedEntry = result;
            this.logger.log(Level.FINEST, new Object[]{"CACHE_ACCESS: imprecise entry, searched in cache"});
            return result;
        }
        return super.getIfNotExistant(stateKey, precisionKey, context, hash);
    }

    private BAMCache.BAMCacheEntry lookForSimilarState(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
        int min = Integer.MAX_VALUE;
        BAMCache.BAMCacheEntry result = null;
        for (BAMCacheImpl.AbstractStateHash cacheKey : this.preciseReachedCache.keySet()) {
            int distance;
            BAMCacheImpl.AbstractStateHash ignorePrecisionSearchKey = this.getHashCode(pStateKey, cacheKey.precisionKey, pContext);
            if (!ignorePrecisionSearchKey.equals(cacheKey) || (distance = this.reducer.measurePrecisionDifference(pPrecisionKey, cacheKey.precisionKey)) >= min) continue;
            min = distance;
            result = (BAMCache.BAMCacheEntry)this.preciseReachedCache.get(ignorePrecisionSearchKey);
        }
        return result;
    }
}

