/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.util.statistics.StatHist;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options(prefix="cpa.bam")
public class BAMCacheImpl
implements BAMCache {
    @Option(secure=true, description="If enabled, the reached set cache is analysed for each cache miss to find the cause of the miss.")
    private boolean gatherCacheMissStatistics = false;
    private final Timer hashingTimer = new Timer();
    private final Timer equalsTimer = new Timer();
    private int cacheMisses = 0;
    private int partialCacheHits = 0;
    private int fullCacheHits = 0;
    private int abstractionCausedMisses = 0;
    private int precisionCausedMisses = 0;
    private int noSimilarCausedMisses = 0;
    protected final Map<AbstractStateHash, BAMCache.BAMCacheEntry> preciseReachedCache = new LinkedHashMap<AbstractStateHash, BAMCache.BAMCacheEntry>();
    protected BAMCache.BAMCacheEntry lastAnalyzedEntry = null;
    protected final Reducer reducer;
    protected final LogManager logger;

    public BAMCacheImpl(Configuration config, Reducer reducer, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this, BAMCacheImpl.class);
        this.reducer = reducer;
        this.logger = logger;
    }

    protected AbstractStateHash getHashCode(AbstractState stateKey, Precision precisionKey, Block context) {
        return new AbstractStateHash(stateKey, precisionKey, context);
    }

    @Override
    public BAMCache.BAMCacheEntry put(AbstractState stateKey, Precision precisionKey, Block context, ReachedSet rs) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        BAMCache.BAMCacheEntry entry = new BAMCache.BAMCacheEntry(rs);
        this.preciseReachedCache.put(hash, entry);
        return entry;
    }

    protected static boolean allStatesContainedInReachedSet(Collection<AbstractState> pElements, ReachedSet reached) {
        return reached.asCollection().containsAll(pElements);
    }

    @Override
    public BAMCache.BAMCacheEntry get(AbstractState stateKey, Precision precisionKey, Block context) {
        BAMCache.BAMCacheEntry entry = this.get0(stateKey, precisionKey, context);
        if (entry == null) {
            ++this.cacheMisses;
            if (this.gatherCacheMissStatistics) {
                this.findCacheMissCause(stateKey, precisionKey, context);
            }
        } else if (entry.getExitStates() == null) {
            ++this.partialCacheHits;
        } else {
            ++this.fullCacheHits;
        }
        return entry;
    }

    private BAMCache.BAMCacheEntry get0(AbstractState stateKey, Precision precisionKey, Block context) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        BAMCache.BAMCacheEntry result = this.preciseReachedCache.get(hash);
        if (result != null) {
            this.lastAnalyzedEntry = result;
            this.logger.log(Level.FINEST, new Object[]{"CACHE_ACCESS: precise entry"});
            return result;
        }
        return this.getIfNotExistant(stateKey, precisionKey, context, hash);
    }

    protected BAMCache.BAMCacheEntry getIfNotExistant(AbstractState stateKey, Precision precisionKey, Block context, AbstractStateHash hash) {
        this.lastAnalyzedEntry = null;
        this.logger.log(Level.FINEST, new Object[]{"CACHE_ACCESS: entry not available"});
        return null;
    }

    @Override
    @Deprecated
    public ARGState getLastAnalyzedBlock() {
        return this.lastAnalyzedEntry.getRootOfBlock();
    }

    private void findCacheMissCause(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
        AbstractStateHash searchKey = this.getHashCode(pStateKey, pPrecisionKey, pContext);
        for (AbstractStateHash cacheKey : this.preciseReachedCache.keySet()) {
            assert (!searchKey.equals(cacheKey));
            AbstractStateHash ignorePrecisionSearchKey = this.getHashCode(pStateKey, cacheKey.precisionKey, pContext);
            if (ignorePrecisionSearchKey.equals(cacheKey)) {
                ++this.precisionCausedMisses;
                return;
            }
            AbstractStateHash ignoreAbsSearchKey = this.getHashCode(cacheKey.stateKey, pPrecisionKey, pContext);
            if (!ignoreAbsSearchKey.equals(cacheKey)) continue;
            ++this.abstractionCausedMisses;
            return;
        }
        ++this.noSimilarCausedMisses;
    }

    @Override
    public boolean containsPreciseKey(AbstractState stateKey, Precision precisionKey, Block context) {
        AbstractStateHash hash = this.getHashCode(stateKey, precisionKey, context);
        return this.preciseReachedCache.containsKey(hash);
    }

    @Override
    public Collection<ReachedSet> getAllCachedReachedStates() {
        return Collections2.transform(this.preciseReachedCache.values(), BAMCache.BAMCacheEntry::getReachedSet);
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        int sumCalls = this.cacheMisses + this.partialCacheHits + this.fullCacheHits;
        StatHist argStats = new StatHist(""){

            @Override
            public String toString() {
                return String.format("%.0f (#=%d, avg=%.2f, dev=%.2f, min=%d, max=%d)", this.getSum(), this.getUpdateCount(), this.getAvg(), this.getStdDeviation(), this.getMin(), this.getMax());
            }
        };
        for (UnmodifiableReachedSet unmodifiableReachedSet : this.getAllCachedReachedStates()) {
            argStats.insertValue(unmodifiableReachedSet.size());
        }
        out.println("Total size of all ARGs:                              " + argStats);
        out.println("Total number of recursive CPA calls:                 " + sumCalls);
        out.println("  Number of cache misses:                            " + this.cacheMisses + " (" + StatisticsUtils.toPercent(this.cacheMisses, sumCalls) + " of all calls)");
        out.println("  Number of partial cache hits:                      " + this.partialCacheHits + " (" + StatisticsUtils.toPercent(this.partialCacheHits, sumCalls) + " of all calls)");
        out.println("  Number of full cache hits:                         " + this.fullCacheHits + " (" + StatisticsUtils.toPercent(this.fullCacheHits, sumCalls) + " of all calls)");
        if (this.gatherCacheMissStatistics) {
            out.println("Cause for cache misses:                              ");
            out.println("  Number of abstraction caused misses:               " + this.abstractionCausedMisses + " (" + StatisticsUtils.toPercent(this.abstractionCausedMisses, this.cacheMisses) + " of all misses)");
            out.println("  Number of precision caused misses:                 " + this.precisionCausedMisses + " (" + StatisticsUtils.toPercent(this.precisionCausedMisses, this.cacheMisses) + " of all misses)");
            out.println("  Number of misses with no similar elements:         " + this.noSimilarCausedMisses + " (" + StatisticsUtils.toPercent(this.noSimilarCausedMisses, this.cacheMisses) + " of all misses)");
        }
        out.println("Time for checking equality of abstract states:       " + this.equalsTimer + " (Calls: " + this.equalsTimer.getNumberOfIntervals() + ")");
        out.println("Time for computing the hashCode of abstract states:  " + this.hashingTimer + " (Calls: " + this.hashingTimer.getNumberOfIntervals() + ")");
    }

    @Override
    public String getName() {
        return "BAMCache";
    }

    @Override
    public void clear() {
        this.preciseReachedCache.clear();
        this.lastAnalyzedEntry = null;
    }

    class AbstractStateHash {
        private final Object wrappedHash;
        private final Block context;
        final AbstractState stateKey;
        final Precision precisionKey;

        public AbstractStateHash(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
            this.wrappedHash = BAMCacheImpl.this.reducer.getHashCodeForState(pStateKey, pPrecisionKey);
            this.context = (Block)Preconditions.checkNotNull((Object)pContext);
            this.stateKey = pStateKey;
            this.precisionKey = pPrecisionKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object pObj) {
            if (!(pObj instanceof AbstractStateHash)) {
                return false;
            }
            if (pObj == this) {
                return true;
            }
            AbstractStateHash other = (AbstractStateHash)pObj;
            BAMCacheImpl.this.equalsTimer.start();
            try {
                boolean bl = this.context.equals(other.context) && this.wrappedHash.equals(other.wrappedHash);
                return bl;
            }
            finally {
                BAMCacheImpl.this.equalsTimer.stop();
            }
        }

        public int hashCode() {
            BAMCacheImpl.this.hashingTimer.start();
            try {
                int n = this.wrappedHash.hashCode() * 17 + this.context.hashCode();
                return n;
            }
            finally {
                BAMCacheImpl.this.hashingTimer.stop();
            }
        }

        public String toString() {
            return "AbstractStateHash [hash=" + this.hashCode() + ", wrappedHash=" + this.wrappedHash + ", context=" + this.context + ", predicateKey=" + this.stateKey + ", precisionKey=" + this.precisionKey + "]";
        }
    }
}

