/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam.cache;

import java.io.PrintStream;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCacheImpl;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;

public class BAMCacheSynchronized
implements BAMCache {
    private final BAMCache cache;
    private final StatTimer timer = new StatTimer("Time for cache-access");

    public BAMCacheSynchronized(Configuration pConfig, Reducer pReducer, LogManager pLogger) throws InvalidConfigurationException {
        this.cache = new BAMCacheImpl(pConfig, pReducer, pLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            this.cache.printStatistics(pOut, pResult, pReached);
            pOut.println(this.timer.getTitle() + ":                           " + this.timer + " (count=" + this.timer.getUpdateCount() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            this.cache.writeOutputFiles(pResult, pReached);
        }
    }

    @Override
    public @Nullable String getName() {
        return this.cache.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BAMCache.BAMCacheEntry put(AbstractState pStateKey, Precision pPrecisionKey, Block pContext, ReachedSet pItem) {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            BAMCache.BAMCacheEntry bAMCacheEntry;
            this.timer.start();
            try {
                bAMCacheEntry = this.cache.put(pStateKey, pPrecisionKey, pContext, pItem);
                this.timer.stop();
            }
            catch (Throwable throwable) {
                this.timer.stop();
                throw throwable;
            }
            return bAMCacheEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BAMCache.BAMCacheEntry get(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            BAMCache.BAMCacheEntry bAMCacheEntry;
            try {
                this.timer.start();
                bAMCacheEntry = this.cache.get(pStateKey, pPrecisionKey, pContext);
                this.timer.stop();
            }
            catch (Throwable throwable) {
                this.timer.stop();
                throw throwable;
            }
            return bAMCacheEntry;
        }
    }

    @Override
    @Deprecated
    public ARGState getLastAnalyzedBlock() {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            ARGState aRGState;
            try {
                this.timer.start();
                aRGState = this.cache.getLastAnalyzedBlock();
                this.timer.stop();
            }
            catch (Throwable throwable) {
                this.timer.stop();
                throw throwable;
            }
            return aRGState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsPreciseKey(AbstractState pStateKey, Precision pPrecisionKey, Block pContext) {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            boolean bl;
            try {
                this.timer.start();
                bl = this.cache.containsPreciseKey(pStateKey, pPrecisionKey, pContext);
                this.timer.stop();
            }
            catch (Throwable throwable) {
                this.timer.stop();
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ReachedSet> getAllCachedReachedStates() {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            return this.cache.getAllCachedReachedStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        BAMCacheSynchronized bAMCacheSynchronized = this;
        synchronized (bAMCacheSynchronized) {
            this.cache.clear();
        }
    }
}

