/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bam.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.AbstractBAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;

public class BAMDataManagerImpl
implements BAMDataManager {
    private final LogManager logger;
    private final BAMCache bamCache;
    private final AbstractBAMCPA bamCpa;
    private final ReachedSetFactory reachedSetFactory;
    private final Table<AbstractState, AbstractState, ReachedSet> initialStateToReachedSet = HashBasedTable.create();
    private final Multimap<AbstractState, AbstractState> reducedToNonReduced = LinkedHashMultimap.create();
    private final Map<AbstractState, BlockExitData> expandedStateToBlockExit = new LinkedHashMap<AbstractState, BlockExitData>();
    private final Set<CFANode> uncachedBlockEntries = new HashSet<CFANode>();

    public BAMDataManagerImpl(AbstractBAMCPA pBamCpa, BAMCache pArgCache, ReachedSetFactory pReachedSetFactory, LogManager pLogger) {
        this.bamCpa = pBamCpa;
        this.bamCache = pArgCache;
        this.reachedSetFactory = pReachedSetFactory;
        this.logger = pLogger;
    }

    @Override
    public void replaceStateInCaches(AbstractState oldState, AbstractState newState, boolean oldStateMustExist) {
        if (oldState.equals(newState)) {
            return;
        }
        if (oldStateMustExist || this.expandedStateToBlockExit.containsKey(oldState)) {
            BlockExitData entry = this.expandedStateToBlockExit.remove(oldState);
            this.expandedStateToBlockExit.put(newState, entry);
        }
    }

    @Override
    public BAMCache.BAMCacheEntry createAndRegisterNewReachedSet(AbstractState initialState, Precision initialPrecision, Block context) {
        ReachedSet reached = this.reachedSetFactory.create(this.bamCpa);
        reached.add(initialState, initialPrecision);
        return this.bamCache.put(initialState, initialPrecision, context, reached);
    }

    @Override
    public ReachedSetFactory getReachedSetFactory() {
        return this.reachedSetFactory;
    }

    @Override
    public void registerExpandedState(AbstractState expandedState, Precision expandedPrecision, AbstractState reducedState, Block innerBlock) {
        BlockExitData previousValue = this.expandedStateToBlockExit.put(expandedState, new BlockExitData(reducedState, innerBlock, expandedPrecision));
        assert (previousValue == null) : "expanded state was registered before with data " + previousValue;
    }

    @Override
    public boolean alreadyReturnedFromSameBlock(AbstractState state, Block block) {
        BlockExitData data = this.expandedStateToBlockExit.get(state);
        while (data != null) {
            if (block == data.block) {
                return true;
            }
            data = this.expandedStateToBlockExit.get(data.reducedState);
        }
        return false;
    }

    @Override
    public AbstractState getInnermostState(AbstractState state) {
        BlockExitData data = this.expandedStateToBlockExit.get(state);
        while (data != null) {
            state = data.reducedState;
            data = this.expandedStateToBlockExit.get(state);
        }
        return state;
    }

    @Override
    public List<AbstractState> getExpandedStatesList(AbstractState state) {
        BlockExitData data;
        ArrayList<AbstractState> lst = new ArrayList<AbstractState>();
        while ((data = this.expandedStateToBlockExit.get(state)) != null) {
            lst.add(state);
            state = data.reducedState;
        }
        return Lists.reverse(lst);
    }

    @Override
    public void registerInitialState(AbstractState initialState, AbstractState exitState, ReachedSet reachedSet) {
        ReachedSet oldReachedSet = (ReachedSet)this.initialStateToReachedSet.get((Object)initialState, (Object)exitState);
        if (oldReachedSet != null && oldReachedSet != reachedSet) {
            this.logger.logf(Level.ALL, "New root state %s with exit state %s overrides old reachedset %s with new reachedset %s.", new Object[]{initialState, exitState, oldReachedSet.getFirstState(), reachedSet.getFirstState()});
        }
        this.initialStateToReachedSet.put((Object)initialState, (Object)exitState, (Object)reachedSet);
        this.reducedToNonReduced.put((Object)reachedSet.getFirstState(), (Object)initialState);
    }

    @Override
    public ReachedSet getReachedSetForInitialState(AbstractState initialState, AbstractState exitState) {
        assert (this.initialStateToReachedSet.contains((Object)initialState, (Object)exitState)) : "no block matching states: " + initialState + " -> " + exitState;
        ReachedSet reached = (ReachedSet)Preconditions.checkNotNull((Object)((ReachedSet)this.initialStateToReachedSet.get((Object)initialState, (Object)exitState)));
        assert (reached.contains(exitState)) : "reachedset should contain exit state for block: " + exitState;
        return reached;
    }

    @Override
    public boolean hasInitialState(AbstractState state) {
        return this.initialStateToReachedSet.containsRow((Object)state);
    }

    @Override
    public ImmutableSet<AbstractState> getNonReducedInitialStates(AbstractState pReducedState) {
        return ImmutableSet.copyOf((Collection)this.reducedToNonReduced.get((Object)pReducedState));
    }

    @Override
    public AbstractState getReducedStateForExpandedState(AbstractState state) {
        assert (this.hasExpandedState(state)) : "no match for state: " + state;
        return this.expandedStateToBlockExit.get((Object)state).reducedState;
    }

    @Override
    public Block getInnerBlockForExpandedState(AbstractState state) {
        assert (this.hasExpandedState(state)) : "no match for state: " + state;
        return this.expandedStateToBlockExit.get((Object)state).block;
    }

    @Override
    public boolean hasExpandedState(AbstractState state) {
        return this.expandedStateToBlockExit.containsKey(state);
    }

    private static int getId(AbstractState state) {
        return ((ARGState)state).getStateId();
    }

    @Override
    public BAMCache getCache() {
        return this.bamCache;
    }

    @Override
    public @Nullable Precision getExpandedPrecisionForState(AbstractState pState) {
        BlockExitData data = this.expandedStateToBlockExit.get(pState);
        return data == null ? null : data.expandedPrecision;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("BAM DATA MANAGER\n");
        str.append("initial state to (first state of) reached set:\n");
        for (Table.Cell cell : this.initialStateToReachedSet.cellSet()) {
            str.append(String.format("    (%s, %s) -> %s%n", BAMDataManagerImpl.getId((AbstractState)Preconditions.checkNotNull((Object)((AbstractState)cell.getRowKey()))), BAMDataManagerImpl.getId((AbstractState)Preconditions.checkNotNull((Object)((AbstractState)cell.getColumnKey()))), BAMDataManagerImpl.getId(((ReachedSet)Preconditions.checkNotNull((Object)((ReachedSet)cell.getValue()))).getFirstState())));
        }
        str.append("expanded state to reduced state:\n");
        for (Map.Entry entry : BAMDataManagerImpl.sorted(this.expandedStateToBlockExit)) {
            str.append(String.format("    %s -> %s%n", BAMDataManagerImpl.getId((AbstractState)entry.getKey()), BAMDataManagerImpl.getId(((BlockExitData)entry.getValue()).reducedState)));
        }
        return str.toString();
    }

    private static <T> List<Map.Entry<AbstractState, T>> sorted(Map<AbstractState, T> map) {
        return ImmutableList.sortedCopyOf(Comparator.comparingInt(entry -> BAMDataManagerImpl.getId((AbstractState)entry.getKey())), map.entrySet());
    }

    @Override
    public void clear() {
        this.initialStateToReachedSet.clear();
        this.expandedStateToBlockExit.clear();
        this.bamCache.clear();
        this.reducedToNonReduced.clear();
    }

    @Override
    public boolean addUncachedBlockEntry(CFANode pNode) {
        return this.uncachedBlockEntries.add(pNode);
    }

    @Override
    public boolean isUncachedBlockEntry(CFANode pNode) {
        return this.uncachedBlockEntries.contains(pNode);
    }

    private static class BlockExitData {
        private final AbstractState reducedState;
        private final Block block;
        private final Precision expandedPrecision;

        BlockExitData(AbstractState pReducedState, Block pBlock, Precision pExpandedPrecision) {
            this.reducedState = pReducedState;
            this.block = pBlock;
            this.expandedPrecision = pExpandedPrecision;
        }

        public String toString() {
            return String.format("Data <%s, %s, %s>", this.reducedState, this.block, this.expandedPrecision);
        }
    }
}

