/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.bdd.BDDReducer;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.cpa.bdd.BDDStatistics;
import org.sosy_lab.cpachecker.cpa.bdd.BDDTransferRelation;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorComputer;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;

@Options(prefix="cpa.bdd")
public class BDDCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider {
    private final NamedRegionManager manager;
    private final BitvectorManager bvmgr;
    private final PredicateManager predmgr;
    private VariableTrackingPrecision precision;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final LogManager logger;
    private final CFA cfa;
    private final BDDStatistics stats;
    private final BitvectorComputer bvComputer;
    @Option(secure=true, description="mergeType", values={"sep", "join"})
    private String merge = "join";
    @Option(secure=true, description="max bitsize for values and vars, initial value")
    private int bitsize = 64;
    @Option(secure=true, description="use a smaller bitsize for all vars, that have only intEqual values")
    private boolean compressIntEqual = true;
    @Option(secure=true, description="reduce and expand BDD states for BAM, otherwise use plain identity")
    private boolean useBlockAbstraction = false;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(BDDCPA.class);
    }

    private BDDCPA(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdownNotifier = pShutdownNotifier;
        RegionManager rmgr = new BDDManagerFactory(this.config, this.logger).createRegionManager();
        this.precision = VariableTrackingPrecision.createStaticPrecision(this.config, this.cfa.getVarClassification(), this.getClass());
        this.manager = new NamedRegionManager(rmgr);
        this.bvmgr = new BitvectorManager(rmgr);
        this.predmgr = new PredicateManager(this.config, this.manager, this.cfa);
        this.bvComputer = new BitvectorComputer(this.compressIntEqual, this.cfa.getVarClassification().orElseThrow(), this.bvmgr, this.manager, this.predmgr, this.cfa.getMachineModel());
        this.stats = new BDDStatistics(this.config, this.cfa, this.logger, this.manager, this.predmgr);
    }

    public void injectRefinablePrecision() throws InvalidConfigurationException {
        this.precision = VariableTrackingPrecision.createRefineablePrecision(this.config, this.precision);
    }

    public NamedRegionManager getManager() {
        return this.manager;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return DelegateAbstractDomain.getInstance();
    }

    @Override
    public MergeOperator getMergeOperator() {
        switch (this.merge) {
            case "sep": {
                return MergeSepOperator.getInstance();
            }
            case "join": {
                return new MergeJoinOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)("unexpected operator: " + this.merge));
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new BDDTransferRelation(this.manager, this.bvmgr, this.predmgr, this.cfa, this.bitsize, this.bvComputer);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new BDDState(this.manager, this.bvmgr, this.manager.makeTrue());
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }

    @Override
    public Reducer getReducer() {
        return new BDDReducer(this.manager, this.bvmgr, this.predmgr, this.cfa.getMachineModel(), this.cfa.getVarClassification().orElseThrow(), this.shutdownNotifier, this.logger, this.useBlockAbstraction, this.bvComputer);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }
}

