/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassificationBuilder;

public class BDDCompressExpressionVisitor
extends DefaultCExpressionVisitor<Region[], NoException> {
    private static final Map<Partition, ImmutableMap<BigInteger, Region[]>> INT_REGIONS_MAP = new HashMap<Partition, ImmutableMap<BigInteger, Region[]>>();
    protected final PredicateManager predMgr;
    protected final VariableTrackingPrecision precision;
    private final BitvectorManager bvmgr;
    private final ImmutableMap<BigInteger, Region[]> intToRegions;
    protected final int size;
    protected final CFANode location;

    public BDDCompressExpressionVisitor(PredicateManager pPredMgr, VariableTrackingPrecision pPrecision, int size, CFANode pLocation, BitvectorManager pBVmgr, Partition pPartition) {
        Preconditions.checkNotNull((Object)pPartition);
        this.predMgr = pPredMgr;
        this.precision = pPrecision;
        this.bvmgr = pBVmgr;
        this.size = size;
        this.intToRegions = this.initMappingIntToRegions(pPartition);
        this.location = pLocation;
    }

    private ImmutableMap<BigInteger, Region[]> initMappingIntToRegions(Partition partition) {
        if (!INT_REGIONS_MAP.containsKey(partition)) {
            ImmutableMap.Builder currentMapping = ImmutableMap.builder();
            currentMapping.put((Object)BigInteger.ZERO, (Object)this.bvmgr.makeNumber(BigInteger.valueOf(0L), this.size));
            currentMapping.put((Object)BigInteger.ONE, (Object)this.bvmgr.makeNumber(BigInteger.valueOf(1L), this.size));
            int i = 2;
            for (BigInteger num : Sets.difference(partition.getValues(), (Set)Sets.newHashSet((Object[])new BigInteger[]{BigInteger.ZERO, BigInteger.ONE}))) {
                currentMapping.put((Object)num, (Object)this.bvmgr.makeNumber(BigInteger.valueOf(i), this.size));
                ++i;
            }
            INT_REGIONS_MAP.put(partition, (ImmutableMap<BigInteger, Region[]>)currentMapping.buildOrThrow());
        }
        return INT_REGIONS_MAP.get(partition);
    }

    @Override
    protected Region[] visitDefault(CExpression pExp) {
        return null;
    }

    @Override
    public Region[] visit(CBinaryExpression pE) {
        Region[] rVal;
        Region[] lVal;
        BigInteger val1 = VariableClassificationBuilder.getNumber(pE.getOperand1());
        if (val1 == null) {
            lVal = pE.getOperand1().accept(this);
        } else {
            lVal = (Region[])this.intToRegions.get((Object)val1);
            assert (lVal != null);
        }
        BigInteger val2 = VariableClassificationBuilder.getNumber(pE.getOperand2());
        if (val2 == null) {
            rVal = pE.getOperand2().accept(this);
        } else {
            rVal = (Region[])this.intToRegions.get((Object)val2);
            assert (rVal != null);
        }
        if (lVal == null || rVal == null) {
            return null;
        }
        return BDDCompressExpressionVisitor.calculateBinaryOperation(lVal, rVal, this.bvmgr, pE);
    }

    private static Region[] calculateBinaryOperation(Region[] lVal, Region[] rVal, BitvectorManager bvmgr, CBinaryExpression binaryExpr) {
        assert (lVal.length == rVal.length);
        CBinaryExpression.BinaryOperator binaryOperator = binaryExpr.getOperator();
        switch (binaryOperator) {
            case EQUALS: {
                return bvmgr.wrapLast(bvmgr.makeLogicalEqual(lVal, rVal), lVal.length);
            }
            case NOT_EQUALS: {
                return bvmgr.wrapLast(bvmgr.makeNot(bvmgr.makeLogicalEqual(lVal, rVal)), lVal.length);
            }
        }
        throw new AssertionError((Object)("no support for further operators: " + binaryOperator));
    }

    @Override
    public Region[] visit(CCharLiteralExpression pE) {
        return (Region[])this.intToRegions.get((Object)BigInteger.valueOf(pE.getCharacter()));
    }

    @Override
    public Region[] visit(CIntegerLiteralExpression pE) {
        return (Region[])this.intToRegions.get((Object)pE.getValue());
    }

    @Override
    public Region[] visit(CIdExpression idExp) {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            if (enumerator.hasValue()) {
                return (Region[])this.intToRegions.get((Object)BigInteger.valueOf(enumerator.getValue()));
            }
            return null;
        }
        return this.predMgr.createPredicate(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.location, this.size, this.precision);
    }

    @Override
    public Region[] visit(CCastExpression castExpression) {
        return castExpression.getOperand().accept(this);
    }
}

