/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDBooleanExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDTransferRelation;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class BDDPointerBooleanExpressionVisitor
extends BDDBooleanExpressionVisitor {
    private final PointerState pointerInfo;

    protected BDDPointerBooleanExpressionVisitor(PredicateManager pPredMgr, RegionManager pRmgr, VariableTrackingPrecision pPrecision, CFANode pLocation, PointerState pPointerInfo) {
        super(pPredMgr, pRmgr, pPrecision, pLocation);
        this.pointerInfo = pPointerInfo;
    }

    @Override
    public Region visit(CPointerExpression e) {
        ExplicitLocationSet explicitSet = null;
        try {
            explicitSet = BDDTransferRelation.getLocationsForLhs(this.pointerInfo, e);
        }
        catch (UnrecognizedCodeException exception) {
            throw new AssertionError((Object)exception);
        }
        if (explicitSet != null && explicitSet.getSize() == 1) {
            MemoryLocation memLoc = (MemoryLocation)Iterables.getOnlyElement((Iterable)explicitSet);
            Region[] result = this.predMgr.createPredicate(memLoc.getExtendedQualifiedName(), e.getExpressionType(), this.location, 1, this.precision);
            if (result == null) {
                return null;
            }
            assert (result.length == 1);
            return result[0];
        }
        return this.visitDefault(e);
    }
}

