/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.GenericReducer;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorComputer;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

class BDDReducer
extends GenericReducer<BDDState, Precision> {
    private final NamedRegionManager manager;
    private final BitvectorManager bvmgr;
    private final PredicateManager predmgr;
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logger;
    private final int maxBitsize;
    private final boolean useBlockAbstraction;
    private final BitvectorComputer bvComputer;
    private final VariableClassification varClassification;
    private final Map<String, Integer> variableSizes = new HashMap<String, Integer>();
    private static final int INPUT_VARIABLE_INDEX = 0;
    private static final int APPLY_VARIABLE_INDEX = 1;

    BDDReducer(NamedRegionManager pManager, BitvectorManager pBvmgr, PredicateManager pPredmgr, MachineModel pMachineModel, VariableClassification pVarClassification, ShutdownNotifier pShutdownNotifier, LogManager pLogger, boolean pUseBlockAbstraction, BitvectorComputer pBvComputer) {
        this.manager = pManager;
        this.bvmgr = pBvmgr;
        this.predmgr = pPredmgr;
        this.maxBitsize = PredicateManager.getMaxBitsize(pMachineModel);
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
        this.useBlockAbstraction = pUseBlockAbstraction;
        this.bvComputer = pBvComputer;
        this.varClassification = pVarClassification;
        if (this.useBlockAbstraction) {
            Preconditions.checkState((this.predmgr.getNumberOfAdditionalVariables() >= 2 ? 1 : 0) != 0, (Object)"Make sure to have at least two additional variable declared in the BDD, before calling this method, otherwise the overhead is quite large! The option for this is 'cpa.bdd.initAdditionalVariables=2'.");
        }
    }

    private int getBitsizeForVariable(String variable) {
        Integer bitsize = this.variableSizes.get(variable);
        if (bitsize == null) {
            for (Partition partition : this.varClassification.getPartitions()) {
                if (!partition.getVars().contains(variable)) continue;
                bitsize = this.bvComputer.getBitsize(partition, null);
                break;
            }
            if (bitsize == null || bitsize == 0) {
                bitsize = this.maxBitsize;
            }
            this.variableSizes.put(variable, bitsize);
        }
        return bitsize;
    }

    @Override
    protected BDDState getVariableReducedState0(BDDState pExpandedState, Block pContext, CFANode pCallNode) throws InterruptedException {
        if (!this.useBlockAbstraction) {
            return pExpandedState;
        }
        BDDState state = new BDDState(this.manager, this.bvmgr, this.manager.makeTrue());
        for (String variable : this.filterBlockVariables(pContext.getVariables())) {
            this.shutdownNotifier.shutdownIfNecessary();
            int bitsize = this.getBitsizeForVariable(variable);
            String inputVar = this.predmgr.getAdditionalVariableWithIndex(variable, 0);
            Region[] oldVariable = this.predmgr.createPredicateWithoutPrecisionCheck(variable, bitsize);
            Region[] newVariable = this.predmgr.createPredicateWithoutPrecisionCheck(inputVar, bitsize);
            state = state.addAssignment(oldVariable, newVariable);
        }
        return state;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BDDState getVariableExpandedState0(BDDState pRootState, Block pReducedContext, BDDState pReducedState) throws InterruptedException {
        BDDState appliedBlock;
        void var7_10;
        if (!this.useBlockAbstraction) {
            return pReducedState;
        }
        Collection<String> blockVariables = this.filterBlockVariables(pReducedContext.getVariables());
        BDDState initState = pRootState;
        for (String string : blockVariables) {
            this.shutdownNotifier.shutdownIfNecessary();
            int bitsize = this.getBitsizeForVariable(string);
            String applyVariable = this.predmgr.getAdditionalVariableWithIndex(string, 1);
            initState = this.replace(initState, string, applyVariable, bitsize);
        }
        BDDState cleanedInitState = initState;
        for (String outOfScope : Iterables.filter(pReducedContext.getOutOfScopeVariables(), v -> !blockVariables.contains(v))) {
            this.shutdownNotifier.shutdownIfNecessary();
            int bitsize = this.getBitsizeForVariable(outOfScope);
            Region[] toRemove = this.predmgr.createPredicateWithoutPrecisionCheck(outOfScope, bitsize);
            cleanedInitState = cleanedInitState.forget(toRemove);
        }
        BDDState bDDState = pReducedState;
        for (String variable : blockVariables) {
            this.shutdownNotifier.shutdownIfNecessary();
            int bitsize = this.getBitsizeForVariable(variable);
            String inputVariable = this.predmgr.getAdditionalVariableWithIndex(variable, 0);
            String applyVariable = this.predmgr.getAdditionalVariableWithIndex(variable, 1);
            BDDState bDDState2 = this.replace((BDDState)var7_10, inputVariable, applyVariable, bitsize);
        }
        BDDState expandedState = appliedBlock = cleanedInitState.addConstraint(var7_10.getRegion());
        for (String variable : blockVariables) {
            this.shutdownNotifier.shutdownIfNecessary();
            int bitsize = this.getBitsizeForVariable(variable);
            String applyVariable = this.predmgr.getAdditionalVariableWithIndex(variable, 1);
            Region[] toForget = this.predmgr.createPredicateWithoutPrecisionCheck(applyVariable, bitsize);
            expandedState = expandedState.forget(toForget);
        }
        if (expandedState.getRegion().isFalse()) {
            return null;
        }
        return expandedState;
    }

    private Collection<String> filterBlockVariables(Iterable<String> variables) {
        ArrayList<String> result = new ArrayList<String>();
        for (String variable : variables) {
            if (this.manager.getPredicates().contains(variable + "@0")) {
                result.add(variable);
                continue;
            }
            this.logger.logf(Level.ALL, "variable '%s' was not declared in the BDD, ignoring it", new Object[]{variable});
        }
        return result;
    }

    private BDDState replace(BDDState state, String oldName, String newName, int bitsize) {
        Region[] oldVariable = this.predmgr.createPredicateWithoutPrecisionCheck(oldName, bitsize);
        Region[] newVariable = this.predmgr.createPredicateWithoutPrecisionCheck(newName, bitsize);
        return new BDDState(this.manager, this.bvmgr, this.manager.replace(state.getRegion(), Arrays.asList(oldVariable), Arrays.asList(newVariable)));
    }

    @Override
    protected Precision getVariableReducedPrecision0(Precision precision, Block context) {
        return precision;
    }

    @Override
    protected Precision getVariableExpandedPrecision0(Precision rootPrecision, Block rootContext, Precision reducedPrecision) {
        return reducedPrecision;
    }

    @Override
    protected Object getHashCodeForState0(BDDState stateKey, Precision precisionKey) {
        return Pair.of(stateKey.getRegion(), precisionKey);
    }

    @Override
    protected BDDState rebuildStateAfterFunctionCall0(BDDState rootState, BDDState entryState, BDDState expandedState, FunctionExitNode exitLocation) {
        throw new UnsupportedOperationException("not implemented");
    }
}

