/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.base.Joiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.java_smt.api.SolverException;

public class BDDState
implements AbstractQueryableState,
LatticeAbstractState<BDDState> {
    private Region currentState;
    private final NamedRegionManager manager;
    private final BitvectorManager bvmgr;

    public BDDState(NamedRegionManager mgr, BitvectorManager bvmgr, Region state) {
        this.currentState = state;
        this.manager = mgr;
        this.bvmgr = bvmgr;
    }

    public Region getRegion() {
        return this.currentState;
    }

    @Override
    public boolean isLessOrEqual(BDDState other) throws CPAException, InterruptedException {
        try {
            return this.manager.entails(this.currentState, other.currentState);
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure", e);
        }
    }

    @Override
    public BDDState join(BDDState other) {
        Region result = this.manager.makeOr(this.currentState, other.currentState);
        if (result.equals(other.currentState)) {
            return other;
        }
        if (result.equals(this.currentState)) {
            return this;
        }
        return new BDDState(this.manager, this.bvmgr, result);
    }

    @Override
    public String toString() {
        return this.manager.regionToDot(this.currentState);
    }

    public String toCompactString() {
        return "";
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BDDState) {
            BDDState other = (BDDState)o;
            return this.currentState.equals(other.currentState);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.currentState.hashCode();
    }

    @Override
    public String getCPAName() {
        return "BDDCPA";
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "VALUES": {
                return this.manager.dumpRegion(this.currentState).toString();
            }
            case "VARSET": {
                return "(" + Joiner.on((String)", ").join(this.manager.getPredicates()) + ")";
            }
            case "VARSETSIZE": {
                return this.manager.getPredicates().size();
            }
        }
        throw new InvalidQueryException("BDDCPA Element can only return the current values (\"VALUES\")");
    }

    public void addConstraintToState(Region pConstraint) {
        this.currentState = this.manager.makeAnd(this.currentState, pConstraint);
    }

    public BDDState addConstraint(Region constraint) {
        return new BDDState(this.manager, this.bvmgr, this.manager.makeAnd(this.currentState, constraint));
    }

    public BDDState addAssignment(@Nullable Region[] leftSide, @Nullable Region[] rightSide) {
        return this.addAssignment(leftSide, rightSide, false);
    }

    private BDDState addAssignment(@Nullable Region[] leftSide, @Nullable Region[] rightSide, boolean addIncreasing) {
        Region result;
        if (leftSide == null || rightSide == null) {
            return this;
        }
        assert (leftSide.length == rightSide.length) : "left side and right side should have equal length: " + leftSide.length + " != " + rightSide.length;
        Region[] assignRegions = this.bvmgr.makeBinaryEqual(leftSide, rightSide);
        if (addIncreasing) {
            result = assignRegions[0];
            for (int i = 1; i < assignRegions.length; ++i) {
                result = this.manager.makeAnd(result, assignRegions[i]);
            }
        } else {
            result = assignRegions[assignRegions.length - 1];
            for (int i = assignRegions.length - 2; i >= 0; --i) {
                result = this.manager.makeAnd(result, assignRegions[i]);
            }
        }
        result = this.manager.makeAnd(this.currentState, result);
        return new BDDState(this.manager, this.bvmgr, result);
    }

    public BDDState forget(Region ... toForget) {
        if (toForget == null) {
            return this;
        }
        return new BDDState(this.manager, this.bvmgr, this.manager.makeExists(this.currentState, toForget));
    }
}

