/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

@Options(prefix="cpa.bdd")
final class BDDStatistics
implements Statistics {
    @Option(secure=true, name="logfile", description="Dump tracked variables to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    Path dumpfile = Path.of("BDDCPA_tracked_variables.log", new String[0]);
    @Option(secure=true, name="variablesFile", description="Dump tracked variables to a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path variablesFile = Path.of("BDDCPA_ordered_variables.txt", new String[0]);
    private final NamedRegionManager manager;
    private final PredicateManager predmgr;
    private final LogManager logger;
    private final CFA cfa;

    BDDStatistics(Configuration pConfig, CFA pCfa, LogManager pLogger, NamedRegionManager pManager, PredicateManager pPredMgr) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.logger = pLogger;
        this.manager = pManager;
        this.predmgr = pPredMgr;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        VariableClassification varClass = this.cfa.getVarClassification().orElseThrow();
        Set<Partition> intBool = varClass.getIntBoolPartitions();
        int numOfBooleans = varClass.getIntBoolVars().size();
        int numOfIntEquals = 0;
        Set<Partition> intEq = varClass.getIntEqualPartitions();
        for (Partition p : intEq) {
            numOfIntEquals += p.getVars().size();
        }
        int numOfIntAdds = 0;
        Set<Partition> intAdd = varClass.getIntAddPartitions();
        for (Partition p : intAdd) {
            numOfIntAdds += p.getVars().size();
        }
        TreeSet<String> trackedIntBool = new TreeSet<String>();
        TreeSet<String> trackedIntEq = new TreeSet<String>();
        TreeSet<String> trackedIntAdd = new TreeSet<String>();
        for (String var : this.predmgr.getTrackedVars()) {
            if (varClass.getIntBoolVars().contains(var)) {
                trackedIntBool.add(var);
                continue;
            }
            if (varClass.getIntEqualVars().contains(var)) {
                trackedIntEq.add(var);
                continue;
            }
            if (!varClass.getIntAddVars().contains(var)) continue;
            trackedIntAdd.add(var);
        }
        if (this.dumpfile != null) {
            try (Writer w = IO.openOutputFile((Path)this.dumpfile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                w.append("Boolean\n\n");
                w.append(((Object)trackedIntBool).toString());
                w.append("\n\nIntEq\n\n");
                w.append(((Object)trackedIntEq).toString());
                w.append("\n\nIntAdd\n\n");
                w.append(((Object)trackedIntAdd).toString());
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write tracked variables for BDDCPA to file");
            }
        }
        out.println(String.format("Number of boolean vars:           %d (of %d)", trackedIntBool.size(), numOfBooleans));
        out.println(String.format("Number of intEqual vars:          %d (of %d)", trackedIntEq.size(), numOfIntEquals));
        out.println(String.format("Number of intAdd vars:            %d (of %d)", trackedIntAdd.size(), numOfIntAdds));
        out.println(String.format("Number of all vars:               %d", trackedIntBool.size() + trackedIntEq.size() + trackedIntAdd.size()));
        out.println("Number of intBool partitions:     " + intBool.size());
        out.println("Number of intEq partitions:       " + intEq.size());
        out.println("Number of intAdd partitions:      " + intAdd.size());
        out.println("Number of all partitions:         " + varClass.getPartitions().size());
        this.manager.printStatistics(out);
    }

    @Override
    public String getName() {
        return "BDDCPA";
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if (this.variablesFile != null) {
            try {
                IO.writeFile((Path)this.variablesFile, (Charset)Charset.defaultCharset(), (Object)Joiner.on((String)"\n").join(this.manager.getOrderedPredicates()));
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write ordered variables to file");
            }
        }
    }
}

