/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDState;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorComputer;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.cpa.bdd.VarCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerTransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.util.ExplicitLocationSet;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public class BDDTransferRelation
extends ForwardingTransferRelation<BDDState, BDDState, VariableTrackingPrecision> {
    private final int bitsize;
    private final VariableClassification varClass;
    private final BitvectorManager bvmgr;
    private final NamedRegionManager rmgr;
    private final PredicateManager predmgr;
    private final BitvectorComputer bvComputer;

    public BDDTransferRelation(NamedRegionManager manager, BitvectorManager pBvmgr, PredicateManager pPredmgr, CFA cfa, int pBitsize, BitvectorComputer pBvComputer) {
        this.rmgr = manager;
        this.bvmgr = pBvmgr;
        this.predmgr = pPredmgr;
        this.bitsize = pBitsize;
        assert (cfa.getVarClassification().isPresent());
        this.varClass = cfa.getVarClassification().orElseThrow();
        this.bvComputer = pBvComputer;
    }

    @Override
    protected Collection<BDDState> preCheck(BDDState pState, VariableTrackingPrecision pPrecision) {
        if (pPrecision.isEmpty()) {
            return Collections.singleton(pState);
        }
        if (pState.getRegion().isFalse()) {
            return ImmutableList.of();
        }
        return null;
    }

    @Override
    protected BDDState handleStatementEdge(CStatementEdge cfaEdge, CStatement statement) throws UnsupportedCodeException {
        BDDState result = (BDDState)this.state;
        if (statement instanceof CAssignment) {
            result = this.handleAssignment((CAssignment)statement, cfaEdge.getSuccessor(), cfaEdge);
        } else if (statement instanceof CFunctionCallStatement) {
            result = this.handleExternalFunctionCall(result, cfaEdge.getSuccessor(), ((CFunctionCallStatement)statement).getFunctionCallExpression().getParameterExpressions());
        }
        assert (!result.getRegion().isFalse());
        return result;
    }

    private BDDState handleAssignment(CAssignment assignment, CFANode successor, CFAEdge edge) throws UnsupportedCodeException {
        CLeftHandSide lhs = assignment.getLeftHandSide();
        Object varName = lhs instanceof CIdExpression ? ((CIdExpression)lhs).getDeclaration().getQualifiedName() : this.functionName + "::" + lhs;
        CType targetType = lhs.getExpressionType();
        if (!((VariableTrackingPrecision)this.precision).isTracking(MemoryLocation.fromQualifiedName((String)varName), targetType, successor)) {
            return (BDDState)this.state;
        }
        BDDState newState = (BDDState)this.state;
        CRightHandSide rhs = assignment.getRightHandSide();
        if (rhs instanceof CExpression) {
            CExpression exp = (CExpression)rhs;
            Partition partition = this.varClass.getPartitionForEdge(edge);
            if (BDDTransferRelation.isUsedInExpression((String)varName, exp)) {
                String tmpVarName = this.predmgr.getTmpVariableForPartition(partition);
                Region[] tmp = this.predmgr.createPredicateWithoutPrecisionCheck(tmpVarName, this.bvComputer.getBitsize(partition, targetType));
                CFANode location = successor;
                Region[] regRHS = this.bvComputer.evaluateVectorExpression(partition, exp, targetType, location, (VariableTrackingPrecision)this.precision);
                newState = newState.addAssignment(tmp, regRHS);
                Region[] var = this.predmgr.createPredicate(this.scopeVar(lhs), targetType, successor, this.bvComputer.getBitsize(partition, targetType), (VariableTrackingPrecision)this.precision);
                newState = newState.forget(var);
                newState = newState.addAssignment(var, tmp);
                newState = newState.forget(tmp);
            } else {
                Region[] var = this.predmgr.createPredicate(this.scopeVar(lhs), targetType, successor, this.bvComputer.getBitsize(partition, targetType), (VariableTrackingPrecision)this.precision);
                newState = newState.forget(var);
                CFANode location = successor;
                Region[] regRHS = this.bvComputer.evaluateVectorExpression(partition, (CExpression)rhs, targetType, location, (VariableTrackingPrecision)this.precision);
                newState = newState.addAssignment(var, regRHS);
            }
            return newState;
        }
        if (rhs instanceof CFunctionCallExpression) {
            newState = this.handleExternalFunctionCall(newState, successor, ((CFunctionCallExpression)rhs).getParameterExpressions());
            Region[] var = this.predmgr.createPredicate(this.scopeVar(lhs), targetType, successor, this.bitsize, (VariableTrackingPrecision)this.precision);
            newState = newState.forget(var);
            return newState;
        }
        throw new AssertionError((Object)("unhandled assignment: " + edge.getRawStatement()));
    }

    private BDDState handleExternalFunctionCall(BDDState currentState, CFANode successor, List<CExpression> params) {
        Iterator<CExpression> iterator = params.iterator();
        while (iterator.hasNext()) {
            CExpression param;
            CExpression unpackedParam = param = iterator.next();
            while (unpackedParam instanceof CCastExpression) {
                unpackedParam = ((CCastExpression)param).getOperand();
            }
            if (!(unpackedParam instanceof CUnaryExpression) || CUnaryExpression.UnaryOperator.AMPER != ((CUnaryExpression)unpackedParam).getOperator() || !(((CUnaryExpression)unpackedParam).getOperand() instanceof CIdExpression)) continue;
            CIdExpression id = (CIdExpression)((CUnaryExpression)unpackedParam).getOperand();
            Region[] var = this.predmgr.createPredicate(this.scopeVar(id), id.getExpressionType(), successor, this.bitsize, (VariableTrackingPrecision)this.precision);
            currentState = currentState.forget(var);
        }
        return currentState;
    }

    @Override
    protected BDDState handleDeclarationEdge(CDeclarationEdge cfaEdge, CDeclaration decl) throws UnsupportedCodeException {
        if (decl instanceof CVariableDeclaration) {
            CVariableDeclaration vdecl = (CVariableDeclaration)decl;
            if (vdecl.getType().isIncomplete()) {
                return (BDDState)this.state;
            }
            CInitializer initializer = vdecl.getInitializer();
            CExpression init = null;
            if (initializer instanceof CInitializerExpression) {
                init = ((CInitializerExpression)initializer).getExpression();
            }
            Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
            Region[] var = this.predmgr.createPredicate(vdecl.getQualifiedName(), vdecl.getType(), cfaEdge.getSuccessor(), this.bvComputer.getBitsize(partition, vdecl.getType()), (VariableTrackingPrecision)this.precision);
            BDDState newState = ((BDDState)this.state).forget(var);
            if (init != null) {
                Region[] rhs = this.bvComputer.evaluateVectorExpression(partition, init, vdecl.getType(), cfaEdge.getSuccessor(), (VariableTrackingPrecision)this.precision);
                newState = newState.addAssignment(var, rhs);
            }
            return newState;
        }
        return (BDDState)this.state;
    }

    @Override
    protected BDDState handleFunctionCallEdge(CFunctionCallEdge cfaEdge, List<CExpression> args, List<CParameterDeclaration> params, String calledFunction) throws UnsupportedCodeException {
        BDDState newState = (BDDState)this.state;
        assert (args.size() >= params.size());
        for (int i = 0; i < params.size(); ++i) {
            String varName = params.get(i).getQualifiedName();
            CType targetType = params.get(i).getType();
            Partition partition = this.varClass.getPartitionForParameterOfEdge(cfaEdge, i);
            Region[] var = this.predmgr.createPredicate(varName, targetType, cfaEdge.getSuccessor(), this.bvComputer.getBitsize(partition, targetType), (VariableTrackingPrecision)this.precision);
            Region[] arg = this.bvComputer.evaluateVectorExpression(partition, args.get(i), targetType, cfaEdge.getSuccessor(), (VariableTrackingPrecision)this.precision);
            newState = newState.addAssignment(var, arg);
        }
        return newState;
    }

    @Override
    protected BDDState handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String outerFunctionName) {
        BDDState newState = (BDDState)this.state;
        Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
        if (summaryExpr instanceof CFunctionCallAssignmentStatement) {
            String returnVar = fnkCall.getFunctionEntry().getReturnVariable().orElseThrow().getQualifiedName();
            CFunctionCallAssignmentStatement cAssignment = (CFunctionCallAssignmentStatement)summaryExpr;
            CLeftHandSide lhs = cAssignment.getLeftHandSide();
            int size = this.bvComputer.getBitsize(partition, lhs.getExpressionType());
            Region[] var = this.predmgr.createPredicate(this.scopeVar(lhs), lhs.getExpressionType(), cfaEdge.getSuccessor(), size, (VariableTrackingPrecision)this.precision);
            newState = newState.forget(var);
            Region[] retVar = this.predmgr.createPredicate(returnVar, summaryExpr.getFunctionCallExpression().getExpressionType(), cfaEdge.getSuccessor(), size, (VariableTrackingPrecision)this.precision);
            newState = newState.addAssignment(var, retVar);
            if (this.predmgr.getTrackedVars().contains(returnVar)) {
                newState = newState.forget(this.predmgr.createPredicateWithoutPrecisionCheck(returnVar));
            }
        } else assert (summaryExpr instanceof CFunctionCallStatement);
        return newState;
    }

    @Override
    protected BDDState handleReturnStatementEdge(CReturnStatementEdge cfaEdge) throws UnsupportedCodeException {
        BDDState newState = (BDDState)this.state;
        String returnVar = "";
        if (cfaEdge.getExpression().isPresent()) {
            returnVar = ((CIdExpression)cfaEdge.asAssignment().orElseThrow().getLeftHandSide()).getDeclaration().getQualifiedName();
            Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
            CType functionReturnType = ((CFunctionDeclaration)cfaEdge.getSuccessor().getEntryNode().getFunctionDefinition()).getType().getReturnType();
            Region[] regRHS = this.bvComputer.evaluateVectorExpression(partition, cfaEdge.getExpression().orElseThrow(), functionReturnType, cfaEdge.getSuccessor(), (VariableTrackingPrecision)this.precision);
            Region[] retvar = this.predmgr.createPredicate(returnVar, functionReturnType, cfaEdge.getSuccessor(), this.bvComputer.getBitsize(partition, functionReturnType), (VariableTrackingPrecision)this.precision);
            newState = newState.forget(retvar);
            newState = newState.addAssignment(retvar, regRHS);
        }
        for (String var : this.predmgr.getTrackedVars()) {
            if (!BDDTransferRelation.isLocalVariableForFunction(var, this.functionName) || returnVar.equals(var)) continue;
            newState = newState.forget(this.predmgr.createPredicateWithoutPrecisionCheck(var));
        }
        return newState;
    }

    @Override
    protected BDDState handleBlankEdge(BlankEdge cfaEdge) {
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode) {
            assert ("default return".equals(cfaEdge.getDescription()) || "skipped unnecessary edges".equals(cfaEdge.getDescription()));
            BDDState newState = (BDDState)this.state;
            for (String var : this.predmgr.getTrackedVars()) {
                if (!BDDTransferRelation.isLocalVariableForFunction(var, this.functionName)) continue;
                newState = newState.forget(this.predmgr.createPredicateWithoutPrecisionCheck(var));
            }
            return newState;
        }
        return (BDDState)this.state;
    }

    @Override
    protected BDDState handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws UnsupportedCodeException {
        Region newRegion;
        Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
        Region[] operand = this.bvComputer.evaluateVectorExpression(partition, expression, CNumericTypes.INT, cfaEdge.getSuccessor(), (VariableTrackingPrecision)this.precision);
        if (operand == null) {
            return (BDDState)this.state;
        }
        Region evaluated = this.bvmgr.makeOr(operand);
        if (!truthAssumption) {
            evaluated = this.rmgr.makeNot(evaluated);
        }
        if ((newRegion = this.rmgr.makeAnd(((BDDState)this.state).getRegion(), evaluated)).isFalse()) {
            return null;
        }
        return new BDDState(this.rmgr, this.bvmgr, newRegion);
    }

    private BDDState handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption, PointerState pPointerInfo) throws UnsupportedCodeException {
        Region newRegion;
        Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
        Region[] operand = this.bvComputer.evaluateVectorExpressionWithPointerState(partition, expression, CNumericTypes.INT, cfaEdge.getSuccessor(), pPointerInfo, (VariableTrackingPrecision)this.precision);
        if (operand == null) {
            return (BDDState)this.state;
        }
        Region evaluated = this.bvmgr.makeOr(operand);
        if (!truthAssumption) {
            evaluated = this.rmgr.makeNot(evaluated);
        }
        if ((newRegion = this.rmgr.makeAnd(((BDDState)this.state).getRegion(), evaluated)).isFalse()) {
            return null;
        }
        return new BDDState(this.rmgr, this.bvmgr, newRegion);
    }

    private static boolean isUsedInExpression(String varName, CExpression exp) {
        return exp.accept(new VarCExpressionVisitor(varName));
    }

    private String scopeVar(CExpression exp) {
        if (exp instanceof CIdExpression) {
            return ((CIdExpression)exp).getDeclaration().getQualifiedName();
        }
        return this.functionName + "::" + exp.toASTString();
    }

    private static boolean isLocalVariableForFunction(String scopedVarName, String function) {
        return scopedVarName.startsWith(function + "::");
    }

    static @Nullable String getCanonicalName(CExpression expr) {
        Object name = "";
        while (true) {
            if (expr instanceof CIdExpression) {
                return ((CIdExpression)expr).getDeclaration().getQualifiedName() + (String)name;
            }
            if (!(expr instanceof CFieldReference)) break;
            CFieldReference fieldRef = (CFieldReference)expr;
            name = (fieldRef.isPointerDereference() ? "->" : ".") + fieldRef.getFieldName() + (String)name;
            expr = fieldRef.getFieldOwner();
        }
        return null;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, Iterable<AbstractState> states, CFAEdge cfaEdge, Precision pPrecision) throws CPATransferException {
        BDDState bddState = (BDDState)pState;
        for (AbstractState otherState : states) {
            if (!(otherState instanceof PointerState)) continue;
            super.setInfo(bddState, pPrecision, cfaEdge);
            bddState = this.strengthenWithPointerInformation((PointerState)otherState, cfaEdge);
            super.resetInfo();
            if (bddState != null) continue;
            return ImmutableList.of();
        }
        return Collections.singleton(bddState);
    }

    private BDDState strengthenWithPointerInformation(PointerState pPointerInfo, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        ExplicitLocationSet explicitSet;
        if (cfaEdge instanceof CAssumeEdge) {
            CAssumeEdge assumeEdge = (CAssumeEdge)cfaEdge;
            return this.handleAssumption(assumeEdge, assumeEdge.getExpression(), assumeEdge.getTruthAssumption(), pPointerInfo);
        }
        MemoryLocation target = null;
        ALeftHandSide leftHandSide = CFAEdgeUtils.getLeftHandSide(cfaEdge);
        if (leftHandSide instanceof CIdExpression) {
            target = MemoryLocation.forDeclaration(((CIdExpression)leftHandSide).getDeclaration());
        } else if (leftHandSide instanceof CPointerExpression && (explicitSet = BDDTransferRelation.getLocationsForLhs(pPointerInfo, (CPointerExpression)leftHandSide)) != null && explicitSet.getSize() == 1) {
            target = (MemoryLocation)Iterables.getOnlyElement((Iterable)explicitSet);
        }
        if (target == null) {
            return (BDDState)this.state;
        }
        MemoryLocation value = null;
        CType valueType = null;
        CRightHandSide rightHandSide = CFAEdgeUtils.getRightHandSide(cfaEdge);
        if (rightHandSide instanceof CIdExpression) {
            CIdExpression idExpr = (CIdExpression)rightHandSide;
            value = MemoryLocation.forDeclaration(idExpr.getDeclaration());
            valueType = idExpr.getDeclaration().getType();
        } else if (rightHandSide instanceof CPointerExpression) {
            CPointerExpression ptrExpr = (CPointerExpression)rightHandSide;
            value = BDDTransferRelation.getLocationForRhs(pPointerInfo, ptrExpr);
            valueType = ptrExpr.getExpressionType().getCanonicalType();
        }
        if (value == null) {
            return (BDDState)this.state;
        }
        Partition partition = this.varClass.getPartitionForEdge(cfaEdge);
        int size = this.bvComputer.getBitsize(partition, valueType);
        Region[] rhs = this.predmgr.createPredicate(target.getExtendedQualifiedName(), valueType, cfaEdge.getSuccessor(), size, (VariableTrackingPrecision)this.precision);
        Region[] evaluation = this.predmgr.createPredicate(value.getExtendedQualifiedName(), valueType, cfaEdge.getSuccessor(), size, (VariableTrackingPrecision)this.precision);
        BDDState newState = ((BDDState)this.state).forget(rhs);
        return newState.addAssignment(rhs, evaluation);
    }

    static @Nullable ExplicitLocationSet getLocationsForLhs(PointerState pPointerInfo, CPointerExpression pPointer) throws UnrecognizedCodeException {
        ExplicitLocationSet explicitSet;
        LocationSet indirectLocation;
        LocationSet directLocation = PointerTransferRelation.asLocations(pPointer, pPointerInfo);
        if (!(directLocation instanceof ExplicitLocationSet) && (indirectLocation = PointerTransferRelation.asLocations(pPointer.getOperand(), pPointerInfo)) instanceof ExplicitLocationSet && (explicitSet = (ExplicitLocationSet)indirectLocation).getSize() == 1) {
            directLocation = pPointerInfo.getPointsToSet((MemoryLocation)Iterables.getOnlyElement((Iterable)explicitSet));
        }
        if (directLocation instanceof ExplicitLocationSet) {
            return (ExplicitLocationSet)directLocation;
        }
        return null;
    }

    static @Nullable MemoryLocation getLocationForRhs(PointerState pPointerInfo, CPointerExpression pPointer) throws UnrecognizedCodeException {
        ExplicitLocationSet explicitPointsToSet;
        LocationSet pointsToSet;
        ExplicitLocationSet explicitSet;
        LocationSet fullSet = PointerTransferRelation.asLocations(pPointer.getOperand(), pPointerInfo);
        if (fullSet instanceof ExplicitLocationSet && (explicitSet = (ExplicitLocationSet)fullSet).getSize() == 1 && (pointsToSet = pPointerInfo.getPointsToSet((MemoryLocation)Iterables.getOnlyElement((Iterable)explicitSet))) instanceof ExplicitLocationSet && (explicitPointsToSet = (ExplicitLocationSet)pointsToSet).getSize() == 1) {
            return (MemoryLocation)Iterables.getOnlyElement((Iterable)explicitPointsToSet);
        }
        return null;
    }
}

