/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDTransferRelation;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;

public class BDDVectorCExpressionVisitor
extends DefaultCExpressionVisitor<Region[], UnsupportedCodeException> {
    private final MachineModel machineModel;
    protected final PredicateManager predMgr;
    protected final VariableTrackingPrecision precision;
    protected final BitvectorManager bvmgr;
    protected final CFANode location;

    protected BDDVectorCExpressionVisitor(PredicateManager pPredMgr, VariableTrackingPrecision pPrecision, BitvectorManager pBVmgr, MachineModel pMachineModel, CFANode pLocation) {
        this.predMgr = pPredMgr;
        this.precision = pPrecision;
        this.bvmgr = pBVmgr;
        this.machineModel = pMachineModel;
        this.location = pLocation;
    }

    @Override
    protected Region[] visitDefault(CExpression pExp) {
        return null;
    }

    @Override
    public Region[] visit(CBinaryExpression pE) throws UnsupportedCodeException {
        Region[] lVal = pE.getOperand1().accept(this);
        Region[] rVal = pE.getOperand2().accept(this);
        if (lVal == null || rVal == null) {
            return null;
        }
        return BDDVectorCExpressionVisitor.calculateBinaryOperation(lVal, rVal, pE.getOperand1().getExpressionType(), pE.getOperand2().getExpressionType(), this.bvmgr, pE, this.machineModel);
    }

    public static Region[] calculateBinaryOperation(Region[] lVal, Region[] rVal, CType lType, CType rType, BitvectorManager bvmgr, CBinaryExpression binaryExpr, MachineModel machineModel) {
        Region[] result;
        CBinaryExpression.BinaryOperator binaryOperator = binaryExpr.getOperator();
        CType calculationType = binaryExpr.getCalculationType();
        lVal = BDDVectorCExpressionVisitor.castCValue(lVal, lType, calculationType, bvmgr, machineModel);
        if (binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_LEFT && binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_RIGHT) {
            rVal = BDDVectorCExpressionVisitor.castCValue(rVal, rType, calculationType, bvmgr, machineModel);
        }
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULO: 
            case MULTIPLY: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                result = BDDVectorCExpressionVisitor.arithmeticOperation(lVal, rVal, bvmgr, binaryOperator, calculationType);
                result = BDDVectorCExpressionVisitor.castCValue(result, calculationType, binaryExpr.getExpressionType(), bvmgr, machineModel);
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                Region tmp = BDDVectorCExpressionVisitor.booleanOperation(lVal, rVal, bvmgr, binaryOperator, calculationType);
                int size = 32;
                if (calculationType instanceof CSimpleType) {
                    size = machineModel.getSizeofInBits((CSimpleType)calculationType);
                }
                result = bvmgr.wrapLast(tmp, size);
                break;
            }
            default: {
                throw new AssertionError((Object)"unhandled binary operator");
            }
        }
        return result;
    }

    private static Region[] arithmeticOperation(Region[] l, Region[] r, BitvectorManager bvmgr, CBinaryExpression.BinaryOperator op, CType calculationType) {
        boolean signed = true;
        if (calculationType instanceof CSimpleType) {
            signed = !((CSimpleType)calculationType).isUnsigned();
        }
        switch (op) {
            case PLUS: {
                return bvmgr.makeAdd(l, r);
            }
            case MINUS: {
                return bvmgr.makeSub(l, r);
            }
            case DIVIDE: {
                return bvmgr.makeDiv(l, r, signed);
            }
            case MODULO: {
                return bvmgr.makeMod(l, r, signed);
            }
            case MULTIPLY: {
                return bvmgr.makeMult(l, r);
            }
            case SHIFT_LEFT: {
                return bvmgr.makeShiftLeft(l, r);
            }
            case SHIFT_RIGHT: {
                return bvmgr.makeShiftRight(l, r, signed);
            }
            case BINARY_AND: {
                return bvmgr.makeBinaryAnd(l, r);
            }
            case BINARY_OR: {
                return bvmgr.makeBinaryOr(l, r);
            }
            case BINARY_XOR: {
                return bvmgr.makeXor(l, r);
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    protected static Region booleanOperation(Region[] l, Region[] r, BitvectorManager bvmgr, CBinaryExpression.BinaryOperator op, CType calculationType) {
        boolean signed = true;
        if (calculationType instanceof CSimpleType) {
            signed = !((CSimpleType)calculationType).isUnsigned();
        }
        switch (op) {
            case EQUALS: {
                return bvmgr.makeLogicalEqual(l, r);
            }
            case NOT_EQUALS: {
                return bvmgr.makeNot(bvmgr.makeLogicalEqual(l, r));
            }
            case GREATER_THAN: {
                return bvmgr.makeLess(r, l, signed);
            }
            case GREATER_EQUAL: {
                return bvmgr.makeLessOrEqual(r, l, signed);
            }
            case LESS_THAN: {
                return bvmgr.makeLess(l, r, signed);
            }
            case LESS_EQUAL: {
                return bvmgr.makeLessOrEqual(l, r, signed);
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    @Override
    public Region[] visit(CCastExpression pE) throws UnsupportedCodeException {
        return BDDVectorCExpressionVisitor.castCValue(pE.getOperand().accept(this), pE.getOperand().getExpressionType(), pE.getExpressionType(), this.bvmgr, this.machineModel);
    }

    @Override
    public Region[] visit(CCharLiteralExpression pE) {
        return this.bvmgr.makeNumber(pE.getCharacter(), this.getSize(pE.getExpressionType()));
    }

    @Override
    public Region[] visit(CFieldReference pE) {
        String name = BDDTransferRelation.getCanonicalName(pE);
        if (name == null) {
            return this.visitDefault(pE);
        }
        return this.predMgr.createPredicate(name, pE.getExpressionType(), this.location, this.getSize(pE.getExpressionType()), this.precision);
    }

    @Override
    public Region[] visit(CIntegerLiteralExpression pE) {
        return this.bvmgr.makeNumber(pE.asLong(), this.getSize(pE.getExpressionType()));
    }

    @Override
    public Region[] visit(CImaginaryLiteralExpression pE) throws UnsupportedCodeException {
        return pE.getValue().accept(this);
    }

    @Override
    public Region[] visit(CArraySubscriptExpression expression) throws UnsupportedCodeException {
        throw new UnsupportedCodeException("BDD-analysis does not support arrays: " + expression, null);
    }

    @Override
    public Region[] visit(CTypeIdExpression pE) {
        CTypeIdExpression.TypeIdOperator idOperator = pE.getOperator();
        CType innerType = pE.getType();
        switch (idOperator) {
            case SIZEOF: {
                return this.getSizeof(innerType);
            }
        }
        return null;
    }

    @Override
    public Region[] visit(CIdExpression idExp) {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            if (enumerator.hasValue()) {
                return this.bvmgr.makeNumber(enumerator.getValue(), this.getSize(idExp.getExpressionType()));
            }
            return null;
        }
        return this.predMgr.createPredicate(idExp.getDeclaration().getQualifiedName(), idExp.getExpressionType(), this.location, this.getSize(idExp.getExpressionType()), this.precision);
    }

    @Override
    public Region[] visit(CUnaryExpression unaryExpression) throws UnsupportedCodeException {
        CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        CExpression unaryOperand = unaryExpression.getOperand();
        if (unaryOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
            return this.getSizeof(unaryOperand.getExpressionType());
        }
        Region[] value = unaryOperand.accept(this);
        if (value == null) {
            return null;
        }
        switch (unaryOperator) {
            case MINUS: {
                return this.bvmgr.makeSub(this.bvmgr.makeNumber(BigInteger.ZERO, value.length), value);
            }
            case SIZEOF: {
                throw new AssertionError((Object)"SIZEOF should be handled before!");
            }
            case AMPER: {
                return this.getSizeof(unaryOperand.getExpressionType());
            }
            case TILDE: {
                return this.bvmgr.makeBinaryEqual(this.bvmgr.makeNumber(BigInteger.ZERO, value.length), value);
            }
        }
        return null;
    }

    private Region[] getSizeof(CType pType) {
        return this.bvmgr.makeNumber(this.machineModel.getSizeof(pType), this.machineModel.getSizeofInt());
    }

    protected int getSize(CType pType) {
        return this.machineModel.getSizeofInBits(pType).intValueExact();
    }

    public Region[] evaluate(CExpression pExp, CType pTargetType) throws UnsupportedCodeException {
        return BDDVectorCExpressionVisitor.castCValue(pExp.accept(this), pExp.getExpressionType(), pTargetType, this.bvmgr, this.machineModel);
    }

    public static Region[] castCValue(@Nullable Region[] value, CType sourceType, CType targetType, BitvectorManager bvmgr, MachineModel machineModel) {
        if (value == null) {
            return null;
        }
        sourceType = sourceType.getCanonicalType();
        if ((targetType = targetType.getCanonicalType()) instanceof CSimpleType && sourceType instanceof CSimpleType) {
            return bvmgr.toBitsize(machineModel.getSizeofInBits((CSimpleType)targetType), machineModel.isSigned((CSimpleType)sourceType), value);
        }
        return value;
    }
}

