/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.bdd.BDDCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class BddArgBasedRefiner
implements ARGBasedRefiner,
Statistics,
StatisticsProvider {
    private final ValueAnalysisPathInterpolator interpolatingRefiner;
    private final FeasibilityChecker<ValueAnalysisState> checker;
    private int previousErrorPathId = -1;
    private int numberOfValueAnalysisRefinements = 0;
    private int numberOfSuccessfulValueAnalysisRefinements = 0;

    BddArgBasedRefiner(FeasibilityChecker<ValueAnalysisState> pFeasibilityChecker, ValueAnalysisPathInterpolator pPathInterpolator) {
        this.checker = pFeasibilityChecker;
        this.interpolatingRefiner = pPathInterpolator;
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        if (!this.isPathFeasable(pErrorPath) && this.performValueAnalysisRefinement(reached, pErrorPath)) {
            return CounterexampleInfo.spurious();
        }
        return CounterexampleInfo.feasibleImprecise(pErrorPath);
    }

    private boolean performValueAnalysisRefinement(ARGReachedSet reached, ARGPath errorPath) throws CPAException, InterruptedException {
        ++this.numberOfValueAnalysisRefinements;
        int currentErrorPathId = errorPath.toString().hashCode();
        if (currentErrorPathId == this.previousErrorPathId) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, errorPath);
        }
        this.previousErrorPathId = currentErrorPathId;
        UnmodifiableReachedSet reachedSet = reached.asReachedSet();
        Precision precision = reachedSet.getPrecision(reachedSet.getLastState());
        VariableTrackingPrecision bddPrecision = (VariableTrackingPrecision)Precisions.asIterable(precision).filter(VariableTrackingPrecision.isMatchingCPAClass(BDDCPA.class)).get(0);
        Multimap<CFANode, MemoryLocation> increment = this.interpolatingRefiner.determinePrecisionIncrement(errorPath);
        Pair<ARGState, CFAEdge> refinementRoot = this.interpolatingRefiner.determineRefinementRoot(errorPath, increment);
        if (increment.isEmpty()) {
            return false;
        }
        VariableTrackingPrecision refinedBDDPrecision = bddPrecision.withIncrement(increment);
        ++this.numberOfSuccessfulValueAnalysisRefinements;
        reached.removeSubtree(refinementRoot.getFirst(), refinedBDDPrecision, VariableTrackingPrecision.isMatchingCPAClass(BDDCPA.class));
        return true;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
        pStatsCollection.add(this.interpolatingRefiner);
    }

    @Override
    public String getName() {
        return "BddDelegatingRefiner";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        out.println("  number of value analysis refinements:                " + this.numberOfValueAnalysisRefinements);
        out.println("  number of successful valueAnalysis refinements:      " + this.numberOfSuccessfulValueAnalysisRefinements);
    }

    boolean isPathFeasable(ARGPath path) throws CPAException, InterruptedException {
        return this.checker.isFeasible(path);
    }
}

