/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import java.math.BigInteger;
import java.util.NavigableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDBooleanExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDCompressExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDPointerBooleanExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDPointerCompressExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDPointerVectorCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDVectorCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.cpa.bdd.PredicateManager;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

class BitvectorComputer {
    private final boolean compressIntEqual;
    private final VariableClassification varClass;
    private final BitvectorManager bvmgr;
    private final NamedRegionManager rmgr;
    private final PredicateManager predmgr;
    private final MachineModel machineModel;

    public BitvectorComputer(boolean pCompressIntEqual, VariableClassification pVarClass, BitvectorManager pBvmgr, NamedRegionManager pRmgr, PredicateManager pPredmgr, MachineModel pMachineModel) {
        this.compressIntEqual = pCompressIntEqual;
        this.varClass = pVarClass;
        this.bvmgr = pBvmgr;
        this.rmgr = pRmgr;
        this.predmgr = pPredmgr;
        this.machineModel = pMachineModel;
    }

    int getBitsize(@Nullable Partition partition, @Nullable CType type) {
        if (partition == null) {
            return 0;
        }
        if (this.varClass.getIntBoolPartitions().contains(partition)) {
            return 1;
        }
        if (this.compressIntEqual && this.varClass.getIntEqualPartitions().contains(partition)) {
            NavigableSet<BigInteger> values = partition.getValues();
            int N = values.size();
            if (!values.contains(BigInteger.ZERO)) {
                ++N;
            }
            if (!values.contains(BigInteger.ONE)) {
                ++N;
            }
            int M = partition.getVars().size();
            return (int)Math.ceil(Math.log(N + M) / Math.log(2.0));
        }
        if (type != null) {
            return this.machineModel.getSizeofInBits(type).intValueExact();
        }
        return 0;
    }

    @Nullable Region[] evaluateVectorExpression(Partition partition, CExpression exp, CType targetType, CFANode location, VariableTrackingPrecision precision) throws UnsupportedCodeException {
        boolean compress;
        boolean bl = compress = partition != null && this.compressIntEqual && this.varClass.getIntEqualPartitions().contains(partition);
        if (this.varClass.getIntBoolPartitions().contains(partition)) {
            Region[] regionArray;
            Region booleanResult = exp.accept(new BDDBooleanExpressionVisitor(this.predmgr, this.rmgr, precision, location));
            if (booleanResult == null) {
                regionArray = null;
            } else {
                Region[] regionArray2 = new Region[1];
                regionArray = regionArray2;
                regionArray2[0] = booleanResult;
            }
            return regionArray;
        }
        if (compress) {
            return exp.accept(new BDDCompressExpressionVisitor(this.predmgr, precision, this.getBitsize(partition, null), location, this.bvmgr, partition));
        }
        Region[] value = exp.accept(new BDDVectorCExpressionVisitor(this.predmgr, precision, this.bvmgr, this.machineModel, location));
        targetType = targetType.getCanonicalType();
        if (value != null && targetType instanceof CSimpleType) {
            CType sourceType = exp.getExpressionType().getCanonicalType();
            value = this.bvmgr.toBitsize(this.machineModel.getSizeofInBits((CSimpleType)targetType), sourceType instanceof CSimpleType && this.machineModel.isSigned((CSimpleType)sourceType), value);
        }
        return value;
    }

    @Nullable Region[] evaluateVectorExpressionWithPointerState(Partition partition, CExpression exp, CType targetType, CFANode location, PointerState pPointerInfo, VariableTrackingPrecision precision) throws UnsupportedCodeException {
        boolean compress;
        boolean bl = compress = partition != null && this.compressIntEqual && this.varClass.getIntEqualPartitions().contains(partition);
        if (this.varClass.getIntBoolPartitions().contains(partition)) {
            Region[] regionArray;
            Region booleanResult = exp.accept(new BDDPointerBooleanExpressionVisitor(this.predmgr, this.rmgr, precision, location, pPointerInfo));
            if (booleanResult == null) {
                regionArray = null;
            } else {
                Region[] regionArray2 = new Region[1];
                regionArray = regionArray2;
                regionArray2[0] = booleanResult;
            }
            return regionArray;
        }
        if (compress) {
            return exp.accept(new BDDPointerCompressExpressionVisitor(this.predmgr, precision, this.getBitsize(partition, null), location, this.bvmgr, partition, pPointerInfo));
        }
        Region[] value = exp.accept(new BDDPointerVectorCExpressionVisitor(this.predmgr, precision, this.bvmgr, this.machineModel, location, pPointerInfo));
        targetType = targetType.getCanonicalType();
        if (value != null && targetType instanceof CSimpleType) {
            CType sourceType = exp.getExpressionType().getCanonicalType();
            value = this.bvmgr.toBitsize(this.machineModel.getSizeofInBits((CSimpleType)targetType), sourceType instanceof CSimpleType && this.machineModel.isSigned((CSimpleType)sourceType), value);
        }
        return value;
    }
}

