/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.math.IntMath;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;

public class BitvectorManager {
    private final RegionManager rmgr;

    public BitvectorManager(RegionManager pRmgr) {
        this.rmgr = pRmgr;
    }

    private int getBitSize(Region[] r1, Region[] r2) {
        assert (r1.length == r2.length) : "bitvectors must have equal length";
        return r1.length;
    }

    public Region makeOr(Region[] regions) {
        Region tmp = this.rmgr.makeFalse();
        for (Region r : regions) {
            tmp = this.rmgr.makeOr(tmp, r);
        }
        return tmp;
    }

    public Region[] makeNumber(long n, int size) {
        return this.makeNumber(BigInteger.valueOf(n), size);
    }

    public Region[] makeNumber(BigInteger n, int size) {
        if (n.signum() == -1) {
            n = BigInteger.ONE.shiftLeft(size).add(n);
        }
        Region[] newRegions = new Region[size];
        for (int i = 0; i < size; ++i) {
            newRegions[i] = n.testBit(i) ? this.rmgr.makeTrue() : this.rmgr.makeFalse();
        }
        return newRegions;
    }

    public Region makeNot(Region ... regions) {
        Region tmp = this.rmgr.makeFalse();
        for (Region r : regions) {
            tmp = this.rmgr.makeOr(tmp, r);
        }
        return this.rmgr.makeNot(tmp);
    }

    public Region[] makeBinaryAnd(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeAnd(r1[i], r2[i]);
        }
        return newRegions;
    }

    @Deprecated
    public Region makeLogicalAnd(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region tmp1 = this.rmgr.makeFalse();
        Region tmp2 = this.rmgr.makeFalse();
        for (int i = 0; i < bitsize; ++i) {
            tmp1 = this.rmgr.makeOr(tmp1, r1[i]);
            tmp2 = this.rmgr.makeOr(tmp2, r2[i]);
        }
        return this.rmgr.makeAnd(tmp1, tmp2);
    }

    public Region[] makeBinaryOr(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeOr(r1[i], r2[i]);
        }
        return newRegions;
    }

    @Deprecated
    public Region makeLogicalOr(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region tmp1 = this.rmgr.makeFalse();
        Region tmp2 = this.rmgr.makeFalse();
        for (int i = 0; i < bitsize; ++i) {
            tmp1 = this.rmgr.makeOr(tmp1, r1[i]);
            tmp2 = this.rmgr.makeOr(tmp2, r2[i]);
        }
        return this.rmgr.makeOr(tmp1, tmp2);
    }

    public Region[] makeBinaryEqual(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeEqual(r1[i], r2[i]);
        }
        return newRegions;
    }

    public Region makeLogicalEqual(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region equality = this.rmgr.makeTrue();
        for (int i = 0; i < bitsize; ++i) {
            Region equalPos = this.rmgr.makeEqual(r1[i], r2[i]);
            equality = this.rmgr.makeAnd(equality, equalPos);
        }
        return equality;
    }

    public Region[] makeXor(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            newRegions[i] = this.rmgr.makeUnequal(r1[i], r2[i]);
        }
        return newRegions;
    }

    public Region[] makeAdd(Region[] r1, Region[] r2) {
        Region carrier = this.rmgr.makeFalse();
        return this.fullAdder(r1, r2, carrier);
    }

    public Region[] makeSub(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] r2tmp = this.makeBinaryEqual(r2, this.makeNumber(BigInteger.ZERO, bitsize));
        Region carrier = this.rmgr.makeTrue();
        return this.fullAdder(r1, r2tmp, carrier);
    }

    private Region[] fullAdder(Region[] r1, Region[] r2, Region carrier) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] newRegions = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            Region xor = this.rmgr.makeUnequal(r1[i], r2[i]);
            Region and = this.rmgr.makeAnd(r1[i], r2[i]);
            newRegions[i] = this.rmgr.makeUnequal(carrier, xor);
            Region tmp = this.rmgr.makeAnd(carrier, xor);
            carrier = this.rmgr.makeOr(tmp, and);
        }
        return newRegions;
    }

    public Region makeLess(Region[] A, Region[] B, boolean signed) {
        return this.makeLess(A, B, false, signed);
    }

    public Region makeLessOrEqual(Region[] A, Region[] B, boolean signed) {
        return this.makeLess(A, B, true, signed);
    }

    private Region makeLess(Region[] A, Region[] B, boolean equal, boolean signed) {
        Region equalFirst;
        int bitsize = this.getBitSize(A, B);
        Region less = equal ? this.rmgr.makeTrue() : this.rmgr.makeFalse();
        for (int i = 0; i < (signed ? bitsize - 1 : bitsize); ++i) {
            Region lessFirst = this.rmgr.makeAnd(this.rmgr.makeNot(A[i]), B[i]);
            equalFirst = this.rmgr.makeEqual(A[i], B[i]);
            less = this.rmgr.makeOr(lessFirst, this.rmgr.makeAnd(equalFirst, less));
        }
        if (signed) {
            int firstPos = bitsize - 1;
            Region invLessFirst = this.rmgr.makeAnd(A[firstPos], this.rmgr.makeNot(B[firstPos]));
            equalFirst = this.rmgr.makeEqual(A[firstPos], B[firstPos]);
            less = this.rmgr.makeOr(invLessFirst, this.rmgr.makeAnd(equalFirst, less));
        }
        return less;
    }

    public Region[] makeShiftLeft(Region[] r1, Region[] r2) {
        int bitsize = r1.length;
        int shiftsize = IntMath.log2((int)bitsize, (RoundingMode)RoundingMode.FLOOR) + 1;
        Region[] result = r1;
        for (int pos = 0; pos < shiftsize; ++pos) {
            int i;
            int shift = 1 << pos;
            Region bit = r2[pos];
            Region[] tmp = new Region[bitsize];
            for (i = 0; i < shift; ++i) {
                tmp[i] = this.rmgr.makeIte(bit, this.rmgr.makeFalse(), result[i]);
            }
            for (i = shift; i < bitsize; ++i) {
                tmp[i] = this.rmgr.makeIte(bit, result[i - shift], result[i]);
            }
            result = tmp;
        }
        return result;
    }

    public Region[] makeShiftRight(Region[] r1, Region[] r2, boolean signed) {
        int bitsize = r1.length;
        int shiftsize = IntMath.log2((int)bitsize, (RoundingMode)RoundingMode.FLOOR) + 1;
        Region[] result = r1;
        for (int pos = 0; pos < shiftsize; ++pos) {
            int i;
            int shift = 1 << pos;
            Region bit = r2[pos];
            Region[] tmp = new Region[bitsize];
            for (i = bitsize - 1; i >= bitsize - shift; --i) {
                tmp[i] = this.rmgr.makeIte(bit, signed ? result[bitsize - 1] : this.rmgr.makeFalse(), result[i]);
            }
            for (i = bitsize - shift - 1; i >= 0; --i) {
                tmp[i] = this.rmgr.makeIte(bit, result[i + shift], result[i]);
            }
            result = tmp;
        }
        return result;
    }

    public Region[] makeMult(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Object[] result = new Region[bitsize];
        Arrays.fill(result, this.rmgr.makeFalse());
        for (int row = 0; row < bitsize; ++row) {
            int i;
            Region[] line = new Region[bitsize];
            for (i = 0; i < row; ++i) {
                line[i] = this.rmgr.makeFalse();
            }
            for (i = row; i < bitsize; ++i) {
                line[i] = this.rmgr.makeAnd(r1[row], r2[i - row]);
            }
            result = this.makeAdd((Region[])result, line);
        }
        return result;
    }

    public Region[] makeDiv(Region[] r1, Region[] r2, boolean signed) {
        return this.makeDivMod(r1, r2, signed).getFirst();
    }

    public Region[] makeMod(Region[] r1, Region[] r2, boolean signed) {
        return this.makeDivMod(r1, r2, signed).getSecond();
    }

    private Pair<Region[], Region[]> makeDivMod(Region[] r1, Region[] r2, boolean signed) {
        if (signed) {
            int bitsize = this.getBitSize(r1, r2);
            Region isDividendNegative = r1[bitsize - 1];
            Region isDivisorNegative = r2[bitsize - 1];
            Region[] unsignedR1 = this.negateIf(isDividendNegative, r1);
            Region[] unsignedR2 = this.negateIf(isDivisorNegative, r2);
            Pair<Region[], Region[]> divMod = this.makeDivModUnsigned(unsignedR1, unsignedR2);
            Region[] quotient = this.negateIf(this.rmgr.makeUnequal(isDividendNegative, isDivisorNegative), divMod.getFirst());
            Region[] remainder = this.negateIf(isDividendNegative, divMod.getSecond());
            return Pair.of(quotient, remainder);
        }
        return this.makeDivModUnsigned(r1, r2);
    }

    private Region[] negateIf(Region condition, Region[] r) {
        int bitsize = r.length;
        Region[] zero = this.makeNumber(0L, bitsize);
        Region[] neg = this.makeSub(zero, r);
        Region[] result = new Region[bitsize];
        for (int i = 0; i < bitsize; ++i) {
            result[i] = this.rmgr.makeIte(condition, neg[i], r[i]);
        }
        return result;
    }

    private Pair<Region[], Region[]> makeDivModUnsigned(Region[] r1, Region[] r2) {
        int bitsize = this.getBitSize(r1, r2);
        Region[] resultDiv = new Region[bitsize];
        Object[] rest = new Region[bitsize];
        Arrays.fill(rest, this.rmgr.makeFalse());
        for (int pos = bitsize - 1; pos >= 0; --pos) {
            Region[] shiftedRest = new Region[bitsize];
            shiftedRest[0] = r1[pos];
            for (int i = 1; i < bitsize; ++i) {
                shiftedRest[i] = rest[i - 1];
            }
            Region less = this.makeLessOrEqual(r2, shiftedRest, false);
            Region[] sub = this.makeSub(shiftedRest, r2);
            Region[] tmp = new Region[bitsize];
            for (int i = 0; i < bitsize; ++i) {
                tmp[i] = this.rmgr.makeIte(less, sub[i], shiftedRest[i]);
            }
            resultDiv[pos] = less;
            rest = tmp;
        }
        return Pair.of(resultDiv, rest);
    }

    public Region[] wrapLast(Region r, int size) {
        return this.toBitsize(size, false, r);
    }

    public Region[] toBitsize(int bitsize, boolean signed, Region ... regions) {
        assert (regions != null) : "can not expand NULL";
        int min = Math.min(regions.length, bitsize);
        Region[] newRegions = new Region[bitsize];
        System.arraycopy(regions, 0, newRegions, 0, min);
        for (int i = min; i < bitsize; ++i) {
            newRegions[i] = signed ? regions[regions.length - 1] : this.rmgr.makeFalse();
        }
        return newRegions;
    }
}

