/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.bdd.BitvectorManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.predicates.regions.RegionManager;

@RunWith(value=Parameterized.class)
public class BitvectorManagerTest {
    private LogManager logger;
    private RegionManager rmgr;
    private BitvectorManager bvmgr;
    private Region[] zero;
    private Region[] one;
    private Region[] two;
    private Region[] n5;
    private Region[] n7;
    private Region[] n15;
    private Region[] n16;
    private Region[] neg1;
    private Region[] neg3;
    private Region[] neg5;
    private Region[] neg25;
    private Region[] neg35;
    private ImmutableList<Region[]> numbers;
    private ImmutableList<Region[]> numbersNotZero;
    private int bitsize;

    @Parameterized.Parameters
    public static Collection<Integer> bitsize() {
        return ImmutableList.of((Object)4, (Object)5, (Object)6, (Object)8, (Object)10, (Object)12, (Object)16, (Object)32);
    }

    public BitvectorManagerTest(int pBitsize) {
        this.bitsize = pBitsize;
    }

    @Before
    public void init() throws InvalidConfigurationException {
        Configuration config = Configuration.defaultConfiguration();
        this.logger = LogManager.createTestLogManager();
        this.rmgr = new BDDManagerFactory(config, this.logger).createRegionManager();
        this.bvmgr = new BitvectorManager(this.rmgr);
        this.zero = this.bvmgr.makeNumber(BigInteger.ZERO, this.bitsize);
        this.one = this.bvmgr.makeNumber(BigInteger.ONE, this.bitsize);
        this.two = this.bvmgr.makeNumber(BigInteger.valueOf(2L), this.bitsize);
        this.n5 = this.bvmgr.makeNumber(BigInteger.valueOf(5L), this.bitsize);
        this.n7 = this.bvmgr.makeNumber(BigInteger.valueOf(7L), this.bitsize);
        this.n15 = this.bvmgr.makeNumber(BigInteger.valueOf(15L), this.bitsize);
        this.n16 = this.bvmgr.makeNumber(BigInteger.valueOf(16L), this.bitsize);
        this.neg1 = this.bvmgr.makeNumber(BigInteger.valueOf(-1L), this.bitsize);
        this.neg3 = this.bvmgr.makeNumber(BigInteger.valueOf(-3L), this.bitsize);
        this.neg5 = this.bvmgr.makeNumber(BigInteger.valueOf(-5L), this.bitsize);
        this.neg25 = this.bvmgr.makeNumber(BigInteger.valueOf(-25L), this.bitsize);
        this.neg35 = this.bvmgr.makeNumber(BigInteger.valueOf(-35L), this.bitsize);
        this.numbers = ImmutableList.of((Object)this.zero, (Object)this.one, (Object)this.two, (Object)this.n5, (Object)this.n7, (Object)this.n15, (Object)this.n16, (Object)this.neg1, (Object)this.neg3, (Object)this.neg5, (Object)this.neg25, (Object)this.neg35, (Object[])new Region[0][]);
        this.numbersNotZero = ImmutableList.of((Object)this.one, (Object)this.two, (Object)this.n5, (Object)this.n7, (Object)this.n15, (Object)this.neg1, (Object)this.neg3, (Object)this.neg5);
    }

    private void assertIsTrue(Region r) {
        Truth.assertThat((Boolean)r.isTrue()).isTrue();
    }

    private void assertIsFalse(Region r) {
        Truth.assertThat((Boolean)r.isFalse()).isTrue();
    }

    private void assertEqual(Region[] r1, Region[] r2) {
        Truth.assertThat((Object[])r1).hasLength(r2.length);
        Truth.assertWithMessage((String)(BitvectorManagerTest.toString(r1) + " != " + BitvectorManagerTest.toString(r2))).that((Object[])r2).isEqualTo((Object)r1);
    }

    private void assertDistinct(Region[] r1, Region[] r2) {
        Truth.assertThat((Object[])r1).hasLength(r2.length);
        Truth.assertThat((Object[])r1).isNotEqualTo((Object)r2);
    }

    @Test
    public void selfTest() {
        int i;
        this.assertDistinct(this.zero, this.one);
        this.assertDistinct(this.neg1, this.one);
        for (i = 0; i < this.bitsize; ++i) {
            this.assertIsFalse(this.zero[i]);
        }
        this.assertIsTrue(this.one[0]);
        for (i = 1; i < this.bitsize; ++i) {
            this.assertIsFalse(this.one[i]);
        }
    }

    @Test(expected=AssertionError.class)
    public void differentLen() {
        this.bvmgr.makeAdd(this.bvmgr.makeNumber(BigInteger.ONE, 3), this.bvmgr.makeNumber(BigInteger.ONE, 4));
    }

    @Test
    public void addsub() {
        this.assertEqual(this.one, this.bvmgr.makeAdd(this.zero, this.one));
        this.assertEqual(this.two, this.bvmgr.makeAdd(this.one, this.one));
        this.assertEqual(this.two, this.bvmgr.makeSub(this.neg3, this.neg5));
        this.assertEqual(this.neg5, this.bvmgr.makeSub(this.neg3, this.two));
        for (Region[] m : this.numbers) {
            this.assertEqual(m, this.bvmgr.makeAdd(m, this.zero));
            this.assertEqual(this.zero, this.bvmgr.makeSub(m, m));
            for (Region[] n : this.numbers) {
                this.assertEqual(m, this.bvmgr.makeSub(this.bvmgr.makeAdd(m, n), n));
                this.assertEqual(m, this.bvmgr.makeSub(this.bvmgr.makeAdd(n, m), n));
                this.assertEqual(m, this.bvmgr.makeAdd(this.bvmgr.makeSub(m, n), n));
                this.assertEqual(m, this.bvmgr.makeAdd(n, this.bvmgr.makeSub(m, n)));
            }
        }
    }

    @Test
    public void bool() {
        for (Region[] n : ImmutableList.of((Object)this.one, (Object)this.two, (Object)this.n5, (Object)this.n7, (Object)this.n15, (Object)this.neg1, (Object)this.neg3, (Object)this.neg5)) {
            this.assertIsFalse(this.bvmgr.makeNot(n));
        }
        this.assertIsTrue(this.bvmgr.makeNot(this.zero));
        this.assertEqual(this.zero, this.bvmgr.makeBinaryAnd(this.one, this.two));
        this.assertEqual(this.zero, this.bvmgr.makeBinaryAnd(this.one, this.zero));
        this.assertEqual(this.one, this.bvmgr.makeBinaryAnd(this.one, this.one));
        this.assertEqual(this.one, this.bvmgr.makeBinaryAnd(this.one, this.bvmgr.makeAdd(this.one, this.two)));
        this.assertIsTrue(this.bvmgr.makeLogicalEqual(this.one, this.one));
        this.assertIsTrue(this.bvmgr.makeLogicalEqual(this.two, this.two));
        this.assertEqual(this.bvmgr.makeBinaryEqual(this.one, this.one), this.bvmgr.makeSub(this.zero, this.one));
        this.assertEqual(this.bvmgr.makeBinaryEqual(this.zero, this.zero), this.bvmgr.makeSub(this.one, this.two));
        this.assertEqual(this.bvmgr.makeXor(this.one, this.two), this.bvmgr.makeAdd(this.one, this.two));
        this.assertEqual(this.bvmgr.makeXor(this.one, this.zero), this.one);
    }

    private void assertEqualwithLen4(Region[] a, Region[] b) {
        this.assertEqual(this.bvmgr.toBitsize(4, true, a), this.bvmgr.toBitsize(4, true, b));
    }

    @Test
    public void signedLen4() {
        TruthJUnit.assume().withMessage("test is designed for a minimal bitsize of 4").that(Integer.valueOf(this.bitsize)).isAtLeast((Comparable)Integer.valueOf(4));
        this.assertEqualwithLen4(this.zero, this.bvmgr.makeAdd(this.neg1, this.one));
        this.assertEqualwithLen4(this.one, this.bvmgr.makeAdd(this.neg1, this.two));
        this.assertEqualwithLen4(this.neg1, this.bvmgr.makeSub(this.zero, this.one));
        this.assertEqualwithLen4(this.neg1, this.bvmgr.makeSub(this.one, this.two));
        this.assertEqualwithLen4(this.neg1, this.n15);
        Region[] sum = this.one;
        for (int i = 0; i < 4; ++i) {
            sum = this.bvmgr.makeAdd(sum, sum);
        }
        this.assertEqualwithLen4(this.zero, sum);
    }

    @Test
    public void lessSigned() {
        for (Region[] n : this.numbers) {
            this.assertIsFalse(this.bvmgr.makeLess(n, n, true));
        }
        this.assertIsFalse(this.bvmgr.makeLess(this.one, this.zero, true));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.one, true));
        this.assertIsTrue(this.bvmgr.makeLess(this.neg1, this.zero, true));
        this.assertIsFalse(this.bvmgr.makeLess(this.zero, this.neg1, true));
    }

    @Test
    public void lessUnsigned() {
        for (Region[] n : this.numbers) {
            this.assertIsFalse(this.bvmgr.makeLess(n, n, false));
        }
        this.assertIsFalse(this.bvmgr.makeLess(this.one, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.one, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.two, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.n5, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.n7, false));
        this.assertIsFalse(this.bvmgr.makeLess(this.neg1, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLess(this.zero, this.neg1, false));
    }

    @Test
    public void lessOrEqualSigned() {
        for (Region[] n : this.numbers) {
            this.assertIsTrue(this.bvmgr.makeLessOrEqual(n, n, true));
        }
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.one, this.zero, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.one, true));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.neg1, this.zero, true));
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.zero, this.neg1, true));
    }

    @Test
    public void lessOrEqualUnsigned() {
        for (Region[] n : this.numbers) {
            this.assertIsTrue(this.bvmgr.makeLessOrEqual(n, n, false));
        }
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.one, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.one, false));
        this.assertIsFalse(this.bvmgr.makeLessOrEqual(this.neg1, this.zero, false));
        this.assertIsTrue(this.bvmgr.makeLessOrEqual(this.zero, this.neg1, false));
    }

    @Test
    public void shiftLeft() {
        for (Region[] n : this.numbers) {
            this.assertEqual(n, this.bvmgr.makeShiftLeft(n, this.zero));
            this.assertEqual(this.zero, this.bvmgr.makeShiftLeft(this.zero, n));
            Region[] twice = this.bvmgr.makeAdd(n, n);
            this.assertEqual(twice, this.bvmgr.makeShiftLeft(n, this.one));
            this.assertEqual(this.bvmgr.makeAdd(twice, twice), this.bvmgr.makeShiftLeft(n, this.two));
        }
        this.assertEqual(this.n16, this.bvmgr.makeShiftLeft(this.one, this.bvmgr.makeAdd(this.two, this.two)));
    }

    @Test
    public void shiftRightUnsigned() {
        for (Region[] n : this.numbers) {
            this.assertEqual(n, this.bvmgr.makeShiftRight(n, this.zero, false));
            this.assertEqual(this.zero, this.bvmgr.makeShiftRight(this.zero, n, false));
        }
        this.assertEqual(this.one, this.bvmgr.makeShiftRight(this.two, this.one, false));
        this.assertEqual(this.one, this.bvmgr.makeShiftRight(this.n5, this.two, false));
        this.assertEqual(this.one, this.bvmgr.makeShiftRight(this.n7, this.two, false));
    }

    @Test
    public void shiftRightSigned() {
        for (Region[] n : this.numbers) {
            this.assertEqual(n, this.bvmgr.makeShiftRight(n, this.zero, true));
            this.assertEqual(this.zero, this.bvmgr.makeShiftRight(this.zero, n, true));
            Region[] minus1 = this.bvmgr.makeSub(this.zero, this.one);
            this.assertEqual(minus1, this.bvmgr.makeShiftRight(minus1, n, true));
        }
        this.assertEqual(this.one, this.bvmgr.makeShiftRight(this.two, this.one, true));
        this.assertEqual(this.one, this.bvmgr.makeShiftRight(this.n5, this.two, true));
        this.assertEqual(this.one, this.bvmgr.makeShiftRight(this.n7, this.two, true));
    }

    @Test
    public void mult() {
        for (Region[] n : this.numbers) {
            this.assertEqual(this.zero, this.bvmgr.makeMult(n, this.zero));
            this.assertEqual(this.zero, this.bvmgr.makeMult(this.zero, n));
            this.assertEqual(n, this.bvmgr.makeMult(n, this.one));
            this.assertEqual(n, this.bvmgr.makeMult(this.one, n));
        }
        this.assertEqual(this.n16, this.bvmgr.makeMult(this.bvmgr.makeMult(this.two, this.two), this.bvmgr.makeMult(this.two, this.two)));
        this.assertEqual(this.n15, this.bvmgr.makeMult(this.neg3, this.neg5));
        this.assertEqual(this.n15, this.bvmgr.makeMult(this.neg5, this.neg3));
        this.assertEqual(this.bvmgr.makeMult(this.neg1, this.neg25), this.bvmgr.makeMult(this.neg5, this.neg5));
        this.assertEqual(this.neg35, this.bvmgr.makeMult(this.neg5, this.n7));
        this.assertEqual(this.neg35, this.bvmgr.makeMult(this.n7, this.neg5));
    }

    @Test
    public void divSigned() {
        for (Region[] n : this.numbersNotZero) {
            this.assertEqual(this.zero, this.bvmgr.makeDiv(this.zero, n, true));
            this.assertEqual(n, this.bvmgr.makeDiv(n, this.one, true));
            this.assertEqual(this.bvmgr.makeMult(this.neg1, n), this.bvmgr.makeDiv(n, this.neg1, true));
        }
        this.assertEqual(this.zero, this.bvmgr.makeDiv(this.two, this.neg3, true));
        this.assertEqual(this.neg1, this.bvmgr.makeDiv(this.bvmgr.makeAdd(this.two, this.two), this.neg3, true));
        this.assertEqual(this.zero, this.bvmgr.makeDiv(this.bvmgr.makeAdd(this.two, this.two), this.neg5, true));
        this.assertEqual(this.two, this.bvmgr.makeDiv(this.bvmgr.makeAdd(this.two, this.two), this.two, true));
        if (this.bitsize > 6) {
            this.assertEqual(this.neg3, this.bvmgr.makeDiv(this.n15, this.neg5, true));
            this.assertEqual(this.neg5, this.bvmgr.makeDiv(this.n15, this.neg3, true));
            this.assertEqual(this.neg5, this.bvmgr.makeDiv(this.neg25, this.n5, true));
            this.assertEqual(this.n5, this.bvmgr.makeDiv(this.neg25, this.neg5, true));
            this.assertEqual(this.n7, this.bvmgr.makeDiv(this.neg35, this.neg5, true));
        }
    }

    @Test
    public void divUnsigned() {
        for (Region[] n : this.numbersNotZero) {
            this.assertEqual(this.zero, this.bvmgr.makeDiv(this.zero, n, false));
            this.assertEqual(n, this.bvmgr.makeDiv(n, this.one, false));
        }
        this.assertEqual(this.zero, this.bvmgr.makeDiv(this.two, this.neg3, false));
        this.assertEqual(this.zero, this.bvmgr.makeDiv(this.bvmgr.makeAdd(this.two, this.two), this.neg5, false));
        this.assertEqual(this.two, this.bvmgr.makeDiv(this.bvmgr.makeAdd(this.two, this.two), this.two, false));
    }

    @Test
    public void divModSpecial() {
        this.assertEqual(this.neg1, this.bvmgr.makeDiv(this.n5, this.zero, false));
        this.assertEqual(this.neg1, this.bvmgr.makeDiv(this.n5, this.zero, true));
        this.assertEqual(this.n5, this.bvmgr.makeMod(this.n5, this.zero, false));
        this.assertEqual(this.n5, this.bvmgr.makeMod(this.n5, this.zero, true));
        this.assertEqual(this.neg1, this.bvmgr.makeDiv(this.neg5, this.zero, false));
        this.assertEqual(this.one, this.bvmgr.makeDiv(this.neg5, this.zero, true));
        this.assertEqual(this.neg5, this.bvmgr.makeMod(this.neg5, this.zero, false));
        this.assertEqual(this.neg5, this.bvmgr.makeMod(this.neg5, this.zero, true));
        Region[] big = this.bvmgr.makeNumber(1 << this.bitsize - 1, this.bitsize);
        this.assertEqual(this.neg1, this.bvmgr.makeDiv(big, this.zero, false));
        this.assertEqual(this.one, this.bvmgr.makeDiv(big, this.zero, true));
        this.assertEqual(big, this.bvmgr.makeMod(big, this.zero, false));
        this.assertEqual(big, this.bvmgr.makeMod(big, this.zero, true));
        this.assertEqual(this.zero, this.bvmgr.makeDiv(big, this.neg1, false));
        this.assertEqual(big, this.bvmgr.makeDiv(big, this.neg1, true));
        this.assertEqual(big, this.bvmgr.makeMod(big, this.neg1, false));
        this.assertEqual(this.zero, this.bvmgr.makeMod(big, this.neg1, true));
    }

    @Test
    public void modSigned() {
        for (Region[] n : this.numbersNotZero) {
            this.assertEqual(this.zero, this.bvmgr.makeMod(n, n, true));
            this.assertEqual(this.zero, this.bvmgr.makeMod(this.zero, n, true));
            this.assertEqual(this.zero, this.bvmgr.makeMod(n, this.one, true));
        }
        if (this.bitsize > 6) {
            this.assertEqual(this.zero, this.bvmgr.makeMod(this.neg25, this.n5, true));
            this.assertEqual(this.zero, this.bvmgr.makeMod(this.neg35, this.n5, true));
            this.assertEqual(this.zero, this.bvmgr.makeMod(this.neg25, this.neg5, true));
            this.assertEqual(this.zero, this.bvmgr.makeMod(this.neg35, this.neg5, true));
        }
    }

    @Test
    public void modUnsigned() {
        for (Region[] n : this.numbersNotZero) {
            this.assertEqual(this.zero, this.bvmgr.makeMod(n, n, false));
            this.assertEqual(this.zero, this.bvmgr.makeMod(this.zero, n, false));
            this.assertEqual(this.zero, this.bvmgr.makeMod(n, this.one, false));
        }
        this.assertEqual(this.zero, this.bvmgr.makeMod(this.bvmgr.makeAdd(this.two, this.two), this.two, false));
    }

    private static String toString(Region[] r) {
        StringBuilder str = new StringBuilder("[ ");
        for (int i = r.length - 1; i >= 0; --i) {
            Region bit = r[i];
            str.append(bit.isFalse() ? "0" : (bit.isTrue() ? "1" : bit));
        }
        return str.append(" ]").toString();
    }
}

