/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sosy_lab.common.collect.CopyOnWriteSortedMap;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.bdd.BDDPartitionOrderer;
import org.sosy_lab.cpachecker.util.predicates.regions.NamedRegionManager;
import org.sosy_lab.cpachecker.util.predicates.regions.Region;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;

@Options(prefix="cpa.bdd")
public class PredicateManager {
    @Option(secure=true, description="declare first bit of all vars, then second bit,...")
    private boolean initBitwise = true;
    @Option(secure=true, description="declare the bits of a var from 0 to N or from N to 0")
    private boolean initBitsIncreasing = true;
    @Option(secure=true, description="declare partitions ordered")
    private boolean initPartitionsOrdered = true;
    @Option(secure=true, description="declare vars partitionwise")
    private boolean initPartitions = true;
    protected static final String TMP_VARIABLE_PREFIX = "__CPAchecker_tmp_var_";
    @Option(secure=true, description="add some additional variables (with prefix) for each variable that can be used for more complex BDD operations later. In the ordering, we declare them as narrow as possible to the original variable, such that the overhead for using them stays small. A value 0 disables this feature.")
    private int initAdditionalVariables = 0;
    protected static final String TMP_VARIABLE = "__CPAchecker_tmp_var";
    private final ImmutableMap<Partition, String> varsToTmpVar;
    private final CopyOnWriteSortedMap<String, Integer> trackedVars = CopyOnWriteSortedMap.copyOf((PersistentSortedMap)PathCopyingPersistentTreeMap.of());
    private final NamedRegionManager rmgr;

    PredicateManager(Configuration config, NamedRegionManager pRmgr, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.rmgr = pRmgr;
        this.varsToTmpVar = this.initPartitions ? this.initVars(pCfa) : null;
    }

    Collection<String> getTrackedVars() {
        return this.trackedVars.keySet();
    }

    String getTmpVariableForPartition(Partition pPartition) {
        if (this.initPartitions) {
            return (String)this.varsToTmpVar.get((Object)pPartition);
        }
        return TMP_VARIABLE;
    }

    private ImmutableMap<Partition, String> initVars(CFA cfa) {
        Collection<Partition> partitions;
        if (this.initPartitionsOrdered) {
            BDDPartitionOrderer d = new BDDPartitionOrderer(cfa);
            partitions = d.getOrderedPartitions();
        } else {
            assert (cfa.getVarClassification().isPresent());
            partitions = cfa.getVarClassification().orElseThrow().getPartitions();
        }
        LinkedHashMap<Partition, String> partitionToTmpVar = new LinkedHashMap<Partition, String>();
        int bitsize = PredicateManager.getMaxBitsize(cfa.getMachineModel());
        for (Partition partition : partitions) {
            this.createPredicates(partition, bitsize, partitionToTmpVar);
        }
        return ImmutableMap.copyOf(partitionToTmpVar);
    }

    static int getMaxBitsize(MachineModel machineModel) {
        return machineModel.getSizeofLongLongInt() * machineModel.getSizeofCharInBits();
    }

    private void createPredicates(Partition pPartition, int bitsize, Map<Partition, String> partitionToTmpVar) {
        block7: {
            String tmpVar;
            block6: {
                assert (bitsize >= 1) : "you need at least one bit for a variable.";
                tmpVar = TMP_VARIABLE_PREFIX + partitionToTmpVar.size();
                partitionToTmpVar.put(pPartition, tmpVar);
                if (!this.initBitwise) break block6;
                boolean isTrackingSomething = false;
                for (int i = 0; i < bitsize; ++i) {
                    int index = this.initBitsIncreasing ? i : bitsize - i - 1;
                    for (String var : pPartition.getVars()) {
                        this.createPredicateDirectly(var, index);
                        isTrackingSomething = true;
                    }
                    if (!isTrackingSomething) continue;
                    this.createPredicateDirectly(tmpVar, index);
                }
                break block7;
            }
            boolean isTrackingSomething = false;
            for (String var : pPartition.getVars()) {
                for (int i = 0; i < bitsize; ++i) {
                    int index = this.initBitsIncreasing ? i : bitsize - i - 1;
                    this.createPredicateDirectly(var, index);
                    isTrackingSomething = true;
                }
            }
            if (!isTrackingSomething) break block7;
            for (int i = 0; i < bitsize; ++i) {
                int index = this.initBitsIncreasing ? i : bitsize - i - 1;
                this.createPredicateDirectly(tmpVar, index);
            }
        }
    }

    private void createPredicateDirectly(String varName, int index) {
        this.createPredicateDirectly0(varName, index);
        for (int i = 0; i < this.initAdditionalVariables; ++i) {
            this.createPredicateDirectly0(this.getAdditionalVariableWithIndex(varName, i), index);
        }
    }

    int getNumberOfAdditionalVariables() {
        return this.initAdditionalVariables;
    }

    String getAdditionalVariableWithIndex(String varName, int i) {
        return TMP_VARIABLE_PREFIX + i + "__" + varName;
    }

    private Region createPredicateDirectly0(String varName, int index) {
        return this.rmgr.createPredicate(varName + "@" + index);
    }

    Region[] createPredicateWithoutPrecisionCheck(String varName) {
        assert (this.trackedVars.containsKey((Object)varName)) : "variable should already be known: " + varName;
        return this.createPredicateWithoutPrecisionCheck(varName, (Integer)this.trackedVars.get((Object)varName));
    }

    Region[] createPredicateWithoutPrecisionCheck(String varName, int size) {
        Integer oldSize = (Integer)this.trackedVars.get((Object)varName);
        if (oldSize == null || oldSize < size) {
            this.trackedVars.put((Object)varName, (Object)size);
        }
        Region[] newRegions = new Region[size];
        for (int i = size - 1; i >= 0; --i) {
            newRegions[i] = this.createPredicateDirectly0(varName, i);
        }
        return newRegions;
    }

    Region[] createPredicate(String varName, CType varType, CFANode location, int size, VariableTrackingPrecision precision) {
        if (precision != null && !precision.isTracking(MemoryLocation.fromQualifiedName(varName), varType, location)) {
            return null;
        }
        if (!(varType.getCanonicalType() instanceof CSimpleType)) {
            return null;
        }
        return this.createPredicateWithoutPrecisionCheck(varName, size);
    }
}

