/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.bdd;

import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cpa.bdd.BDDTransferRelation;
import org.sosy_lab.cpachecker.exceptions.NoException;

class VarCExpressionVisitor
extends DefaultCExpressionVisitor<Boolean, NoException> {
    private String varName;

    VarCExpressionVisitor(String var) {
        this.varName = var;
    }

    private Boolean handle(CExpression exp) {
        String name = BDDTransferRelation.getCanonicalName(exp);
        return this.varName.equals(name == null ? exp.toASTString() : name);
    }

    @Override
    public Boolean visit(CArraySubscriptExpression exp) {
        return this.handle(exp);
    }

    @Override
    public Boolean visit(CBinaryExpression exp) {
        return exp.getOperand1().accept(this) != false || exp.getOperand2().accept(this) != false;
    }

    @Override
    public Boolean visit(CCastExpression exp) {
        return exp.getOperand().accept(this);
    }

    @Override
    public Boolean visit(CComplexCastExpression exp) {
        return exp.getOperand().accept(this);
    }

    @Override
    public Boolean visit(CFieldReference exp) {
        return this.handle(exp);
    }

    @Override
    public Boolean visit(CIdExpression exp) {
        return this.varName.equals(exp.getDeclaration().getQualifiedName());
    }

    @Override
    public Boolean visit(CUnaryExpression exp) {
        return exp.getOperand().accept(this);
    }

    @Override
    public Boolean visit(CPointerExpression exp) {
        return exp.getOperand().accept(this);
    }

    @Override
    protected Boolean visitDefault(CExpression pExp) {
        return false;
    }
}

